/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashLongLongMap}s.
 *
 * @see HashLongLongMap
 * @see HashLongLongMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashLongLongMapFactory
        extends LongLongMapFactory<HashLongLongMapFactory>
        , LongHashFactory<HashLongLongMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashLongLongMap newMutableMap();

    @Override
    @Nonnull
     HashLongLongMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashLongLongMap newMutableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2, int expectedSize);

    @Override
    @Nonnull
     HashLongLongMap newMutableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2,
            @Nonnull Map<Long, Long> map3, int expectedSize);

    @Override
    @Nonnull
     HashLongLongMap newMutableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2,
            @Nonnull Map<Long, Long> map3,
            @Nonnull Map<Long, Long> map4, int expectedSize);

    @Override
    @Nonnull
     HashLongLongMap newMutableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2,
            @Nonnull Map<Long, Long> map3,
            @Nonnull Map<Long, Long> map4,
            @Nonnull Map<Long, Long> map5, int expectedSize);



    @Override
    @Nonnull
     HashLongLongMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.LongLongConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashLongLongMap newMutableMap(
            @Nonnull long[] keys, @Nonnull long[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongLongMap newMutableMap(
            @Nonnull Long[] keys, @Nonnull Long[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongLongMap newMutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Long> values, int expectedSize);

    

    @Override
    @Nonnull
     HashLongLongMap newMutableMap(
            @Nonnull Map<Long, Long> map);

    @Override
    @Nonnull
     HashLongLongMap newMutableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2);

    @Override
    @Nonnull
     HashLongLongMap newMutableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2,
            @Nonnull Map<Long, Long> map3);

    @Override
    @Nonnull
     HashLongLongMap newMutableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2,
            @Nonnull Map<Long, Long> map3,
            @Nonnull Map<Long, Long> map4);

    @Override
    @Nonnull
     HashLongLongMap newMutableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2,
            @Nonnull Map<Long, Long> map3,
            @Nonnull Map<Long, Long> map4,
            @Nonnull Map<Long, Long> map5);



    @Override
    @Nonnull
     HashLongLongMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.LongLongConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashLongLongMap newMutableMap(
            @Nonnull long[] keys, @Nonnull long[] values);

    @Override
    @Nonnull
     HashLongLongMap newMutableMap(
            @Nonnull Long[] keys, @Nonnull Long[] values);

    @Override
    @Nonnull
     HashLongLongMap newMutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Long> values);


    @Override
    @Nonnull
     HashLongLongMap newMutableMapOf(long k1, long v1);

    @Override
    @Nonnull
     HashLongLongMap newMutableMapOf(long k1, long v1,
            long k2, long v2);

    @Override
    @Nonnull
     HashLongLongMap newMutableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3);

    @Override
    @Nonnull
     HashLongLongMap newMutableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3,
            long k4, long v4);

    @Override
    @Nonnull
     HashLongLongMap newMutableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3,
            long k4, long v4, long k5, long v5);
    @Override
    @Nonnull
     HashLongLongMap newUpdatableMap();

    @Override
    @Nonnull
     HashLongLongMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashLongLongMap newUpdatableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2, int expectedSize);

    @Override
    @Nonnull
     HashLongLongMap newUpdatableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2,
            @Nonnull Map<Long, Long> map3, int expectedSize);

    @Override
    @Nonnull
     HashLongLongMap newUpdatableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2,
            @Nonnull Map<Long, Long> map3,
            @Nonnull Map<Long, Long> map4, int expectedSize);

    @Override
    @Nonnull
     HashLongLongMap newUpdatableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2,
            @Nonnull Map<Long, Long> map3,
            @Nonnull Map<Long, Long> map4,
            @Nonnull Map<Long, Long> map5, int expectedSize);



    @Override
    @Nonnull
     HashLongLongMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.LongLongConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashLongLongMap newUpdatableMap(
            @Nonnull long[] keys, @Nonnull long[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongLongMap newUpdatableMap(
            @Nonnull Long[] keys, @Nonnull Long[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongLongMap newUpdatableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Long> values, int expectedSize);

    

    @Override
    @Nonnull
     HashLongLongMap newUpdatableMap(
            @Nonnull Map<Long, Long> map);

    @Override
    @Nonnull
     HashLongLongMap newUpdatableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2);

    @Override
    @Nonnull
     HashLongLongMap newUpdatableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2,
            @Nonnull Map<Long, Long> map3);

    @Override
    @Nonnull
     HashLongLongMap newUpdatableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2,
            @Nonnull Map<Long, Long> map3,
            @Nonnull Map<Long, Long> map4);

    @Override
    @Nonnull
     HashLongLongMap newUpdatableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2,
            @Nonnull Map<Long, Long> map3,
            @Nonnull Map<Long, Long> map4,
            @Nonnull Map<Long, Long> map5);



    @Override
    @Nonnull
     HashLongLongMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.LongLongConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashLongLongMap newUpdatableMap(
            @Nonnull long[] keys, @Nonnull long[] values);

    @Override
    @Nonnull
     HashLongLongMap newUpdatableMap(
            @Nonnull Long[] keys, @Nonnull Long[] values);

    @Override
    @Nonnull
     HashLongLongMap newUpdatableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Long> values);


    @Override
    @Nonnull
     HashLongLongMap newUpdatableMapOf(long k1, long v1);

    @Override
    @Nonnull
     HashLongLongMap newUpdatableMapOf(long k1, long v1,
            long k2, long v2);

    @Override
    @Nonnull
     HashLongLongMap newUpdatableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3);

    @Override
    @Nonnull
     HashLongLongMap newUpdatableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3,
            long k4, long v4);

    @Override
    @Nonnull
     HashLongLongMap newUpdatableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3,
            long k4, long v4, long k5, long v5);

    


    @Override
    @Nonnull
     HashLongLongMap newImmutableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2, int expectedSize);

    @Override
    @Nonnull
     HashLongLongMap newImmutableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2,
            @Nonnull Map<Long, Long> map3, int expectedSize);

    @Override
    @Nonnull
     HashLongLongMap newImmutableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2,
            @Nonnull Map<Long, Long> map3,
            @Nonnull Map<Long, Long> map4, int expectedSize);

    @Override
    @Nonnull
     HashLongLongMap newImmutableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2,
            @Nonnull Map<Long, Long> map3,
            @Nonnull Map<Long, Long> map4,
            @Nonnull Map<Long, Long> map5, int expectedSize);



    @Override
    @Nonnull
     HashLongLongMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.LongLongConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashLongLongMap newImmutableMap(
            @Nonnull long[] keys, @Nonnull long[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongLongMap newImmutableMap(
            @Nonnull Long[] keys, @Nonnull Long[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongLongMap newImmutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Long> values, int expectedSize);

    

    @Override
    @Nonnull
     HashLongLongMap newImmutableMap(
            @Nonnull Map<Long, Long> map);

    @Override
    @Nonnull
     HashLongLongMap newImmutableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2);

    @Override
    @Nonnull
     HashLongLongMap newImmutableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2,
            @Nonnull Map<Long, Long> map3);

    @Override
    @Nonnull
     HashLongLongMap newImmutableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2,
            @Nonnull Map<Long, Long> map3,
            @Nonnull Map<Long, Long> map4);

    @Override
    @Nonnull
     HashLongLongMap newImmutableMap(@Nonnull Map<Long, Long> map1,
            @Nonnull Map<Long, Long> map2,
            @Nonnull Map<Long, Long> map3,
            @Nonnull Map<Long, Long> map4,
            @Nonnull Map<Long, Long> map5);



    @Override
    @Nonnull
     HashLongLongMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.LongLongConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashLongLongMap newImmutableMap(
            @Nonnull long[] keys, @Nonnull long[] values);

    @Override
    @Nonnull
     HashLongLongMap newImmutableMap(
            @Nonnull Long[] keys, @Nonnull Long[] values);

    @Override
    @Nonnull
     HashLongLongMap newImmutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Long> values);


    @Override
    @Nonnull
     HashLongLongMap newImmutableMapOf(long k1, long v1);

    @Override
    @Nonnull
     HashLongLongMap newImmutableMapOf(long k1, long v1,
            long k2, long v2);

    @Override
    @Nonnull
     HashLongLongMap newImmutableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3);

    @Override
    @Nonnull
     HashLongLongMap newImmutableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3,
            long k4, long v4);

    @Override
    @Nonnull
     HashLongLongMap newImmutableMapOf(long k1, long v1,
            long k2, long v2, long k3, long v3,
            long k4, long v4, long k5, long v5);
}
