/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashIntDoubleMap}s.
 *
 * @see HashIntDoubleMap
 * @see HashIntDoubleMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashIntDoubleMapFactory
        extends IntDoubleMapFactory<HashIntDoubleMapFactory>
        , IntHashFactory<HashIntDoubleMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashIntDoubleMap newMutableMap();

    @Override
    @Nonnull
     HashIntDoubleMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashIntDoubleMap newMutableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2, int expectedSize);

    @Override
    @Nonnull
     HashIntDoubleMap newMutableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2,
            @Nonnull Map<Integer, Double> map3, int expectedSize);

    @Override
    @Nonnull
     HashIntDoubleMap newMutableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2,
            @Nonnull Map<Integer, Double> map3,
            @Nonnull Map<Integer, Double> map4, int expectedSize);

    @Override
    @Nonnull
     HashIntDoubleMap newMutableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2,
            @Nonnull Map<Integer, Double> map3,
            @Nonnull Map<Integer, Double> map4,
            @Nonnull Map<Integer, Double> map5, int expectedSize);



    @Override
    @Nonnull
     HashIntDoubleMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.IntDoubleConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashIntDoubleMap newMutableMap(
            @Nonnull int[] keys, @Nonnull double[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntDoubleMap newMutableMap(
            @Nonnull Integer[] keys, @Nonnull Double[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntDoubleMap newMutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Double> values, int expectedSize);

    

    @Override
    @Nonnull
     HashIntDoubleMap newMutableMap(
            @Nonnull Map<Integer, Double> map);

    @Override
    @Nonnull
     HashIntDoubleMap newMutableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2);

    @Override
    @Nonnull
     HashIntDoubleMap newMutableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2,
            @Nonnull Map<Integer, Double> map3);

    @Override
    @Nonnull
     HashIntDoubleMap newMutableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2,
            @Nonnull Map<Integer, Double> map3,
            @Nonnull Map<Integer, Double> map4);

    @Override
    @Nonnull
     HashIntDoubleMap newMutableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2,
            @Nonnull Map<Integer, Double> map3,
            @Nonnull Map<Integer, Double> map4,
            @Nonnull Map<Integer, Double> map5);



    @Override
    @Nonnull
     HashIntDoubleMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.IntDoubleConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashIntDoubleMap newMutableMap(
            @Nonnull int[] keys, @Nonnull double[] values);

    @Override
    @Nonnull
     HashIntDoubleMap newMutableMap(
            @Nonnull Integer[] keys, @Nonnull Double[] values);

    @Override
    @Nonnull
     HashIntDoubleMap newMutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Double> values);


    @Override
    @Nonnull
     HashIntDoubleMap newMutableMapOf(int k1, double v1);

    @Override
    @Nonnull
     HashIntDoubleMap newMutableMapOf(int k1, double v1,
            int k2, double v2);

    @Override
    @Nonnull
     HashIntDoubleMap newMutableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3);

    @Override
    @Nonnull
     HashIntDoubleMap newMutableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3,
            int k4, double v4);

    @Override
    @Nonnull
     HashIntDoubleMap newMutableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3,
            int k4, double v4, int k5, double v5);
    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMap();

    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2, int expectedSize);

    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2,
            @Nonnull Map<Integer, Double> map3, int expectedSize);

    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2,
            @Nonnull Map<Integer, Double> map3,
            @Nonnull Map<Integer, Double> map4, int expectedSize);

    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2,
            @Nonnull Map<Integer, Double> map3,
            @Nonnull Map<Integer, Double> map4,
            @Nonnull Map<Integer, Double> map5, int expectedSize);



    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.IntDoubleConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMap(
            @Nonnull int[] keys, @Nonnull double[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMap(
            @Nonnull Integer[] keys, @Nonnull Double[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Double> values, int expectedSize);

    

    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMap(
            @Nonnull Map<Integer, Double> map);

    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2);

    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2,
            @Nonnull Map<Integer, Double> map3);

    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2,
            @Nonnull Map<Integer, Double> map3,
            @Nonnull Map<Integer, Double> map4);

    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2,
            @Nonnull Map<Integer, Double> map3,
            @Nonnull Map<Integer, Double> map4,
            @Nonnull Map<Integer, Double> map5);



    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.IntDoubleConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMap(
            @Nonnull int[] keys, @Nonnull double[] values);

    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMap(
            @Nonnull Integer[] keys, @Nonnull Double[] values);

    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Double> values);


    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMapOf(int k1, double v1);

    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMapOf(int k1, double v1,
            int k2, double v2);

    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3);

    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3,
            int k4, double v4);

    @Override
    @Nonnull
     HashIntDoubleMap newUpdatableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3,
            int k4, double v4, int k5, double v5);

    


    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2, int expectedSize);

    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2,
            @Nonnull Map<Integer, Double> map3, int expectedSize);

    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2,
            @Nonnull Map<Integer, Double> map3,
            @Nonnull Map<Integer, Double> map4, int expectedSize);

    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2,
            @Nonnull Map<Integer, Double> map3,
            @Nonnull Map<Integer, Double> map4,
            @Nonnull Map<Integer, Double> map5, int expectedSize);



    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.IntDoubleConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMap(
            @Nonnull int[] keys, @Nonnull double[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMap(
            @Nonnull Integer[] keys, @Nonnull Double[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Double> values, int expectedSize);

    

    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMap(
            @Nonnull Map<Integer, Double> map);

    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2);

    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2,
            @Nonnull Map<Integer, Double> map3);

    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2,
            @Nonnull Map<Integer, Double> map3,
            @Nonnull Map<Integer, Double> map4);

    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMap(@Nonnull Map<Integer, Double> map1,
            @Nonnull Map<Integer, Double> map2,
            @Nonnull Map<Integer, Double> map3,
            @Nonnull Map<Integer, Double> map4,
            @Nonnull Map<Integer, Double> map5);



    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.IntDoubleConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMap(
            @Nonnull int[] keys, @Nonnull double[] values);

    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMap(
            @Nonnull Integer[] keys, @Nonnull Double[] values);

    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Double> values);


    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMapOf(int k1, double v1);

    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMapOf(int k1, double v1,
            int k2, double v2);

    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3);

    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3,
            int k4, double v4);

    @Override
    @Nonnull
     HashIntDoubleMap newImmutableMapOf(int k1, double v1,
            int k2, double v2, int k3, double v3,
            int k4, double v4, int k5, double v5);
}
