/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashDoubleLongMap}s.
 *
 * @see HashDoubleLongMap
 * @see HashDoubleLongMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashDoubleLongMapFactory
        extends DoubleLongMapFactory<HashDoubleLongMapFactory>
        , HashContainerFactory<HashDoubleLongMapFactory>{


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashDoubleLongMap newMutableMap();

    @Override
    @Nonnull
     HashDoubleLongMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashDoubleLongMap newMutableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleLongMap newMutableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2,
            @Nonnull Map<Double, Long> map3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleLongMap newMutableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2,
            @Nonnull Map<Double, Long> map3,
            @Nonnull Map<Double, Long> map4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleLongMap newMutableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2,
            @Nonnull Map<Double, Long> map3,
            @Nonnull Map<Double, Long> map4,
            @Nonnull Map<Double, Long> map5, int expectedSize);



    @Override
    @Nonnull
     HashDoubleLongMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleLongConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashDoubleLongMap newMutableMap(
            @Nonnull double[] keys, @Nonnull long[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleLongMap newMutableMap(
            @Nonnull Double[] keys, @Nonnull Long[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleLongMap newMutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Long> values, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleLongMap newMutableMap(
            @Nonnull Map<Double, Long> map);

    @Override
    @Nonnull
     HashDoubleLongMap newMutableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2);

    @Override
    @Nonnull
     HashDoubleLongMap newMutableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2,
            @Nonnull Map<Double, Long> map3);

    @Override
    @Nonnull
     HashDoubleLongMap newMutableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2,
            @Nonnull Map<Double, Long> map3,
            @Nonnull Map<Double, Long> map4);

    @Override
    @Nonnull
     HashDoubleLongMap newMutableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2,
            @Nonnull Map<Double, Long> map3,
            @Nonnull Map<Double, Long> map4,
            @Nonnull Map<Double, Long> map5);



    @Override
    @Nonnull
     HashDoubleLongMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleLongConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashDoubleLongMap newMutableMap(
            @Nonnull double[] keys, @Nonnull long[] values);

    @Override
    @Nonnull
     HashDoubleLongMap newMutableMap(
            @Nonnull Double[] keys, @Nonnull Long[] values);

    @Override
    @Nonnull
     HashDoubleLongMap newMutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Long> values);


    @Override
    @Nonnull
     HashDoubleLongMap newMutableMapOf(double k1, long v1);

    @Override
    @Nonnull
     HashDoubleLongMap newMutableMapOf(double k1, long v1,
            double k2, long v2);

    @Override
    @Nonnull
     HashDoubleLongMap newMutableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3);

    @Override
    @Nonnull
     HashDoubleLongMap newMutableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3,
            double k4, long v4);

    @Override
    @Nonnull
     HashDoubleLongMap newMutableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3,
            double k4, long v4, double k5, long v5);
    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMap();

    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2,
            @Nonnull Map<Double, Long> map3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2,
            @Nonnull Map<Double, Long> map3,
            @Nonnull Map<Double, Long> map4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2,
            @Nonnull Map<Double, Long> map3,
            @Nonnull Map<Double, Long> map4,
            @Nonnull Map<Double, Long> map5, int expectedSize);



    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleLongConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMap(
            @Nonnull double[] keys, @Nonnull long[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMap(
            @Nonnull Double[] keys, @Nonnull Long[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Long> values, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMap(
            @Nonnull Map<Double, Long> map);

    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2);

    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2,
            @Nonnull Map<Double, Long> map3);

    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2,
            @Nonnull Map<Double, Long> map3,
            @Nonnull Map<Double, Long> map4);

    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2,
            @Nonnull Map<Double, Long> map3,
            @Nonnull Map<Double, Long> map4,
            @Nonnull Map<Double, Long> map5);



    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleLongConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMap(
            @Nonnull double[] keys, @Nonnull long[] values);

    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMap(
            @Nonnull Double[] keys, @Nonnull Long[] values);

    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Long> values);


    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMapOf(double k1, long v1);

    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMapOf(double k1, long v1,
            double k2, long v2);

    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3);

    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3,
            double k4, long v4);

    @Override
    @Nonnull
     HashDoubleLongMap newUpdatableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3,
            double k4, long v4, double k5, long v5);

    


    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2,
            @Nonnull Map<Double, Long> map3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2,
            @Nonnull Map<Double, Long> map3,
            @Nonnull Map<Double, Long> map4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2,
            @Nonnull Map<Double, Long> map3,
            @Nonnull Map<Double, Long> map4,
            @Nonnull Map<Double, Long> map5, int expectedSize);



    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleLongConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMap(
            @Nonnull double[] keys, @Nonnull long[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMap(
            @Nonnull Double[] keys, @Nonnull Long[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Long> values, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMap(
            @Nonnull Map<Double, Long> map);

    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2);

    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2,
            @Nonnull Map<Double, Long> map3);

    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2,
            @Nonnull Map<Double, Long> map3,
            @Nonnull Map<Double, Long> map4);

    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMap(@Nonnull Map<Double, Long> map1,
            @Nonnull Map<Double, Long> map2,
            @Nonnull Map<Double, Long> map3,
            @Nonnull Map<Double, Long> map4,
            @Nonnull Map<Double, Long> map5);



    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleLongConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMap(
            @Nonnull double[] keys, @Nonnull long[] values);

    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMap(
            @Nonnull Double[] keys, @Nonnull Long[] values);

    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Long> values);


    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMapOf(double k1, long v1);

    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMapOf(double k1, long v1,
            double k2, long v2);

    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3);

    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3,
            double k4, long v4);

    @Override
    @Nonnull
     HashDoubleLongMap newImmutableMapOf(double k1, long v1,
            double k2, long v2, double k3, long v3,
            double k4, long v4, double k5, long v5);
}
