/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashCharDoubleMap}s.
 *
 * @see HashCharDoubleMap
 * @see HashCharDoubleMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashCharDoubleMapFactory
        extends CharDoubleMapFactory<HashCharDoubleMapFactory>
        , CharHashFactory<HashCharDoubleMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashCharDoubleMap newMutableMap();

    @Override
    @Nonnull
     HashCharDoubleMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashCharDoubleMap newMutableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2, int expectedSize);

    @Override
    @Nonnull
     HashCharDoubleMap newMutableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2,
            @Nonnull Map<Character, Double> map3, int expectedSize);

    @Override
    @Nonnull
     HashCharDoubleMap newMutableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2,
            @Nonnull Map<Character, Double> map3,
            @Nonnull Map<Character, Double> map4, int expectedSize);

    @Override
    @Nonnull
     HashCharDoubleMap newMutableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2,
            @Nonnull Map<Character, Double> map3,
            @Nonnull Map<Character, Double> map4,
            @Nonnull Map<Character, Double> map5, int expectedSize);



    @Override
    @Nonnull
     HashCharDoubleMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.CharDoubleConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashCharDoubleMap newMutableMap(
            @Nonnull char[] keys, @Nonnull double[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharDoubleMap newMutableMap(
            @Nonnull Character[] keys, @Nonnull Double[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharDoubleMap newMutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Double> values, int expectedSize);

    

    @Override
    @Nonnull
     HashCharDoubleMap newMutableMap(
            @Nonnull Map<Character, Double> map);

    @Override
    @Nonnull
     HashCharDoubleMap newMutableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2);

    @Override
    @Nonnull
     HashCharDoubleMap newMutableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2,
            @Nonnull Map<Character, Double> map3);

    @Override
    @Nonnull
     HashCharDoubleMap newMutableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2,
            @Nonnull Map<Character, Double> map3,
            @Nonnull Map<Character, Double> map4);

    @Override
    @Nonnull
     HashCharDoubleMap newMutableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2,
            @Nonnull Map<Character, Double> map3,
            @Nonnull Map<Character, Double> map4,
            @Nonnull Map<Character, Double> map5);



    @Override
    @Nonnull
     HashCharDoubleMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.CharDoubleConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashCharDoubleMap newMutableMap(
            @Nonnull char[] keys, @Nonnull double[] values);

    @Override
    @Nonnull
     HashCharDoubleMap newMutableMap(
            @Nonnull Character[] keys, @Nonnull Double[] values);

    @Override
    @Nonnull
     HashCharDoubleMap newMutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Double> values);


    @Override
    @Nonnull
     HashCharDoubleMap newMutableMapOf(char k1, double v1);

    @Override
    @Nonnull
     HashCharDoubleMap newMutableMapOf(char k1, double v1,
            char k2, double v2);

    @Override
    @Nonnull
     HashCharDoubleMap newMutableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3);

    @Override
    @Nonnull
     HashCharDoubleMap newMutableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3,
            char k4, double v4);

    @Override
    @Nonnull
     HashCharDoubleMap newMutableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3,
            char k4, double v4, char k5, double v5);
    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMap();

    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2, int expectedSize);

    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2,
            @Nonnull Map<Character, Double> map3, int expectedSize);

    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2,
            @Nonnull Map<Character, Double> map3,
            @Nonnull Map<Character, Double> map4, int expectedSize);

    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2,
            @Nonnull Map<Character, Double> map3,
            @Nonnull Map<Character, Double> map4,
            @Nonnull Map<Character, Double> map5, int expectedSize);



    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.CharDoubleConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMap(
            @Nonnull char[] keys, @Nonnull double[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMap(
            @Nonnull Character[] keys, @Nonnull Double[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Double> values, int expectedSize);

    

    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMap(
            @Nonnull Map<Character, Double> map);

    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2);

    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2,
            @Nonnull Map<Character, Double> map3);

    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2,
            @Nonnull Map<Character, Double> map3,
            @Nonnull Map<Character, Double> map4);

    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2,
            @Nonnull Map<Character, Double> map3,
            @Nonnull Map<Character, Double> map4,
            @Nonnull Map<Character, Double> map5);



    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.CharDoubleConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMap(
            @Nonnull char[] keys, @Nonnull double[] values);

    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMap(
            @Nonnull Character[] keys, @Nonnull Double[] values);

    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Double> values);


    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMapOf(char k1, double v1);

    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMapOf(char k1, double v1,
            char k2, double v2);

    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3);

    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3,
            char k4, double v4);

    @Override
    @Nonnull
     HashCharDoubleMap newUpdatableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3,
            char k4, double v4, char k5, double v5);

    


    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2, int expectedSize);

    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2,
            @Nonnull Map<Character, Double> map3, int expectedSize);

    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2,
            @Nonnull Map<Character, Double> map3,
            @Nonnull Map<Character, Double> map4, int expectedSize);

    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2,
            @Nonnull Map<Character, Double> map3,
            @Nonnull Map<Character, Double> map4,
            @Nonnull Map<Character, Double> map5, int expectedSize);



    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.CharDoubleConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMap(
            @Nonnull char[] keys, @Nonnull double[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMap(
            @Nonnull Character[] keys, @Nonnull Double[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Double> values, int expectedSize);

    

    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMap(
            @Nonnull Map<Character, Double> map);

    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2);

    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2,
            @Nonnull Map<Character, Double> map3);

    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2,
            @Nonnull Map<Character, Double> map3,
            @Nonnull Map<Character, Double> map4);

    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMap(@Nonnull Map<Character, Double> map1,
            @Nonnull Map<Character, Double> map2,
            @Nonnull Map<Character, Double> map3,
            @Nonnull Map<Character, Double> map4,
            @Nonnull Map<Character, Double> map5);



    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.CharDoubleConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMap(
            @Nonnull char[] keys, @Nonnull double[] values);

    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMap(
            @Nonnull Character[] keys, @Nonnull Double[] values);

    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Double> values);


    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMapOf(char k1, double v1);

    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMapOf(char k1, double v1,
            char k2, double v2);

    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3);

    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3,
            char k4, double v4);

    @Override
    @Nonnull
     HashCharDoubleMap newImmutableMapOf(char k1, double v1,
            char k2, double v2, char k3, double v3,
            char k4, double v4, char k5, double v5);
}
