/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashCharByteMap}s.
 *
 * @see HashCharByteMap
 * @see HashCharByteMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashCharByteMapFactory
        extends CharByteMapFactory<HashCharByteMapFactory>
        , CharHashFactory<HashCharByteMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashCharByteMap newMutableMap();

    @Override
    @Nonnull
     HashCharByteMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashCharByteMap newMutableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2, int expectedSize);

    @Override
    @Nonnull
     HashCharByteMap newMutableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2,
            @Nonnull Map<Character, Byte> map3, int expectedSize);

    @Override
    @Nonnull
     HashCharByteMap newMutableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2,
            @Nonnull Map<Character, Byte> map3,
            @Nonnull Map<Character, Byte> map4, int expectedSize);

    @Override
    @Nonnull
     HashCharByteMap newMutableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2,
            @Nonnull Map<Character, Byte> map3,
            @Nonnull Map<Character, Byte> map4,
            @Nonnull Map<Character, Byte> map5, int expectedSize);



    @Override
    @Nonnull
     HashCharByteMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.CharByteConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashCharByteMap newMutableMap(
            @Nonnull char[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharByteMap newMutableMap(
            @Nonnull Character[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharByteMap newMutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
     HashCharByteMap newMutableMap(
            @Nonnull Map<Character, Byte> map);

    @Override
    @Nonnull
     HashCharByteMap newMutableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2);

    @Override
    @Nonnull
     HashCharByteMap newMutableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2,
            @Nonnull Map<Character, Byte> map3);

    @Override
    @Nonnull
     HashCharByteMap newMutableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2,
            @Nonnull Map<Character, Byte> map3,
            @Nonnull Map<Character, Byte> map4);

    @Override
    @Nonnull
     HashCharByteMap newMutableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2,
            @Nonnull Map<Character, Byte> map3,
            @Nonnull Map<Character, Byte> map4,
            @Nonnull Map<Character, Byte> map5);



    @Override
    @Nonnull
     HashCharByteMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.CharByteConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashCharByteMap newMutableMap(
            @Nonnull char[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
     HashCharByteMap newMutableMap(
            @Nonnull Character[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
     HashCharByteMap newMutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
     HashCharByteMap newMutableMapOf(char k1, byte v1);

    @Override
    @Nonnull
     HashCharByteMap newMutableMapOf(char k1, byte v1,
            char k2, byte v2);

    @Override
    @Nonnull
     HashCharByteMap newMutableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3);

    @Override
    @Nonnull
     HashCharByteMap newMutableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3,
            char k4, byte v4);

    @Override
    @Nonnull
     HashCharByteMap newMutableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3,
            char k4, byte v4, char k5, byte v5);
    @Override
    @Nonnull
     HashCharByteMap newUpdatableMap();

    @Override
    @Nonnull
     HashCharByteMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashCharByteMap newUpdatableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2, int expectedSize);

    @Override
    @Nonnull
     HashCharByteMap newUpdatableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2,
            @Nonnull Map<Character, Byte> map3, int expectedSize);

    @Override
    @Nonnull
     HashCharByteMap newUpdatableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2,
            @Nonnull Map<Character, Byte> map3,
            @Nonnull Map<Character, Byte> map4, int expectedSize);

    @Override
    @Nonnull
     HashCharByteMap newUpdatableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2,
            @Nonnull Map<Character, Byte> map3,
            @Nonnull Map<Character, Byte> map4,
            @Nonnull Map<Character, Byte> map5, int expectedSize);



    @Override
    @Nonnull
     HashCharByteMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.CharByteConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashCharByteMap newUpdatableMap(
            @Nonnull char[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharByteMap newUpdatableMap(
            @Nonnull Character[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharByteMap newUpdatableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
     HashCharByteMap newUpdatableMap(
            @Nonnull Map<Character, Byte> map);

    @Override
    @Nonnull
     HashCharByteMap newUpdatableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2);

    @Override
    @Nonnull
     HashCharByteMap newUpdatableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2,
            @Nonnull Map<Character, Byte> map3);

    @Override
    @Nonnull
     HashCharByteMap newUpdatableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2,
            @Nonnull Map<Character, Byte> map3,
            @Nonnull Map<Character, Byte> map4);

    @Override
    @Nonnull
     HashCharByteMap newUpdatableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2,
            @Nonnull Map<Character, Byte> map3,
            @Nonnull Map<Character, Byte> map4,
            @Nonnull Map<Character, Byte> map5);



    @Override
    @Nonnull
     HashCharByteMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.CharByteConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashCharByteMap newUpdatableMap(
            @Nonnull char[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
     HashCharByteMap newUpdatableMap(
            @Nonnull Character[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
     HashCharByteMap newUpdatableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
     HashCharByteMap newUpdatableMapOf(char k1, byte v1);

    @Override
    @Nonnull
     HashCharByteMap newUpdatableMapOf(char k1, byte v1,
            char k2, byte v2);

    @Override
    @Nonnull
     HashCharByteMap newUpdatableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3);

    @Override
    @Nonnull
     HashCharByteMap newUpdatableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3,
            char k4, byte v4);

    @Override
    @Nonnull
     HashCharByteMap newUpdatableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3,
            char k4, byte v4, char k5, byte v5);

    


    @Override
    @Nonnull
     HashCharByteMap newImmutableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2, int expectedSize);

    @Override
    @Nonnull
     HashCharByteMap newImmutableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2,
            @Nonnull Map<Character, Byte> map3, int expectedSize);

    @Override
    @Nonnull
     HashCharByteMap newImmutableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2,
            @Nonnull Map<Character, Byte> map3,
            @Nonnull Map<Character, Byte> map4, int expectedSize);

    @Override
    @Nonnull
     HashCharByteMap newImmutableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2,
            @Nonnull Map<Character, Byte> map3,
            @Nonnull Map<Character, Byte> map4,
            @Nonnull Map<Character, Byte> map5, int expectedSize);



    @Override
    @Nonnull
     HashCharByteMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.CharByteConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashCharByteMap newImmutableMap(
            @Nonnull char[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharByteMap newImmutableMap(
            @Nonnull Character[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharByteMap newImmutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
     HashCharByteMap newImmutableMap(
            @Nonnull Map<Character, Byte> map);

    @Override
    @Nonnull
     HashCharByteMap newImmutableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2);

    @Override
    @Nonnull
     HashCharByteMap newImmutableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2,
            @Nonnull Map<Character, Byte> map3);

    @Override
    @Nonnull
     HashCharByteMap newImmutableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2,
            @Nonnull Map<Character, Byte> map3,
            @Nonnull Map<Character, Byte> map4);

    @Override
    @Nonnull
     HashCharByteMap newImmutableMap(@Nonnull Map<Character, Byte> map1,
            @Nonnull Map<Character, Byte> map2,
            @Nonnull Map<Character, Byte> map3,
            @Nonnull Map<Character, Byte> map4,
            @Nonnull Map<Character, Byte> map5);



    @Override
    @Nonnull
     HashCharByteMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.CharByteConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashCharByteMap newImmutableMap(
            @Nonnull char[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
     HashCharByteMap newImmutableMap(
            @Nonnull Character[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
     HashCharByteMap newImmutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
     HashCharByteMap newImmutableMapOf(char k1, byte v1);

    @Override
    @Nonnull
     HashCharByteMap newImmutableMapOf(char k1, byte v1,
            char k2, byte v2);

    @Override
    @Nonnull
     HashCharByteMap newImmutableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3);

    @Override
    @Nonnull
     HashCharByteMap newImmutableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3,
            char k4, byte v4);

    @Override
    @Nonnull
     HashCharByteMap newImmutableMapOf(char k1, byte v1,
            char k2, byte v2, char k3, byte v3,
            char k4, byte v4, char k5, byte v5);
}
