/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashByteShortMap}s.
 *
 * @see HashByteShortMap
 * @see HashByteShortMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashByteShortMapFactory
        extends ByteShortMapFactory<HashByteShortMapFactory>
        , ByteHashFactory<HashByteShortMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashByteShortMap newMutableMap();

    @Override
    @Nonnull
     HashByteShortMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashByteShortMap newMutableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2, int expectedSize);

    @Override
    @Nonnull
     HashByteShortMap newMutableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2,
            @Nonnull Map<Byte, Short> map3, int expectedSize);

    @Override
    @Nonnull
     HashByteShortMap newMutableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2,
            @Nonnull Map<Byte, Short> map3,
            @Nonnull Map<Byte, Short> map4, int expectedSize);

    @Override
    @Nonnull
     HashByteShortMap newMutableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2,
            @Nonnull Map<Byte, Short> map3,
            @Nonnull Map<Byte, Short> map4,
            @Nonnull Map<Byte, Short> map5, int expectedSize);



    @Override
    @Nonnull
     HashByteShortMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.ByteShortConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashByteShortMap newMutableMap(
            @Nonnull byte[] keys, @Nonnull short[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteShortMap newMutableMap(
            @Nonnull Byte[] keys, @Nonnull Short[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteShortMap newMutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Short> values, int expectedSize);

    

    @Override
    @Nonnull
     HashByteShortMap newMutableMap(
            @Nonnull Map<Byte, Short> map);

    @Override
    @Nonnull
     HashByteShortMap newMutableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2);

    @Override
    @Nonnull
     HashByteShortMap newMutableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2,
            @Nonnull Map<Byte, Short> map3);

    @Override
    @Nonnull
     HashByteShortMap newMutableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2,
            @Nonnull Map<Byte, Short> map3,
            @Nonnull Map<Byte, Short> map4);

    @Override
    @Nonnull
     HashByteShortMap newMutableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2,
            @Nonnull Map<Byte, Short> map3,
            @Nonnull Map<Byte, Short> map4,
            @Nonnull Map<Byte, Short> map5);



    @Override
    @Nonnull
     HashByteShortMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.ByteShortConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashByteShortMap newMutableMap(
            @Nonnull byte[] keys, @Nonnull short[] values);

    @Override
    @Nonnull
     HashByteShortMap newMutableMap(
            @Nonnull Byte[] keys, @Nonnull Short[] values);

    @Override
    @Nonnull
     HashByteShortMap newMutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Short> values);


    @Override
    @Nonnull
     HashByteShortMap newMutableMapOf(byte k1, short v1);

    @Override
    @Nonnull
     HashByteShortMap newMutableMapOf(byte k1, short v1,
            byte k2, short v2);

    @Override
    @Nonnull
     HashByteShortMap newMutableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3);

    @Override
    @Nonnull
     HashByteShortMap newMutableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3,
            byte k4, short v4);

    @Override
    @Nonnull
     HashByteShortMap newMutableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3,
            byte k4, short v4, byte k5, short v5);
    @Override
    @Nonnull
     HashByteShortMap newUpdatableMap();

    @Override
    @Nonnull
     HashByteShortMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashByteShortMap newUpdatableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2, int expectedSize);

    @Override
    @Nonnull
     HashByteShortMap newUpdatableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2,
            @Nonnull Map<Byte, Short> map3, int expectedSize);

    @Override
    @Nonnull
     HashByteShortMap newUpdatableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2,
            @Nonnull Map<Byte, Short> map3,
            @Nonnull Map<Byte, Short> map4, int expectedSize);

    @Override
    @Nonnull
     HashByteShortMap newUpdatableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2,
            @Nonnull Map<Byte, Short> map3,
            @Nonnull Map<Byte, Short> map4,
            @Nonnull Map<Byte, Short> map5, int expectedSize);



    @Override
    @Nonnull
     HashByteShortMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.ByteShortConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashByteShortMap newUpdatableMap(
            @Nonnull byte[] keys, @Nonnull short[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteShortMap newUpdatableMap(
            @Nonnull Byte[] keys, @Nonnull Short[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteShortMap newUpdatableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Short> values, int expectedSize);

    

    @Override
    @Nonnull
     HashByteShortMap newUpdatableMap(
            @Nonnull Map<Byte, Short> map);

    @Override
    @Nonnull
     HashByteShortMap newUpdatableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2);

    @Override
    @Nonnull
     HashByteShortMap newUpdatableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2,
            @Nonnull Map<Byte, Short> map3);

    @Override
    @Nonnull
     HashByteShortMap newUpdatableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2,
            @Nonnull Map<Byte, Short> map3,
            @Nonnull Map<Byte, Short> map4);

    @Override
    @Nonnull
     HashByteShortMap newUpdatableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2,
            @Nonnull Map<Byte, Short> map3,
            @Nonnull Map<Byte, Short> map4,
            @Nonnull Map<Byte, Short> map5);



    @Override
    @Nonnull
     HashByteShortMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.ByteShortConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashByteShortMap newUpdatableMap(
            @Nonnull byte[] keys, @Nonnull short[] values);

    @Override
    @Nonnull
     HashByteShortMap newUpdatableMap(
            @Nonnull Byte[] keys, @Nonnull Short[] values);

    @Override
    @Nonnull
     HashByteShortMap newUpdatableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Short> values);


    @Override
    @Nonnull
     HashByteShortMap newUpdatableMapOf(byte k1, short v1);

    @Override
    @Nonnull
     HashByteShortMap newUpdatableMapOf(byte k1, short v1,
            byte k2, short v2);

    @Override
    @Nonnull
     HashByteShortMap newUpdatableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3);

    @Override
    @Nonnull
     HashByteShortMap newUpdatableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3,
            byte k4, short v4);

    @Override
    @Nonnull
     HashByteShortMap newUpdatableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3,
            byte k4, short v4, byte k5, short v5);

    


    @Override
    @Nonnull
     HashByteShortMap newImmutableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2, int expectedSize);

    @Override
    @Nonnull
     HashByteShortMap newImmutableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2,
            @Nonnull Map<Byte, Short> map3, int expectedSize);

    @Override
    @Nonnull
     HashByteShortMap newImmutableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2,
            @Nonnull Map<Byte, Short> map3,
            @Nonnull Map<Byte, Short> map4, int expectedSize);

    @Override
    @Nonnull
     HashByteShortMap newImmutableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2,
            @Nonnull Map<Byte, Short> map3,
            @Nonnull Map<Byte, Short> map4,
            @Nonnull Map<Byte, Short> map5, int expectedSize);



    @Override
    @Nonnull
     HashByteShortMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.ByteShortConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashByteShortMap newImmutableMap(
            @Nonnull byte[] keys, @Nonnull short[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteShortMap newImmutableMap(
            @Nonnull Byte[] keys, @Nonnull Short[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteShortMap newImmutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Short> values, int expectedSize);

    

    @Override
    @Nonnull
     HashByteShortMap newImmutableMap(
            @Nonnull Map<Byte, Short> map);

    @Override
    @Nonnull
     HashByteShortMap newImmutableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2);

    @Override
    @Nonnull
     HashByteShortMap newImmutableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2,
            @Nonnull Map<Byte, Short> map3);

    @Override
    @Nonnull
     HashByteShortMap newImmutableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2,
            @Nonnull Map<Byte, Short> map3,
            @Nonnull Map<Byte, Short> map4);

    @Override
    @Nonnull
     HashByteShortMap newImmutableMap(@Nonnull Map<Byte, Short> map1,
            @Nonnull Map<Byte, Short> map2,
            @Nonnull Map<Byte, Short> map3,
            @Nonnull Map<Byte, Short> map4,
            @Nonnull Map<Byte, Short> map5);



    @Override
    @Nonnull
     HashByteShortMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.ByteShortConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashByteShortMap newImmutableMap(
            @Nonnull byte[] keys, @Nonnull short[] values);

    @Override
    @Nonnull
     HashByteShortMap newImmutableMap(
            @Nonnull Byte[] keys, @Nonnull Short[] values);

    @Override
    @Nonnull
     HashByteShortMap newImmutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Short> values);


    @Override
    @Nonnull
     HashByteShortMap newImmutableMapOf(byte k1, short v1);

    @Override
    @Nonnull
     HashByteShortMap newImmutableMapOf(byte k1, short v1,
            byte k2, short v2);

    @Override
    @Nonnull
     HashByteShortMap newImmutableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3);

    @Override
    @Nonnull
     HashByteShortMap newImmutableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3,
            byte k4, short v4);

    @Override
    @Nonnull
     HashByteShortMap newImmutableMapOf(byte k1, short v1,
            byte k2, short v2, byte k3, short v3,
            byte k4, short v4, byte k5, short v5);
}
