/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashByteCharMap}s.
 *
 * @see HashByteCharMap
 * @see HashByteCharMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashByteCharMapFactory
        extends ByteCharMapFactory<HashByteCharMapFactory>
        , ByteHashFactory<HashByteCharMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashByteCharMap newMutableMap();

    @Override
    @Nonnull
     HashByteCharMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashByteCharMap newMutableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2, int expectedSize);

    @Override
    @Nonnull
     HashByteCharMap newMutableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2,
            @Nonnull Map<Byte, Character> map3, int expectedSize);

    @Override
    @Nonnull
     HashByteCharMap newMutableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2,
            @Nonnull Map<Byte, Character> map3,
            @Nonnull Map<Byte, Character> map4, int expectedSize);

    @Override
    @Nonnull
     HashByteCharMap newMutableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2,
            @Nonnull Map<Byte, Character> map3,
            @Nonnull Map<Byte, Character> map4,
            @Nonnull Map<Byte, Character> map5, int expectedSize);



    @Override
    @Nonnull
     HashByteCharMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.ByteCharConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashByteCharMap newMutableMap(
            @Nonnull byte[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteCharMap newMutableMap(
            @Nonnull Byte[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteCharMap newMutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
     HashByteCharMap newMutableMap(
            @Nonnull Map<Byte, Character> map);

    @Override
    @Nonnull
     HashByteCharMap newMutableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2);

    @Override
    @Nonnull
     HashByteCharMap newMutableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2,
            @Nonnull Map<Byte, Character> map3);

    @Override
    @Nonnull
     HashByteCharMap newMutableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2,
            @Nonnull Map<Byte, Character> map3,
            @Nonnull Map<Byte, Character> map4);

    @Override
    @Nonnull
     HashByteCharMap newMutableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2,
            @Nonnull Map<Byte, Character> map3,
            @Nonnull Map<Byte, Character> map4,
            @Nonnull Map<Byte, Character> map5);



    @Override
    @Nonnull
     HashByteCharMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.ByteCharConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashByteCharMap newMutableMap(
            @Nonnull byte[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
     HashByteCharMap newMutableMap(
            @Nonnull Byte[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
     HashByteCharMap newMutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
     HashByteCharMap newMutableMapOf(byte k1, char v1);

    @Override
    @Nonnull
     HashByteCharMap newMutableMapOf(byte k1, char v1,
            byte k2, char v2);

    @Override
    @Nonnull
     HashByteCharMap newMutableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3);

    @Override
    @Nonnull
     HashByteCharMap newMutableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3,
            byte k4, char v4);

    @Override
    @Nonnull
     HashByteCharMap newMutableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3,
            byte k4, char v4, byte k5, char v5);
    @Override
    @Nonnull
     HashByteCharMap newUpdatableMap();

    @Override
    @Nonnull
     HashByteCharMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashByteCharMap newUpdatableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2, int expectedSize);

    @Override
    @Nonnull
     HashByteCharMap newUpdatableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2,
            @Nonnull Map<Byte, Character> map3, int expectedSize);

    @Override
    @Nonnull
     HashByteCharMap newUpdatableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2,
            @Nonnull Map<Byte, Character> map3,
            @Nonnull Map<Byte, Character> map4, int expectedSize);

    @Override
    @Nonnull
     HashByteCharMap newUpdatableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2,
            @Nonnull Map<Byte, Character> map3,
            @Nonnull Map<Byte, Character> map4,
            @Nonnull Map<Byte, Character> map5, int expectedSize);



    @Override
    @Nonnull
     HashByteCharMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.ByteCharConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashByteCharMap newUpdatableMap(
            @Nonnull byte[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteCharMap newUpdatableMap(
            @Nonnull Byte[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteCharMap newUpdatableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
     HashByteCharMap newUpdatableMap(
            @Nonnull Map<Byte, Character> map);

    @Override
    @Nonnull
     HashByteCharMap newUpdatableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2);

    @Override
    @Nonnull
     HashByteCharMap newUpdatableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2,
            @Nonnull Map<Byte, Character> map3);

    @Override
    @Nonnull
     HashByteCharMap newUpdatableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2,
            @Nonnull Map<Byte, Character> map3,
            @Nonnull Map<Byte, Character> map4);

    @Override
    @Nonnull
     HashByteCharMap newUpdatableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2,
            @Nonnull Map<Byte, Character> map3,
            @Nonnull Map<Byte, Character> map4,
            @Nonnull Map<Byte, Character> map5);



    @Override
    @Nonnull
     HashByteCharMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.ByteCharConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashByteCharMap newUpdatableMap(
            @Nonnull byte[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
     HashByteCharMap newUpdatableMap(
            @Nonnull Byte[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
     HashByteCharMap newUpdatableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
     HashByteCharMap newUpdatableMapOf(byte k1, char v1);

    @Override
    @Nonnull
     HashByteCharMap newUpdatableMapOf(byte k1, char v1,
            byte k2, char v2);

    @Override
    @Nonnull
     HashByteCharMap newUpdatableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3);

    @Override
    @Nonnull
     HashByteCharMap newUpdatableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3,
            byte k4, char v4);

    @Override
    @Nonnull
     HashByteCharMap newUpdatableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3,
            byte k4, char v4, byte k5, char v5);

    


    @Override
    @Nonnull
     HashByteCharMap newImmutableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2, int expectedSize);

    @Override
    @Nonnull
     HashByteCharMap newImmutableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2,
            @Nonnull Map<Byte, Character> map3, int expectedSize);

    @Override
    @Nonnull
     HashByteCharMap newImmutableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2,
            @Nonnull Map<Byte, Character> map3,
            @Nonnull Map<Byte, Character> map4, int expectedSize);

    @Override
    @Nonnull
     HashByteCharMap newImmutableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2,
            @Nonnull Map<Byte, Character> map3,
            @Nonnull Map<Byte, Character> map4,
            @Nonnull Map<Byte, Character> map5, int expectedSize);



    @Override
    @Nonnull
     HashByteCharMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.ByteCharConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashByteCharMap newImmutableMap(
            @Nonnull byte[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteCharMap newImmutableMap(
            @Nonnull Byte[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteCharMap newImmutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
     HashByteCharMap newImmutableMap(
            @Nonnull Map<Byte, Character> map);

    @Override
    @Nonnull
     HashByteCharMap newImmutableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2);

    @Override
    @Nonnull
     HashByteCharMap newImmutableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2,
            @Nonnull Map<Byte, Character> map3);

    @Override
    @Nonnull
     HashByteCharMap newImmutableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2,
            @Nonnull Map<Byte, Character> map3,
            @Nonnull Map<Byte, Character> map4);

    @Override
    @Nonnull
     HashByteCharMap newImmutableMap(@Nonnull Map<Byte, Character> map1,
            @Nonnull Map<Byte, Character> map2,
            @Nonnull Map<Byte, Character> map3,
            @Nonnull Map<Byte, Character> map4,
            @Nonnull Map<Byte, Character> map5);



    @Override
    @Nonnull
     HashByteCharMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.ByteCharConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashByteCharMap newImmutableMap(
            @Nonnull byte[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
     HashByteCharMap newImmutableMap(
            @Nonnull Byte[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
     HashByteCharMap newImmutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
     HashByteCharMap newImmutableMapOf(byte k1, char v1);

    @Override
    @Nonnull
     HashByteCharMap newImmutableMapOf(byte k1, char v1,
            byte k2, char v2);

    @Override
    @Nonnull
     HashByteCharMap newImmutableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3);

    @Override
    @Nonnull
     HashByteCharMap newImmutableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3,
            byte k4, char v4);

    @Override
    @Nonnull
     HashByteCharMap newImmutableMapOf(byte k1, char v1,
            byte k2, char v2, byte k3, char v3,
            byte k4, char v4, byte k5, char v5);
}
