/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.representation;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.graph.representation.Extensions;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Optional;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.TransferableGraphFileReader;
import org.simantics.graph.representation.Value;

public class TransferableGraph1Serializer
extends Serializer {
    public static final TransferableGraph1Serializer INSTANCE = new TransferableGraph1Serializer();

    private TransferableGraph1Serializer() {
    }

    static int writeUTF(String str, byte[] bytearr, int byteIndex) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        int count = byteIndex;
        int i = 0;
        while (i < strlen) {
            c = str.charAt(i);
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + utflen + " bytes");
        }
        if (utflen < 128) {
            bytearr[count++] = (byte)utflen;
        } else if ((utflen -= 128) < 16384) {
            bytearr[count++] = (byte)(utflen & 0x3F | 0x80);
            bytearr[count++] = (byte)(utflen >>> 6);
        } else if ((utflen -= 16384) < 0x200000) {
            bytearr[count++] = (byte)(utflen & 0x1F | 0xC0);
            bytearr[count++] = (byte)(utflen >>> 5 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 13 & 0xFF);
        } else if ((utflen -= 0x200000) < 0x10000000) {
            bytearr[count++] = (byte)(utflen & 0xF | 0xE0);
            bytearr[count++] = (byte)(utflen >>> 4 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 12 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 20 & 0xFF);
        } else {
            bytearr[count++] = (byte)((utflen -= 0x10000000) & 7 | 0xF0);
            bytearr[count++] = (byte)(utflen >>> 3 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 11 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 19 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 27 & 0xFF);
        }
        i = 0;
        i = 0;
        while (i < strlen) {
            c = str.charAt(i);
            if (c < '\u0001' || c > '\u007f') break;
            bytearr[count++] = (byte)c;
            ++i;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        return count - byteIndex;
    }

    @Override
    public Object deserialize(File file) throws IOException {
        TransferableGraphFileReader reader = new TransferableGraphFileReader(file);
        return reader.readTG();
    }

    @Override
    public Object deserialize(InputStream in) throws IOException {
        TransferableGraphFileReader reader = new TransferableGraphFileReader(in);
        return reader.readTG();
    }

    @Override
    public byte[] serialize(Object obj) throws IOException {
        TransferableGraph1 tg = (TransferableGraph1)obj;
        Extensions ex = new Extensions(tg.extensions);
        byte[] extensions = Bindings.getSerializerUnchecked(Bindings.getBindingUnchecked(Extensions.class)).serialize(ex);
        Serializer variantSerializer = Bindings.getSerializerUnchecked(Bindings.VARIANT);
        int actualSize = 16 + 4 * tg.values.length + 4 * tg.statements.length + 5 * tg.identities.length + extensions.length;
        Object[] objectArray = tg.values;
        int n = tg.values.length;
        int n2 = 0;
        while (n2 < n) {
            Value v = objectArray[n2];
            actualSize += variantSerializer.getSize(v.value);
            ++n2;
        }
        objectArray = tg.identities;
        n = tg.identities.length;
        n2 = 0;
        while (n2 < n) {
            Object id = objectArray[n2];
            if (((Identity)id).definition instanceof Internal) {
                actualSize += 4 + ((Internal)((Identity)id).definition).name.length() + 5;
            } else if (((Identity)id).definition instanceof External) {
                actualSize += 4 + ((External)((Identity)id).definition).name.length() + 5;
            } else if (((Identity)id).definition instanceof Root) {
                actualSize += ((Root)((Identity)id).definition).name.length() + ((Root)((Identity)id).definition).type.length() + 10;
            } else if (((Identity)id).definition instanceof Optional) {
                actualSize += 4 + ((Optional)((Identity)id).definition).name.length() + 5;
            }
            ++n2;
        }
        byte[] bytes = new byte[actualSize];
        int byteIndex = 0;
        Object i = tg.resourceCount;
        bytes[byteIndex + 3] = (byte)(i & 0xFF);
        bytes[byteIndex + 2] = (byte)((i >>>= 8) & 0xFF);
        bytes[byteIndex + 1] = (byte)((i >>>= 8) & 0xFF);
        bytes[byteIndex] = (byte)((i >>>= 8) & 0xFF);
        i >>>= 8;
        i = tg.identities.length;
        bytes[(byteIndex += 4) + 3] = (byte)(i & 0xFF);
        bytes[byteIndex + 2] = (byte)((i >>>= 8) & 0xFF);
        bytes[byteIndex + 1] = (byte)((i >>>= 8) & 0xFF);
        bytes[byteIndex] = (byte)((i >>>= 8) & 0xFF);
        i >>>= 8;
        byteIndex += 4;
        Object[] objectArray2 = tg.identities;
        int n3 = tg.identities.length;
        int n4 = 0;
        while (n4 < n3) {
            IdentityDefinition r;
            Identity id = objectArray2[n4];
            i = id.resource;
            bytes[byteIndex + 3] = (byte)(i & 0xFF);
            bytes[byteIndex + 2] = (byte)((i >>>= 8) & 0xFF);
            bytes[byteIndex + 1] = (byte)((i >>>= 8) & 0xFF);
            bytes[byteIndex] = (byte)((i >>>= 8) & 0xFF);
            i >>>= 8;
            byteIndex += 4;
            if (id.definition instanceof Internal) {
                r = (Internal)id.definition;
                bytes[byteIndex++] = 3;
                i = r.parent;
                bytes[byteIndex + 3] = (byte)(i & 0xFF);
                bytes[byteIndex + 2] = (byte)((i >>>= 8) & 0xFF);
                bytes[byteIndex + 1] = (byte)((i >>>= 8) & 0xFF);
                bytes[byteIndex] = (byte)((i >>>= 8) & 0xFF);
                i >>>= 8;
                byteIndex += 4;
                byteIndex += TransferableGraph1Serializer.writeUTF(r.name, bytes, byteIndex);
            } else if (id.definition instanceof External) {
                r = (External)id.definition;
                bytes[byteIndex++] = 1;
                i = ((External)r).parent;
                bytes[byteIndex + 3] = (byte)(i & 0xFF);
                bytes[byteIndex + 2] = (byte)((i >>>= 8) & 0xFF);
                bytes[byteIndex + 1] = (byte)((i >>>= 8) & 0xFF);
                bytes[byteIndex] = (byte)((i >>>= 8) & 0xFF);
                i >>>= 8;
                byteIndex += 4;
                byteIndex += TransferableGraph1Serializer.writeUTF(((External)r).name, bytes, byteIndex);
            } else if (id.definition instanceof Root) {
                bytes[byteIndex++] = 0;
                r = (Root)id.definition;
                byteIndex += TransferableGraph1Serializer.writeUTF(((Root)r).name, bytes, byteIndex);
                byteIndex += TransferableGraph1Serializer.writeUTF(((Root)r).type, bytes, byteIndex);
            } else if (id.definition instanceof Optional) {
                r = (Optional)id.definition;
                bytes[byteIndex++] = 2;
                i = ((Optional)r).parent;
                bytes[byteIndex + 3] = (byte)(i & 0xFF);
                bytes[byteIndex + 2] = (byte)((i >>>= 8) & 0xFF);
                bytes[byteIndex + 1] = (byte)((i >>>= 8) & 0xFF);
                bytes[byteIndex] = (byte)((i >>>= 8) & 0xFF);
                i >>>= 8;
                byteIndex += 4;
                byteIndex += TransferableGraph1Serializer.writeUTF(((Optional)r).name, bytes, byteIndex);
            }
            ++n4;
        }
        i = tg.statements.length;
        bytes[byteIndex + 3] = (byte)(i & 0xFF);
        bytes[byteIndex + 2] = (byte)((i >>>= 8) & 0xFF);
        bytes[byteIndex + 1] = (byte)((i >>>= 8) & 0xFF);
        bytes[byteIndex] = (byte)((i >>>= 8) & 0xFF);
        i >>>= 8;
        byteIndex += 4;
        objectArray2 = tg.statements;
        n3 = tg.statements.length;
        n4 = 0;
        while (n4 < n3) {
            Identity s = objectArray2[n4];
            i = s;
            bytes[byteIndex + 3] = (byte)(i & 0xFF);
            bytes[byteIndex + 2] = (byte)((i >>>= 8) & 0xFF);
            bytes[byteIndex + 1] = (byte)((i >>>= 8) & 0xFF);
            bytes[byteIndex] = (byte)((i >>>= 8) & 0xFF);
            i >>>= 8;
            byteIndex += 4;
            ++n4;
        }
        i = tg.values.length;
        bytes[byteIndex + 3] = (byte)(i & 0xFF);
        bytes[byteIndex + 2] = (byte)((i >>>= 8) & 0xFF);
        bytes[byteIndex + 1] = (byte)((i >>>= 8) & 0xFF);
        bytes[byteIndex] = (byte)((i >>>= 8) & 0xFF);
        i >>>= 8;
        byteIndex += 4;
        objectArray2 = tg.values;
        n3 = tg.values.length;
        n4 = 0;
        while (n4 < n3) {
            Identity v = objectArray2[n4];
            i = ((Value)((Object)v)).resource;
            bytes[byteIndex + 3] = (byte)(i & 0xFF);
            bytes[byteIndex + 2] = (byte)((i >>>= 8) & 0xFF);
            bytes[byteIndex + 1] = (byte)((i >>>= 8) & 0xFF);
            bytes[byteIndex] = (byte)((i >>>= 8) & 0xFF);
            i >>>= 8;
            byte[] temp = variantSerializer.serialize(((Value)((Object)v)).value);
            System.arraycopy(temp, 0, bytes, byteIndex += 4, temp.length);
            byteIndex += temp.length;
            ++n4;
        }
        System.arraycopy(extensions, 0, bytes, byteIndex, extensions.length);
        return bytes;
    }

    @Override
    public void serialize(DataOutput out, TObjectIntHashMap<Object> identities, Object obj) throws IOException {
        TransferableGraph1.SERIALIZER.serialize(out, identities, obj);
    }

    @Override
    public void serialize(DataOutput out, Object obj) throws IOException {
        TransferableGraph1.SERIALIZER.serialize(out, obj);
    }

    @Override
    public Object deserialize(DataInput in, List<Object> identities) throws IOException {
        return TransferableGraph1.SERIALIZER.deserialize(in, identities);
    }

    @Override
    public Object deserialize(DataInput in) throws IOException {
        return TransferableGraph1.SERIALIZER.deserialize(in);
    }

    @Override
    public void deserializeTo(DataInput in, List<Object> identities, Object obj) throws IOException {
        TransferableGraph1.SERIALIZER.deserializeTo(in, identities, obj);
    }

    @Override
    public void deserializeTo(DataInput in, Object obj) throws IOException {
        TransferableGraph1.SERIALIZER.deserializeTo(in, obj);
    }

    @Override
    public void skip(DataInput in, List<Object> identities) throws IOException {
        TransferableGraph1.SERIALIZER.skip(in, identities);
    }

    @Override
    public void skip(DataInput in) throws IOException {
        TransferableGraph1.SERIALIZER.skip(in);
    }

    @Override
    public Integer getConstantSize() {
        return TransferableGraph1.SERIALIZER.getConstantSize();
    }

    @Override
    public int getSize(Object obj, TObjectIntHashMap<Object> identities) throws IOException {
        return TransferableGraph1.SERIALIZER.getSize(obj, identities);
    }

    @Override
    public int getSize(Object obj) throws IOException {
        return TransferableGraph1.SERIALIZER.getSize(obj);
    }

    @Override
    public int getMinSize() {
        return TransferableGraph1.SERIALIZER.getMinSize();
    }
}

