/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util.binary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Endian {
    public static void writeUInt24(DataOutput out, int value) throws IOException {
        out.write(value >> 16 & 0xFF);
        out.write(value >> 8 & 0xFF);
        out.write(value & 0xFF);
    }

    public static int readUInt24(DataInput in) throws IOException {
        return in.readByte() << 16 & 0xFFFFFF | in.readByte() << 8 | in.readByte();
    }

    public static void writeDynamicUInt32(DataOutput out, int length) throws IOException {
        if (length < 128) {
            out.write((byte)length);
        } else if ((length -= 128) < 16384) {
            out.write(length & 0x3F | 0x80);
            out.write(length >>> 6);
        } else if ((length -= 16384) < 0x200000) {
            out.write(length & 0x1F | 0xC0);
            out.write(length >>> 5 & 0xFF);
            out.write(length >>> 13 & 0xFF);
        } else if ((length -= 0x200000) < 0x10000000) {
            out.write(length & 0xF | 0xE0);
            out.write(length >>> 4 & 0xFF);
            out.write(length >>> 12 & 0xFF);
            out.write(length >>> 20 & 0xFF);
        } else {
            out.write((length -= 0x10000000) & 7 | 0xF0);
            out.write(length >>> 3 & 0xFF);
            out.write(length >>> 11 & 0xFF);
            out.write(length >>> 19 & 0xFF);
            out.write(length >>> 27 & 0xFF);
        }
    }

    public static int readDynamicUInt32(DataInput in) throws IOException {
        int length = in.readByte() & 0xFF;
        if (length >= 128) {
            if (length >= 192) {
                if (length >= 224) {
                    if (length >= 240) {
                        length &= 0xF;
                        length += (in.readByte() & 0xFF) << 3;
                        length += (in.readByte() & 0xFF) << 11;
                        length += (in.readByte() & 0xFF) << 19;
                        length += 270549120;
                    } else {
                        length &= 0x1F;
                        length += (in.readByte() & 0xFF) << 4;
                        length += (in.readByte() & 0xFF) << 12;
                        length += (in.readByte() & 0xFF) << 20;
                        length += 2113664;
                    }
                } else {
                    length &= 0x3F;
                    length += (in.readByte() & 0xFF) << 5;
                    length += (in.readByte() & 0xFF) << 13;
                    length += 16512;
                }
            } else {
                length &= 0x7F;
                length += (in.readByte() & 0xFF) << 6;
                length += 128;
            }
        }
        return length;
    }

    public static int getDynamicUInt32Length(int length) {
        if (length < 128) {
            return 1;
        }
        if (length < 16512) {
            return 2;
        }
        if (length < 0x204000) {
            return 3;
        }
        if (length < 0x10200000) {
            return 4;
        }
        return 5;
    }

    public static int getUInt(DataInput in, int maxValue) throws IOException {
        if (maxValue == 0) {
            return 0;
        }
        if (maxValue < 256) {
            return in.readByte() & 0xFF;
        }
        if (maxValue < 65536) {
            return in.readShort() & 0xFFFF;
        }
        if (maxValue < 0x1000000) {
            return Endian.readUInt24(in) & 0xFFFFFF;
        }
        return in.readInt();
    }

    public static int getUIntLength(int maxValue) {
        if (maxValue == 0) {
            return 0;
        }
        if (maxValue < 256) {
            return 1;
        }
        if (maxValue < 65536) {
            return 2;
        }
        if (maxValue < 0x1000000) {
            return 3;
        }
        return 4;
    }

    public static void putUInt(DataOutput out, int value, int maxValue) throws IOException {
        if (maxValue != 0) {
            if (maxValue < 256) {
                out.write(value);
            } else if (maxValue < 65536) {
                out.writeShort(value);
            } else if (maxValue < 0x1000000) {
                Endian.writeUInt24(out, value);
            } else {
                out.writeInt(value);
            }
        }
    }
}

