/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util.binary;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.simantics.databoard.util.binary.RandomAccessBinary;
import org.simantics.databoard.util.binary.UTF8;

public class BinaryMemory
implements RandomAccessBinary {
    ByteBuffer buf;
    long pointer;
    int increment;

    public BinaryMemory() {
        this.buf = ByteBuffer.allocate(16);
        this.increment = 16;
    }

    public BinaryMemory(byte[] data) {
        this.buf = ByteBuffer.wrap(data);
    }

    public BinaryMemory(int initialSize) {
        this.buf = ByteBuffer.allocate(initialSize);
        this.increment = Math.max(16, initialSize);
    }

    public BinaryMemory(int initialSize, int increment) {
        this.buf = ByteBuffer.allocate(initialSize);
        this.increment = increment;
    }

    public BinaryMemory(ByteBuffer buf) {
        this.buf = buf;
    }

    public ByteBuffer toByteBuffer() {
        return this.buf;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public byte readByte() {
        this.assertHasReadableBytes(1L);
        this.buf.position((int)this.pointer);
        byte result = this.buf.get();
        ++this.pointer;
        return result;
    }

    int _read() {
        if (this.pointer >= (long)this.buf.limit()) {
            return -1;
        }
        this.buf.position((int)this.pointer);
        byte result = this.buf.get();
        ++this.pointer;
        return result & 0xFF;
    }

    @Override
    public final String readLine() throws IOException {
        StringBuffer input = new StringBuffer();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this._read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    break;
                }
                case 13: {
                    eol = true;
                    long cur = this.position();
                    if (this._read() == 10) continue block4;
                    this.position(cur);
                    break;
                }
                default: {
                    input.append((char)c);
                }
            }
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.assertHasReadableBytes(1L);
        this.buf.position((int)this.pointer);
        byte result = this.buf.get();
        ++this.pointer;
        return result != 0;
    }

    @Override
    public void readFully(byte[] dst, int offset, int length) {
        this.assertHasReadableBytes(length);
        this.buf.position((int)this.pointer);
        this.buf.get(dst, offset, length);
        this.pointer += (long)length;
    }

    @Override
    public void readFully(byte[] dst) {
        this.assertHasReadableBytes(dst.length);
        this.buf.position((int)this.pointer);
        this.buf.get(dst);
        this.pointer += (long)dst.length;
    }

    @Override
    public void readFully(ByteBuffer buf) {
        int bytes = buf.remaining();
        this.assertHasReadableBytes(bytes);
        buf.position((int)this.pointer);
        if (buf.hasArray()) {
            this.buf.get(buf.array(), buf.arrayOffset() + buf.position(), bytes);
            buf.position(buf.capacity());
        } else {
            buf.put(buf);
        }
        this.pointer += (long)bytes;
    }

    @Override
    public void readFully(ByteBuffer buf, int length) {
        this.assertHasReadableBytes(length);
        buf.position((int)this.pointer);
        if (buf.hasArray()) {
            this.buf.get(buf.array(), buf.arrayOffset() + buf.position(), length);
            buf.position(buf.position() + length);
        } else {
            int len = length;
            int origLimit = this.buf.limit();
            try {
                this.buf.limit(this.buf.position() + len);
                buf.put(this.buf);
            }
            finally {
                this.buf.limit(origLimit);
            }
        }
        this.pointer += (long)length;
    }

    @Override
    public double readDouble() {
        this.assertHasReadableBytes(8L);
        this.buf.position((int)this.pointer);
        double value = this.buf.getDouble();
        this.pointer += 8L;
        return value;
    }

    @Override
    public float readFloat() {
        this.assertHasReadableBytes(4L);
        this.buf.position((int)this.pointer);
        float result = this.buf.getFloat();
        this.pointer += 4L;
        return result;
    }

    @Override
    public int readInt() {
        this.assertHasReadableBytes(4L);
        this.buf.position((int)this.pointer);
        int value = this.buf.getInt();
        this.pointer += 4L;
        return value;
    }

    @Override
    public long readLong() {
        this.assertHasReadableBytes(8L);
        this.buf.position((int)this.pointer);
        long value = this.buf.getLong();
        this.pointer += 8L;
        return value;
    }

    @Override
    public short readShort() {
        this.assertHasReadableBytes(2L);
        this.buf.position((int)this.pointer);
        short result = this.buf.getShort();
        this.pointer += 2L;
        return result;
    }

    @Override
    public char readChar() {
        this.assertHasReadableBytes(2L);
        this.buf.position((int)this.pointer);
        char result = this.buf.getChar();
        this.pointer += 2L;
        return result;
    }

    @Override
    public int readUnsignedShort() {
        this.assertHasReadableBytes(2L);
        this.buf.position((int)this.pointer);
        int result = this.buf.getShort() & 0xFFFF;
        this.pointer += 2L;
        return result;
    }

    @Override
    public long length() {
        return this.buf.limit();
    }

    @Override
    public long position() {
        return this.pointer;
    }

    @Override
    public void position(long newPosition) throws IOException {
        this.pointer = newPosition;
    }

    @Override
    public void write(int b) throws IOException {
        this.assertHasWritableBytes(1L);
        this.buf.position((int)this.pointer);
        this.buf.put((byte)b);
        ++this.pointer;
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.assertHasWritableBytes(1L);
        this.buf.position((int)this.pointer);
        this.buf.put((byte)b);
        ++this.pointer;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.assertHasWritableBytes(1L);
        this.buf.position((int)this.pointer);
        this.buf.put((byte)(v ? 1 : 0));
        ++this.pointer;
    }

    @Override
    public void writeFully(ByteBuffer src) throws IOException {
        long bytes = src.remaining();
        this.assertHasWritableBytes(bytes);
        this.buf.position((int)this.pointer);
        this.buf.put(src);
        this.pointer += bytes;
    }

    @Override
    public void writeFully(ByteBuffer src, int length) throws IOException {
        this.assertHasWritableBytes(length);
        this.buf.position((int)this.pointer);
        if (src.hasArray()) {
            byte[] array = src.array();
            this.buf.put(array, src.arrayOffset() + src.position(), length);
        } else {
            int i = 0;
            while (i < length) {
                this.buf.put(src.get());
                ++i;
            }
        }
        this.pointer += (long)length;
    }

    public void put(InputStream is) throws IOException {
        long oldLen = this.length();
        while (is.available() > 0) {
            int n = is.available();
            this.assertHasWritableBytes(n);
            byte[] buf = this.buf.array();
            n = is.read(buf, (int)this.pointer, n);
            this.pointer += (long)n;
        }
        long newLen = this.length();
        if (newLen > oldLen & this.pointer < newLen) {
            this.setLength(this.pointer);
        }
    }

    @Override
    public void write(byte[] src, int offset, int length) throws IOException {
        this.assertHasWritableBytes(length);
        this.buf.position((int)this.pointer);
        this.buf.put(src, offset, length);
        this.pointer += (long)length;
    }

    @Override
    public void write(byte[] src) throws IOException {
        this.assertHasWritableBytes(src.length);
        this.buf.position((int)this.pointer);
        this.buf.put(src);
        this.pointer += (long)src.length;
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.assertHasWritableBytes(8L);
        this.buf.position((int)this.pointer);
        this.buf.putDouble(value);
        this.pointer += 8L;
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.assertHasWritableBytes(4L);
        this.buf.position((int)this.pointer);
        this.buf.putFloat(value);
        this.pointer += 4L;
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.assertHasWritableBytes(4L);
        this.buf.position((int)this.pointer);
        this.buf.putInt(value);
        this.pointer += 4L;
    }

    @Override
    public void writeLong(long value) throws IOException {
        this.assertHasWritableBytes(8L);
        this.buf.position((int)this.pointer);
        this.buf.putLong(value);
        this.pointer += 8L;
    }

    @Override
    public void writeShort(int value) throws IOException {
        this.assertHasWritableBytes(2L);
        this.buf.position((int)this.pointer);
        this.buf.putShort((short)value);
        this.pointer += 2L;
    }

    @Override
    public void writeChar(int value) throws IOException {
        this.assertHasWritableBytes(2L);
        this.buf.position((int)this.pointer);
        this.buf.putShort((short)value);
        this.pointer += 2L;
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        this.assertHasWritableBytes(len);
        this.buf.position((int)this.pointer);
        int i = 0;
        while (i < len) {
            this.buf.put((byte)s.charAt(i));
            ++i;
        }
        this.pointer += (long)len;
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        this.assertHasWritableBytes(len * 2);
        int i = 0;
        while (i < len) {
            char v = s.charAt(i);
            this.buf.put((byte)(v >>> 8 & 0xFF));
            this.buf.put((byte)(v >>> 0 & 0xFF));
            ++i;
        }
        this.pointer += (long)(len * 2);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        int len = UTF8.getModifiedUTF8EncodingByteLength(s);
        this.writeShort(len);
        UTF8.writeModifiedUTF(this, s);
    }

    void assertHasReadableBytes(long count) {
        if (this.pointer + count > (long)this.buf.limit()) {
            throw new IndexOutOfBoundsException();
        }
    }

    void assertHasWritableBytes(long count) throws IOException {
        if (this.pointer + count > (long)this.buf.limit()) {
            this.setLength(this.pointer + count);
        }
    }

    @Override
    public void insertBytes(long bytes, RandomAccessBinary.ByteSide side) throws IOException {
        if (this.pointer < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long oldLength = this.length();
        long newLength = Math.max(oldLength + bytes, this.pointer + bytes);
        if (newLength < (long)this.buf.capacity()) {
            this.buf.limit((int)newLength);
            if (this.pointer > oldLength) {
                return;
            }
            if (this.buf.hasArray()) {
                System.arraycopy(this.buf.array(), (int)this.pointer, this.buf.array(), (int)(this.pointer + bytes), (int)(oldLength - this.pointer));
            } else {
                byte[] b = new byte[(int)(oldLength - this.pointer)];
                this.buf.position((int)this.pointer);
                this.buf.get(b);
                this.buf.position((int)(this.pointer + bytes));
                this.buf.put(b);
            }
        } else {
            long inc = Math.max((long)this.increment, newLength / 4L);
            ByteBuffer oldBuf = this.buf;
            ByteBuffer newBuf = ByteBuffer.allocate((int)(newLength + inc));
            newBuf.limit((int)newLength);
            newBuf.position(0);
            oldBuf.position(0);
            oldBuf.get(newBuf.array(), 0, (int)this.pointer);
            if (this.pointer < oldLength) {
                oldBuf.get(newBuf.array(), (int)(this.pointer + bytes), (int)(oldLength - this.pointer));
            }
            this.buf = newBuf;
        }
    }

    @Override
    public void removeBytes(long bytes, RandomAccessBinary.ByteSide side) throws IOException {
        long oldLength = this.length();
        long newLength = oldLength - bytes;
        if (this.pointer < 0L || this.pointer >= this.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.buf.hasArray()) {
            System.arraycopy(this.buf.array(), (int)(this.pointer + bytes), this.buf.array(), (int)this.pointer, (int)(newLength - this.pointer));
        } else {
            byte[] b = new byte[(int)(oldLength - this.pointer)];
            this.buf.position((int)(this.pointer + bytes));
            this.buf.get(b);
            this.buf.position((int)this.pointer);
            this.buf.put(b);
        }
        this.buf.limit((int)newLength);
    }

    @Override
    public void setLength(long newLength) throws IOException {
        int oldLength = (int)this.length();
        if ((long)oldLength == newLength) {
            return;
        }
        if (newLength <= (long)oldLength) {
            this.buf.limit((int)newLength);
        } else if (newLength <= (long)this.buf.capacity()) {
            this.buf.limit((int)newLength);
        } else {
            ByteBuffer oldBuf = this.buf;
            long inc = Math.max((long)this.increment, newLength / 4L);
            ByteBuffer newBuf = ByteBuffer.allocate((int)(newLength + inc));
            oldBuf.position(0);
            oldBuf.get(newBuf.array(), 0, oldLength);
            newBuf.limit((int)newLength);
            this.buf = newBuf;
        }
    }

    @Override
    public long skipBytes(long bytes) throws IOException {
        this.pointer += bytes;
        return bytes;
    }

    @Override
    public int skipBytes(int bytes) throws IOException {
        this.pointer += (long)bytes;
        return bytes;
    }

    public String toString() {
        return "Mem(" + this.length() + ")";
    }
}

