/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public final class URIUtil {
    static final Charset UTF8 = Charset.forName("UTF-8");
    static final byte[] encodeTable = new byte[128];

    static {
        int i = 0;
        while (i < 128) {
            char c = (char)i;
            URIUtil.encodeTable[i] = c == ' ' ? 95 : (Character.isJavaIdentifierPart(c) && c != '_' && c != '$' ? (int)i : -1);
            ++i;
        }
    }

    public static byte[] encode(String str, byte escapeChar, boolean identifier) throws UnsupportedEncodingException {
        byte[] bytes = str.getBytes(UTF8);
        boolean prefixWithUnderscore = identifier && bytes.length > 0 && (bytes[0] == 95 || Character.isDigit(bytes[0]));
        int length = bytes.length;
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b < 0 || encodeTable[b] == -1) {
                length += 2;
            }
            ++n2;
        }
        if (prefixWithUnderscore) {
            ++length;
        }
        if (length == bytes.length) {
            int i = 0;
            while (i < length) {
                bytes[i] = encodeTable[bytes[i]];
                ++i;
            }
            return bytes;
        }
        byte[] result = new byte[length];
        int pos = 0;
        if (prefixWithUnderscore) {
            result[pos++] = 95;
        }
        byte[] byArray2 = bytes;
        int n3 = bytes.length;
        int n4 = 0;
        while (n4 < n3) {
            block9: {
                int ib;
                block8: {
                    block7: {
                        int b = byArray2[n4];
                        ib = b;
                        if (ib < 0) break block7;
                        byte eb = encodeTable[ib];
                        if (eb < 0) break block8;
                        result[pos++] = eb;
                        break block9;
                    }
                    ib += 256;
                }
                result[pos++] = escapeChar;
                result[pos++] = (byte)Character.forDigit(ib >> 4, 16);
                result[pos++] = (byte)Character.forDigit(ib & 0xF, 16);
            }
            ++n4;
        }
        return result;
    }

    public static String encodeURI(String str) {
        try {
            byte[] result = URIUtil.encode(str, (byte)37, false);
            return new String(result, 0, result.length);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public static String encodeIdentifier(String str) {
        try {
            byte[] result = URIUtil.encode(str, (byte)36, true);
            return new String(result, 0, result.length);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public static String decode(byte[] bytes, byte escapeChar, boolean identifier) {
        int length = 0;
        int startPos = 0;
        int i = 0;
        if (identifier && bytes.length > 0 && bytes[0] == 95) {
            startPos = 1;
            i = 1;
        }
        while (i < bytes.length) {
            byte b = bytes[i];
            if (b == escapeChar) {
                i += 2;
            }
            ++length;
            ++i;
        }
        int pos = 0;
        byte[] result = new byte[length];
        int i2 = startPos;
        while (i2 < bytes.length) {
            byte b = bytes[i2];
            if (b == escapeChar) {
                int c = Character.digit((char)bytes[++i2], 16);
                c *= 16;
                result[pos] = (byte)(c += Character.digit((char)bytes[++i2], 16));
            } else {
                result[pos] = b == 95 ? (byte)32 : b;
            }
            ++pos;
            ++i2;
        }
        return new String(result, UTF8);
    }

    public static String decodeURI(String str) {
        return URIUtil.decode(str.getBytes(), (byte)37, false);
    }

    public static String decodeIdentifier(String str) {
        return URIUtil.decode(str.getBytes(), (byte)36, true);
    }
}

