/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import junit.framework.TestCase;
import org.simantics.databoard.util.binary.BinaryFile;
import org.simantics.databoard.util.binary.BinaryReadable;
import org.simantics.databoard.util.binary.BinaryWriteable;
import org.simantics.databoard.util.binary.InputStreamReadable;
import org.simantics.databoard.util.binary.OutputStreamWriteable;

public class TestWriteable
extends TestCase {
    public static final int ITERATIONS = 50;

    public void testWriteRead() throws FileNotFoundException, IOException {
        File tmp1 = File.createTempFile("xyz1", "tmp");
        File tmp2 = File.createTempFile("xyz2", "tmp");
        File tmp3 = File.createTempFile("xyz3", "tmp");
        File tmp4 = File.createTempFile("xyz4", "tmp");
        tmp1.deleteOnExit();
        tmp2.deleteOnExit();
        tmp3.deleteOnExit();
        tmp4.deleteOnExit();
        BinaryFile write1 = new BinaryFile(new RandomAccessFile(tmp1, "rw"));
        OutputStreamWriteable write2 = new OutputStreamWriteable(new FileOutputStream(tmp2, true));
        OutputStreamWriteable write3 = new OutputStreamWriteable(new BufferedOutputStream(new FileOutputStream(tmp3, true)));
        BinaryFile write4 = new BinaryFile(tmp4);
        System.out.println("Write Times:");
        long time2 = TestWriteable.measureWrite(write2);
        long time3 = TestWriteable.measureWrite(write3);
        long time1 = TestWriteable.measureWrite(write1);
        long time4 = TestWriteable.measureWrite(write4);
        System.out.println();
        System.out.println("RandomAccessFile: " + time1);
        System.out.println("FileOutputStream: " + time2);
        System.out.println("FileOutputStream (Buffered) : " + time3);
        System.out.println("BinaryFile : " + time4);
        write4.close();
        BinaryFile read1 = new BinaryFile(new RandomAccessFile(tmp1, "r"));
        InputStreamReadable read2 = new InputStreamReadable(new FileInputStream(tmp2), tmp1.length());
        InputStreamReadable read3 = new InputStreamReadable(new BufferedInputStream(new FileInputStream(tmp3)), tmp1.length());
        BinaryFile read4 = new BinaryFile(tmp4);
        System.out.println("Read Times:");
        time2 = TestWriteable.measureRead(read2);
        time3 = TestWriteable.measureRead(read3);
        time1 = TestWriteable.measureRead(read1);
        time4 = TestWriteable.measureRead(read4);
        System.out.println();
        System.out.println("RandomAccessFile: " + time1);
        System.out.println("FileOutputStream: " + time2);
        System.out.println("FileOutputStream (Buffered) : " + time3);
        System.out.println("BinaryFile : " + time4);
        write1.position(0L);
        time1 = TestWriteable.measureWrite(write1);
        read1.position(0L);
        time2 = TestWriteable.measureRead(read1);
        System.out.println("\nRandomAccessFile (again): write=" + time1 + ", read=" + time2);
    }

    static long measureWrite(BinaryWriteable write) throws IOException {
        System.gc();
        byte[] data = new byte[1024];
        int i = 0;
        while (i < data.length) {
            data[i] = (byte)i;
            ++i;
        }
        long startTime = System.currentTimeMillis();
        int iter = 0;
        while (iter < 50) {
            if (iter % 10 == 0) {
                System.out.print(".");
            }
            int i2 = 0;
            while (i2 < 256) {
                write.write((byte)i2);
                ++i2;
            }
            i2 = 0;
            while (i2 < 256) {
                write.writeDouble(i2);
                ++i2;
            }
            i2 = 0;
            while (i2 < 256) {
                write.writeFloat(i2);
                ++i2;
            }
            i2 = 0;
            while (i2 < 256) {
                write.writeInt(i2);
                ++i2;
            }
            i2 = 0;
            while (i2 < 256) {
                write.writeShort((short)i2);
                ++i2;
            }
            write.write(data);
            ++iter;
        }
        write.flush();
        long elapsedTime = System.currentTimeMillis() - startTime;
        return elapsedTime;
    }

    static long measureRead(BinaryReadable read) throws IOException {
        System.gc();
        byte[] data = new byte[1024];
        long startTime = System.currentTimeMillis();
        int iter = 0;
        while (iter < 50) {
            if (iter % 10 == 0) {
                System.out.print(".");
            }
            int i = 0;
            while (i < 256) {
                TestWriteable.assertEquals((byte)i, read.readByte());
                ++i;
            }
            i = 0;
            while (i < 256) {
                TestWriteable.assertEquals((Object)i, read.readDouble());
                ++i;
            }
            i = 0;
            while (i < 256) {
                TestWriteable.assertEquals(Float.valueOf(i), Float.valueOf(read.readFloat()));
                ++i;
            }
            i = 0;
            while (i < 256) {
                TestWriteable.assertEquals(i, read.readInt());
                ++i;
            }
            i = 0;
            while (i < 256) {
                TestWriteable.assertEquals((short)i, read.readShort());
                ++i;
            }
            read.readFully(data);
            i = 0;
            while (i < data.length) {
                TestWriteable.assertEquals(data[i], (byte)i);
                ++i;
            }
            ++iter;
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        return elapsedTime;
    }
}

