/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import junit.framework.Assert;
import org.junit.Test;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.MapAccessor;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.java.JavaObject;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.util.binary.BinaryMemory;

public class TestPartialMap {
    @Test
    public void testBinary() throws Exception {
        MapType variableSizedType = new MapType(new IntegerType(), new StringType());
        MapType constantSizedType = new MapType(new IntegerType(), new IntegerType());
        this.testVar(this.buildMemory(variableSizedType));
        this.testCons(this.buildMemory(constantSizedType));
        this.testVar(this.buildJava(variableSizedType));
        this.testCons(this.buildJava(constantSizedType));
    }

    MapAccessor buildMemory(Datatype type) throws Exception {
        BinaryMemory m = new BinaryMemory(0);
        Object binding = Bindings.getMutableBinding(type);
        Serializer s = Bindings.getSerializer(binding);
        Object instance = ((Binding)binding).createDefault();
        byte[] data = s.serialize(instance);
        m.write(data);
        m.position(0L);
        m.setLength(data.length);
        return (MapAccessor)Accessors.getAccessor(m, type);
    }

    MapAccessor buildJava(Datatype type) throws Exception {
        Object binding = Bindings.getMutableBinding(type);
        Object instance = ((Binding)binding).createDefault();
        return (MapAccessor)((Object)JavaObject.createAccessor(null, binding, instance, AccessorParams.DEFAULT));
    }

    void testVar(MapAccessor ma) throws Exception {
        Assert.assertEquals(0, ma.size());
        ma.put(Bindings.INTEGER, 0, Bindings.STRING, "0");
        Assert.assertEquals(1, ma.size());
        ma.put(Bindings.INTEGER, 2, Bindings.STRING, "2");
        Assert.assertEquals(2, ma.size());
        ma.put(Bindings.INTEGER, 4, Bindings.STRING, "4");
        Assert.assertEquals(3, ma.size());
        Assert.assertEquals(0, ma.count(Bindings.INTEGER, 2, false, 2, false));
        Assert.assertEquals(1, ma.count(Bindings.INTEGER, 1, true, 3, true));
        Assert.assertEquals(1, ma.count(Bindings.INTEGER, 2, true, 2, true));
        Assert.assertEquals(3, ma.count(Bindings.INTEGER, 0, true, 4, true));
        Assert.assertEquals(1, ma.count(Bindings.INTEGER, 0, false, 4, false));
        Assert.assertEquals(2, ma.count(Bindings.INTEGER, 0, true, 4, false));
        Assert.assertEquals(2, ma.count(Bindings.INTEGER, 0, false, 4, true));
    }

    void testCons(MapAccessor ma) throws Exception {
        Assert.assertEquals(0, ma.size());
        ma.put(Bindings.INTEGER, 0, Bindings.INTEGER, 0);
        Assert.assertEquals(1, ma.size());
        ma.put(Bindings.INTEGER, 2, Bindings.INTEGER, 2);
        Assert.assertEquals(2, ma.size());
        ma.put(Bindings.INTEGER, 4, Bindings.INTEGER, 4);
        Assert.assertEquals(3, ma.size());
        Assert.assertEquals(3, ma.count(Bindings.INTEGER, 0, true, 4, true));
        Assert.assertEquals(1, ma.count(Bindings.INTEGER, 0, false, 4, false));
        Assert.assertEquals(2, ma.count(Bindings.INTEGER, 0, true, 4, false));
        Assert.assertEquals(2, ma.count(Bindings.INTEGER, 0, false, 4, true));
        Assert.assertEquals(0, ma.count(Bindings.INTEGER, 2, false, 2, false));
        Assert.assertEquals(1, ma.count(Bindings.INTEGER, 1, true, 3, true));
        Assert.assertEquals(1, ma.count(Bindings.INTEGER, 2, true, 2, true));
    }
}

