/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.serialization.Serializer;

public class TestMaliciousData {
    @Test
    public void testArray() throws Exception {
        byte[] data;
        Object b = Bindings.getBinding(List.class, Integer.class);
        Serializer s = Bindings.getSerializer(b);
        try {
            byte[] byArray = new byte[9];
            byArray[0] = -1;
            byArray[1] = -1;
            byArray[2] = -1;
            byArray[3] = -1;
            byArray[5] = 1;
            byArray[6] = 2;
            byArray[7] = 3;
            byArray[8] = 4;
            data = byArray;
            s.deserialize(data);
            Assert.fail("Deserialization did not fail expectedly on negative length array");
        }
        catch (IOException data2) {
            // empty catch block
        }
        try {
            byte[] byArray = new byte[9];
            byArray[0] = 10;
            byArray[1] = 10;
            byArray[2] = 10;
            byArray[3] = 10;
            byArray[5] = 1;
            byArray[6] = 2;
            byArray[7] = 3;
            byArray[8] = 4;
            data = byArray;
            s.deserialize(data);
            Assert.fail("Deserialization did not fail expectedly on too long array");
        }
        catch (IOException data3) {
            // empty catch block
        }
        try {
            byte[] byArray = new byte[8];
            byArray[3] = 1;
            byArray[5] = 1;
            byArray[6] = 2;
            byArray[7] = 3;
            data = byArray;
            s.deserialize(data);
        }
        catch (IOException e) {
            Assert.fail("Deserialization did not work");
        }
    }

    @Test
    public void testBooleanArray() throws Exception {
        byte[] data;
        ArrayBinding b = Bindings.BOOLEAN_ARRAY;
        Serializer s = Bindings.getSerializer(b);
        try {
            byte[] byArray = new byte[9];
            byArray[0] = -1;
            byArray[1] = -1;
            byArray[2] = -1;
            byArray[3] = -1;
            byArray[5] = 1;
            byArray[6] = 2;
            byArray[7] = 3;
            byArray[8] = 4;
            data = byArray;
            s.deserialize(data);
            Assert.fail("Deserialization did not fail expectedly on negative length array");
        }
        catch (IOException data2) {
            // empty catch block
        }
        try {
            byte[] byArray = new byte[9];
            byArray[0] = 10;
            byArray[1] = 10;
            byArray[2] = 10;
            byArray[3] = 10;
            byArray[5] = 1;
            byArray[6] = 2;
            byArray[7] = 3;
            byArray[8] = 4;
            data = byArray;
            s.deserialize(data);
            Assert.fail("Deserialization did not fail expectedly on too long array");
        }
        catch (IOException data3) {
            // empty catch block
        }
        try {
            byte[] byArray = new byte[5];
            byArray[3] = 1;
            byArray[4] = 1;
            data = byArray;
            s.deserialize(data);
        }
        catch (IOException e) {
            Assert.fail("Deserialization did not work");
        }
    }

    @Test
    public void testMap() throws Exception {
        byte[] data;
        Object b = Bindings.getBinding(Map.class, Integer.class, Integer.class);
        Serializer s = Bindings.getSerializer(b);
        try {
            byte[] byArray = new byte[12];
            byArray[0] = -1;
            byArray[1] = -1;
            byArray[2] = -1;
            byArray[3] = -1;
            byArray[5] = 1;
            byArray[6] = 2;
            byArray[7] = 3;
            byArray[8] = 4;
            byArray[9] = 5;
            byArray[10] = 6;
            byArray[11] = 7;
            data = byArray;
            s.deserialize(data);
            Assert.fail("Deserialization did not fail expectedly on negative length array");
        }
        catch (IOException data2) {
            // empty catch block
        }
        try {
            byte[] byArray = new byte[9];
            byArray[0] = 10;
            byArray[1] = 10;
            byArray[2] = 10;
            byArray[3] = 10;
            byArray[5] = 1;
            byArray[6] = 2;
            byArray[7] = 3;
            byArray[8] = 4;
            data = byArray;
            s.deserialize(data);
            Assert.fail("Deserialization did not fail expectedly on too long array");
        }
        catch (IOException data3) {
            // empty catch block
        }
        try {
            byte[] byArray = new byte[12];
            byArray[3] = 1;
            byArray[4] = 1;
            byArray[8] = 1;
            data = byArray;
            s.deserialize(data);
        }
        catch (IOException e) {
            Assert.fail("Deserialization did not work");
        }
    }
}

