/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import junit.framework.TestCase;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.file.FileList;
import org.simantics.databoard.file.IFileList;

public class TestFileList2
extends TestCase {
    int length = 10240;
    Long[] data1array;
    List<Long> data1list;
    IFileList<Long> data1file;
    Binding data1binding = Bindings.getBindingUnchecked(Long.class);

    @Override
    public void setUp() throws Exception {
        this.data1array = new Long[this.length];
        this.data1list = new ArrayList<Long>(this.length);
        int i = 0;
        while (i < this.length) {
            Long s;
            this.data1array[i] = s = Long.valueOf(i);
            this.data1list.add(s);
            ++i;
        }
        File tmp1 = File.createTempFile("Tmp", ".tmp");
        tmp1.deleteOnExit();
        this.data1file = new FileList<Long>(tmp1, Long.class);
    }

    @Override
    public void tearDown() throws Exception {
        this.data1file.close();
    }

    public void testAppend() throws Exception {
        this.data1file.addAll(this.data1list);
        TestFileList2.assertEquals(this.length, this.data1file.size());
        int i = 0;
        for (Long line : this.data1file) {
            TestFileList2.assertEquals(this.data1array[i++], line);
        }
    }

    public void testClear() throws Exception {
        this.data1file.addAll(this.data1list);
        TestFileList2.assertFalse(this.data1file.isEmpty());
        TestFileList2.assertEquals(this.length, this.data1file.size());
        this.data1file.clear();
        TestFileList2.assertTrue(this.data1file.isEmpty());
        TestFileList2.assertEquals(0, this.data1file.size());
        TestFileList2.assertTrue(this.data1file.getFile().length() < 1024L);
    }

    public void testRemove() throws Exception {
        this.data1file.addAll(this.data1list);
        int i = 0;
        while (i < 10) {
            this.data1file.remove(10);
            TestFileList2.assertEquals(this.length - i - 1, this.data1file.size());
            ++i;
        }
        i = 0;
        while (i < 10) {
            TestFileList2.assertEquals(this.data1array[i], this.data1file.get(i));
            ++i;
        }
        i = 20;
        while (i < this.length) {
            TestFileList2.assertEquals(this.data1array[i], this.data1file.get(i - 10));
            ++i;
        }
    }

    public void testSetAll() throws Exception {
        ArrayList<Long> data2 = new ArrayList<Long>();
        long i = 0L;
        while (i < 500L) {
            data2.add(i + Integer.MAX_VALUE);
            ++i;
        }
        this.data1file.clear();
        ((FileList)this.data1file).setAll(data2);
        TestFileList2.assertEquals(this.data1file.size(), data2.size());
        int i2 = 0;
        while (i2 < data2.size()) {
            TestFileList2.assertEquals(data2.get(i2), this.data1file.get(i2));
            ++i2;
        }
        ((FileList)this.data1file).setAll(this.data1list);
        TestFileList2.assertEquals(this.data1file.size(), this.data1list.size());
        i2 = 0;
        while (i2 < this.data1list.size()) {
            TestFileList2.assertEquals(this.data1list.get(i2), this.data1file.get(i2));
            ++i2;
        }
    }

    public void testInsert() throws Exception {
        this.data1file.addAll(this.data1list);
        int i = 0;
        while (i < 10) {
            this.data1file.add(10 + i, Long.valueOf(-i));
            TestFileList2.assertEquals(this.length + i + 1, this.data1file.size());
            ++i;
        }
        i = 0;
        while (i < 10) {
            TestFileList2.assertEquals(this.data1array[i], this.data1file.get(i));
            ++i;
        }
        i = 0;
        while (i < 10) {
            TestFileList2.assertEquals((Object)(-i), this.data1file.get(i + 10));
            ++i;
        }
        i = 20;
        while (i < this.length - 10) {
            TestFileList2.assertEquals(this.data1array[i + 10], this.data1file.get(i + 20));
            ++i;
        }
    }

    public void testInsertAll() throws Exception {
        this.data1file.addAll(this.data1list);
        this.data1file.addAll(0, this.data1list);
        int i = 0;
        while (i < this.length) {
            TestFileList2.assertEquals(this.data1array[i], this.data1file.get(i));
            ++i;
        }
        i = 0;
        while (i < this.length) {
            TestFileList2.assertEquals(this.data1array[i], this.data1file.get(i + this.length));
            ++i;
        }
    }

    public void testIterator() throws Exception {
        this.data1file.addAll(this.data1list);
        Iterator iter = this.data1file.iterator();
        int i = 0;
        while (iter.hasNext()) {
            TestFileList2.assertEquals(this.data1array[i++], iter.next());
        }
        i = 100;
        ListIterator<Long> li = this.data1file.listIterator(100);
        while (li.hasNext()) {
            TestFileList2.assertEquals(li.nextIndex(), i);
            TestFileList2.assertEquals(this.data1array[i++], li.next());
        }
        TestFileList2.assertTrue(i == this.length);
        i = this.data1file.size();
        li = this.data1file.listIterator(i);
        while (li.hasPrevious()) {
            TestFileList2.assertEquals(li.previousIndex(), --i);
            TestFileList2.assertEquals(this.data1array[i], li.previous());
        }
        li = this.data1file.listIterator();
        while (li.hasNext()) {
            li.next();
            li.set(Long.valueOf(-li.nextIndex()));
        }
        li = this.data1file.listIterator(0);
        while (li.hasNext()) {
            Long value = (Long)li.next();
            TestFileList2.assertEquals((Object)(-li.nextIndex()), value);
        }
    }

    public void testIndexOf() throws Exception {
        this.data1file.addAll(this.data1list);
        TestFileList2.assertEquals(2, this.data1file.indexOf(2L));
        TestFileList2.assertEquals(99, this.data1file.lastIndexOf(99L));
        TestFileList2.assertEquals(-1, this.data1file.indexOf(-5));
        TestFileList2.assertEquals(-1, this.data1file.lastIndexOf(-5));
    }

    public void testContains() throws Exception {
        this.data1file.addAll(this.data1list);
        TestFileList2.assertTrue(this.data1file.contains(5L));
        TestFileList2.assertTrue(this.data1file.contains(50L));
        TestFileList2.assertFalse(this.data1file.contains(Long.MAX_VALUE));
    }

    public void testSubList() throws Exception {
        this.data1file.addAll(this.data1list);
        List subList = this.data1file.subList(10, 110);
        TestFileList2.assertEquals(100, subList.size());
        int i = 0;
        while (i < 100) {
            TestFileList2.assertEquals(this.data1array[i + 10], subList.get(i));
            ++i;
        }
    }

    public void testToArray() throws Exception {
        this.data1file.addAll(this.data1list);
        Object[] array = this.data1file.toArray((Long[])new Long[0]);
        TestFileList2.assertTrue(Arrays.equals(array, (Object[])this.data1array));
    }

    public void testOpen() throws Exception {
        File file = this.data1file.getFile();
        this.data1file.addAll(this.data1list);
        this.data1file.close();
        this.data1file = new FileList<Long>(file, Long.class);
        int i = 0;
        while (i < this.length) {
            TestFileList2.assertEquals(this.data1array[i], this.data1file.get(i));
            ++i;
        }
    }
}

