/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Random;
import junit.framework.TestCase;
import org.simantics.databoard.accessor.impl.DirectoryWatch;

public class TestDirectoryWatch
extends TestCase {
    File tmpDir;

    public static File createTmpDir() {
        String tmp = System.getenv("tmp");
        if (tmp == null) {
            tmp = "c:/temp";
        }
        Random r = new Random();
        String randomName = "tmp-" + (r.nextInt(10000) + 10000);
        File tmpDir = new File(String.valueOf(tmp) + "/" + randomName);
        Boolean ok = tmpDir.mkdirs();
        TestDirectoryWatch.assertTrue(ok);
        return tmpDir;
    }

    @Override
    public void setUp() throws Exception {
        this.tmpDir = TestDirectoryWatch.createTmpDir();
    }

    @Override
    protected void tearDown() throws Exception {
        boolean ok = this.tmpDir.delete();
        if (!ok) {
            System.err.println(this.tmpDir + " was not removed.");
        }
    }

    public void testAll() throws Exception {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().toLowerCase().endsWith(".dbb");
            }
        };
        DirectoryWatch monitor = new DirectoryWatch(this.tmpDir, filter);
        final DirectoryWatch.DirectoryEvent result = new DirectoryWatch.DirectoryEvent();
        monitor.addListener(new DirectoryWatch.DirectoryListener(){

            @Override
            public void onWatchEvent(DirectoryWatch.DirectoryEvent e) {
                result.filesAdded.addAll(e.filesAdded);
                result.filesRemoved.addAll(e.filesRemoved);
            }
        });
        ArrayList<File> files = new ArrayList<File>();
        int i = 1;
        while (i < 10) {
            files.add(new File(this.tmpDir, "file-" + i + ".dbb"));
            ++i;
        }
        for (File f : files) {
            f.createNewFile();
        }
        Thread.sleep(20000L);
        TestDirectoryWatch.assertTrue(files.containsAll(result.filesAdded));
        TestDirectoryWatch.assertTrue(result.filesAdded.containsAll(files));
        TestDirectoryWatch.assertTrue(result.filesRemoved.isEmpty());
        result.filesAdded.clear();
        for (File f : files) {
            f.delete();
        }
        Thread.sleep(20000L);
        TestDirectoryWatch.assertTrue(files.containsAll(result.filesRemoved));
        TestDirectoryWatch.assertTrue(result.filesRemoved.containsAll(files));
        TestDirectoryWatch.assertTrue(result.filesAdded.isEmpty());
        result.filesRemoved.clear();
        monitor.close();
    }
}

