/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.impl.DoubleBindingDefault;
import org.simantics.databoard.binding.impl.IntegerBindingDefault;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.IntegerType;

public class TestAdapter
extends TestCase {
    public void testUnionAdaption() throws Exception {
        Object fooB = Bindings.getBinding(FooEnum.class);
        Object barB = Bindings.getBinding(BarEnum.class);
        TestAdapter.assertEquals((Object)FooEnum.Audi, Bindings.adapt((Object)BarEnum.Audi, barB, fooB));
        TestAdapter.assertEquals((Object)FooEnum.MercedezBenz, Bindings.adapt((Object)BarEnum.MercedezBenz, barB, fooB));
        TestAdapter.assertEquals((Object)FooEnum.BMW, Bindings.adapt((Object)BarEnum.BMW, barB, fooB));
        try {
            TestAdapter.assertEquals((Object)BarEnum.BMW, Bindings.adapt((Object)FooEnum.BMW, fooB, barB));
            TestAdapter.fail();
        }
        catch (AdaptException adaptException) {
            // empty catch block
        }
    }

    public void testRecordAdaption() throws Exception {
        Object fooB = Bindings.getBinding(Foo2.class);
        Object barB = Bindings.getBinding(Bar2.class);
        Bar2 bar = new Bar2();
        bar.id = 5;
        bar.x = 5.0f;
        bar.y = 7.0f;
        bar.z = 123.432434f;
        Foo2 foo = (Foo2)Bindings.adapt(bar, barB, fooB);
        TestAdapter.assertEquals(Float.valueOf(bar.x), Float.valueOf((float)foo.x));
        TestAdapter.assertEquals(Float.valueOf(bar.y), Float.valueOf((float)foo.y));
        TestAdapter.assertEquals(Float.valueOf(bar.z), Float.valueOf((float)foo.z));
        try {
            Bindings.adapt(foo, fooB, barB);
            TestAdapter.fail();
        }
        catch (AdaptException adaptException) {
            // empty catch block
        }
    }

    public void testPrimitiveAdaptation() throws AdaptException, BindingConstructionException {
        Adapter doubleArray2intArray2;
        try {
            Adapter int2Double = Bindings.getAdapter(Bindings.getBinding(Integer.TYPE), Bindings.getBinding(Double.TYPE));
            TestAdapter.fail("Exception excepted");
        }
        catch (AdapterConstructionException int2Double) {
            // empty catch block
        }
        try {
            Adapter double2Double = Bindings.getAdapter(Bindings.getBinding(Double.TYPE), Bindings.getBinding(Double.TYPE));
            TestAdapter.assertEquals(5.0, double2Double.adapt(5.0));
            Adapter int2Double = Bindings.getTypeAdapter(Bindings.getBinding(Integer.TYPE), Bindings.getBinding(Double.TYPE));
            TestAdapter.assertEquals(5.0, int2Double.adapt(5));
        }
        catch (AdapterConstructionException e) {
            TestAdapter.fail("Exception unexcepted");
        }
        try {
            doubleArray2intArray2 = Bindings.getAdapter(Bindings.getBinding(double[].class), Bindings.getBinding(int[].class));
            TestAdapter.assertEquals(new double[]{5.0, 6.0, 7.0}, doubleArray2intArray2.adapt(new int[]{5, 6, 7}));
            TestAdapter.fail("Exception excepted");
        }
        catch (AdapterConstructionException doubleArray2intArray2) {
            // empty catch block
        }
        try {
            doubleArray2intArray2 = Bindings.getTypeAdapter(Bindings.getBinding(double[].class), Bindings.getBinding(int[].class));
            TestAdapter.assertTrue(Arrays.equals(new int[]{5, 6, 7}, (int[])doubleArray2intArray2.adapt(new double[]{5.0, 6.0, 7.0})));
        }
        catch (AdapterConstructionException e) {
            TestAdapter.fail("Exception unexcepted");
        }
        try {
            doubleArray2intArray2 = Bindings.getTypeAdapter(Bindings.getBinding(Double[].class), Bindings.getBinding(int[].class));
            TestAdapter.assertTrue(Arrays.equals(new int[]{5, 6, 7}, (int[])doubleArray2intArray2.adapt(new Double[]{5.0, 6.0, 7.0})));
        }
        catch (AdapterConstructionException e) {
            TestAdapter.fail("Exception unexcepted");
        }
    }

    public void testUnitAdaptation() throws AdaptException {
        Adapter hours2Seconds;
        try {
            hours2Seconds = Bindings.getAdapter(new DoubleBindingDefault(new DoubleType("h")), new DoubleBindingDefault(new DoubleType("s")));
            TestAdapter.assertEquals(3600.0, hours2Seconds.adapt(1.0));
        }
        catch (AdapterConstructionException e) {
            TestAdapter.fail("Exception unexcepted");
        }
        try {
            Adapter m2ft = Bindings.getAdapter(new DoubleBindingDefault(new DoubleType("m")), new DoubleBindingDefault(new DoubleType("ft")));
            TestAdapter.assertTrue(Math.abs((Double)m2ft.adapt(1.524) - 5.0) < 0.1);
        }
        catch (AdapterConstructionException e) {
            TestAdapter.fail("Exception unexcepted");
        }
        try {
            hours2Seconds = Bindings.getAdapter(new IntegerBindingDefault(new IntegerType("h")), new IntegerBindingDefault(new IntegerType("s")));
            TestAdapter.assertEquals((Object)3600, hours2Seconds.adapt(1));
        }
        catch (AdapterConstructionException e) {
            TestAdapter.fail("Exception unexcepted");
        }
        try {
            Integer hours = 1;
            Double seconds = (Double)Bindings.adapt(hours, new IntegerBindingDefault(new IntegerType("h")), new DoubleBindingDefault(new DoubleType("s")));
            TestAdapter.assertEquals(3600.0, seconds);
        }
        catch (AdaptException e) {
            TestAdapter.fail("Exception unexcepted");
        }
    }

    public void testListAdaption() throws Exception {
        RecordBinding fooBinding = (RecordBinding)Bindings.getBinding(Foo.class);
        ArrayBinding listBinding = (ArrayBinding)fooBinding.getComponentBindings()[0];
        ArrayBinding arrayBinding = (ArrayBinding)fooBinding.getComponentBindings()[1];
        ArrayBinding linkedListBinding = (ArrayBinding)fooBinding.getComponentBindings()[2];
        Adapter list2array = Bindings.getAdapter(listBinding, arrayBinding);
        Adapter array2linkedList = Bindings.getAdapter(arrayBinding, linkedListBinding);
        Foo foo = new Foo();
        foo.list = new ArrayList<String>();
        foo.list.add("XYZ");
        foo.array = (String[])list2array.adapt(foo.list);
        foo.linkedList = (LinkedList)array2linkedList.adapt(foo.array);
        TestAdapter.assertEquals(foo.array[0], foo.list.get(0));
        TestAdapter.assertEquals(foo.list, foo.linkedList);
        TestAdapter.assertEquals(listBinding.hashValue(foo.list), arrayBinding.hashValue(foo.array));
        TestAdapter.assertEquals(listBinding.hashValue(foo.list), linkedListBinding.hashValue(foo.linkedList));
    }

    public void testMapAdaption() throws Exception {
        RecordBinding fooBinding = (RecordBinding)Bindings.getBinding(Foo.class);
        MapBinding hashMapBinding = (MapBinding)fooBinding.getComponentBindings()[3];
        MapBinding treeMapBinding = (MapBinding)fooBinding.getComponentBindings()[4];
        Adapter list2array = Bindings.getAdapter(hashMapBinding, treeMapBinding);
        Foo foo = new Foo();
        foo.hashMap = new HashMap();
        foo.hashMap.put(500, "Indy-500");
        foo.treeMap = (TreeMap)list2array.adapt(foo.hashMap);
        TestAdapter.assertEquals(foo.hashMap, foo.treeMap);
    }

    public void testVariantAdaption() throws Exception {
        VariantBinding variantBinding = (VariantBinding)Bindings.getBinding(Object.class);
        VariantBinding variant2Binding = (VariantBinding)Bindings.getMutableBinding(Datatypes.VARIANT);
        Adapter obj2variant = Bindings.getAdapter(variantBinding, variant2Binding);
        Object genericVariant = obj2variant.adapt("blondi");
        System.out.println(genericVariant);
    }

    public static class Bar2 {
        public int id;
        public float y;
        public float z;
        public float x;
    }

    public static enum BarEnum {
        Audi,
        BMW,
        MercedezBenz;

    }

    public static class Foo {
        List<String> list;
        String[] array;
        LinkedList<String> linkedList;
        HashMap<Integer, String> hashMap;
        TreeMap<Integer, String> treeMap;
    }

    public static class Foo2 {
        public double x;
        public double y;
        public double z;
    }

    public static enum FooEnum {
        Ford,
        Volvo,
        Audi,
        Mazda,
        Nissan,
        Honda,
        Toyota,
        BMW,
        MercedezBenz;

    }
}

