/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.serialization.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.util.Range;

public class BooleanArraySerializer
extends Serializer.NonRecursiveSerializer {
    Range length;
    Integer fixedLength;
    Integer fixedSize;

    public BooleanArraySerializer(ArrayBinding binding) {
        ArrayType arrayType = binding.type();
        this.length = arrayType.getLength();
        if (this.length != null && this.length.getLower().equals(this.length.getUpper()) && this.length.getLower().getValue() != null) {
            this.fixedLength = this.length.getLower().getValue().intValue();
            this.fixedSize = this.fixedLength * 1;
        }
    }

    @Override
    public Object deserialize(DataInput in) throws IOException, SerializationException {
        int length;
        int n = length = this.fixedLength != null ? this.fixedLength.intValue() : in.readInt();
        if (length < 0) {
            throw new SerializationException("Cannot use negative array length");
        }
        this.assertRemainingBytes(in, length);
        boolean[] array = new boolean[length];
        int i = 0;
        while (i < array.length) {
            byte value = in.readByte();
            if (value == 0) {
                array[i] = false;
            } else if (value == 1) {
                array[i] = true;
            } else {
                throw new SerializationException("Unexpected value \"" + value + "\" for boolean");
            }
            ++i;
        }
        return array;
    }

    @Override
    public Object deserializeToTry(DataInput in, List<Object> identities, Object obj) throws IOException {
        boolean[] array;
        int length = this.fixedLength != null ? this.fixedLength.intValue() : in.readInt();
        if (length != (array = (boolean[])obj).length) {
            array = new boolean[length];
        }
        this.assertRemainingBytes(in, length);
        int i = 0;
        while (i < array.length) {
            byte value = in.readByte();
            if (value == 0) {
                array[i] = false;
            } else if (value == 1) {
                array[i] = true;
            } else {
                throw new SerializationException("Unexpected value \"" + value + "\" for boolean");
            }
            ++i;
        }
        return array;
    }

    @Override
    public void deserializeTo(DataInput in, Object obj) throws IOException {
        boolean[] array;
        int length = this.fixedLength != null ? this.fixedLength.intValue() : in.readInt();
        if (length != (array = (boolean[])obj).length) {
            throw new SerializationException("primitive array is size immutable");
        }
        this.assertRemainingBytes(in, length);
        int i = 0;
        while (i < array.length) {
            byte value = in.readByte();
            if (value == 0) {
                array[i] = false;
            } else if (value == 1) {
                array[i] = true;
            } else {
                throw new SerializationException("Unexpected value \"" + value + "\" for boolean");
            }
            ++i;
        }
    }

    @Override
    public void skip(DataInput in) throws IOException {
        int length = this.fixedSize != null ? this.fixedLength.intValue() : in.readInt();
        in.skipBytes(length);
    }

    @Override
    public void serialize(DataOutput out, Object obj) throws IOException {
        boolean[] array = (boolean[])obj;
        if (this.fixedLength == null) {
            out.writeInt(array.length);
        }
        boolean[] blArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            boolean f = blArray[n2];
            out.write((byte)(f ? 1 : 0));
            ++n2;
        }
    }

    @Override
    public Integer getConstantSize() {
        return this.fixedSize;
    }

    @Override
    public int getSize(Object obj) {
        if (this.fixedSize != null) {
            return this.fixedSize;
        }
        boolean[] array = (boolean[])obj;
        return 4 + array.length;
    }

    @Override
    public int getMinSize() {
        return this.fixedSize != null ? this.fixedSize : 4;
    }
}

