/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.example.old;

import java.io.IOException;
import java.net.Inet4Address;
import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.Methods;
import org.simantics.databoard.annotations.Unit;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.method.Client;
import org.simantics.databoard.method.MethodInterface;
import org.simantics.databoard.method.Server;
import org.simantics.databoard.serialization.SerializationException;

public class RPCExample3 {
    public static void main(String[] args) throws IOException, CarNotFoundError, BindingConstructionException, SerializationException, BindingException {
        CarCatalog catalog = new CarCatalog();
        catalog.addCar(new SiCar("Fiat 500", 205.0, 1034.0, 355.0, 75.0));
        MethodInterface serverMi = Methods.bindInterface(SiCarProvider.class, catalog);
        Server myServerSocket = new Server(8193, serverMi);
        Client myClientSocket = new Client(Inet4Address.getByName("localhost"), 8193);
        try {
            SiCarProvider siCarProvider = Methods.createProxy(SiCarProvider.class, serverMi);
            ImCarProvider imCarProvider = Methods.createProxy(ImCarProvider.class, Methods.adaptMethods(serverMi, Methods.getInterfaceType(ImCarProvider.class).getMethodDefinitions()));
            System.out.println(siCarProvider.findCar("Fiat 500"));
            System.out.println(imCarProvider.findCar("Fiat 500"));
        }
        finally {
            myClientSocket.close();
            myServerSocket.close();
        }
    }

    public static class CarCatalog
    implements SiCarProvider {
        Map<String, SiCar> cars = new HashMap<String, SiCar>();

        @Override
        public SiCar findCar(String modelName) throws CarNotFoundError {
            if (this.cars.containsKey(modelName)) {
                return this.cars.get(modelName);
            }
            throw new CarNotFoundError(modelName);
        }

        public void addCar(SiCar car) {
            this.cars.put(car.modelName, car);
        }
    }

    public static class CarNotFoundError
    extends Exception {
        public String modelName;

        public CarNotFoundError(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public String toString() {
            return String.valueOf(this.modelName) + " is not in the catalog";
        }
    }

    public static class ImCar {
        public String modelName;
        @Unit(value="mph")
        public float maxVelocity;
        @Unit(value="lbs")
        public float mass;
        @Unit(value="ft")
        public float length;
        @Unit(value="hp(M)")
        public float power;

        public ImCar(String modelName, float maxVelocity, float mass, float length, float power) {
            this.modelName = modelName;
            this.maxVelocity = maxVelocity;
            this.mass = mass;
            this.length = length;
            this.power = power;
        }

        public String toString() {
            return String.format("Name:%s, Mass: %2.0f lbs, Power: %2.0f hp, Speed: %2.0f mph, Length: %2.0f ft", this.modelName, Float.valueOf(this.mass), Float.valueOf(this.power), Float.valueOf(this.maxVelocity), Float.valueOf(this.length));
        }
    }

    public static interface ImCarProvider {
        public ImCar findCar(String var1) throws CarNotFoundError;
    }

    public static class SiCar {
        public String modelName;
        @Unit(value="km/h")
        public double maxVelocity;
        @Unit(value="kg")
        public double mass;
        @Unit(value="cm")
        public double length;
        @Unit(value="kW")
        public double power;

        public SiCar(String modelName, double maxVelocity, double mass, double length, double power) {
            this.modelName = modelName;
            this.maxVelocity = maxVelocity;
            this.mass = mass;
            this.length = length;
            this.power = power;
        }

        public String toString() {
            return String.format("Name:%s, Mass: %2.0f kg, Power: %2.0f kW, Speed: %2.0f km/h, Length: %2.0f cm", this.modelName, this.mass, this.power, this.maxVelocity, this.length);
        }
    }

    public static interface SiCarProvider {
        public SiCar findCar(String var1) throws CarNotFoundError;
    }
}

