/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.example.old;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;

public class BindingExample {
    public static void main(String[] args) throws IOException, BindingException {
        Object dataType = Datatypes.getDatatypeUnchecked(Rectangle2D.Double.class);
        System.out.println(dataType);
        Object reflectionBinding = Bindings.getBindingUnchecked(Rectangle2D.Double.class);
        Rectangle2DBinding handWrittenBinding = new Rectangle2DBinding();
        System.out.println("Lets measure performance... (4,000,000 reads and 1,000,000 writes*4)");
        Rectangle2D.Double rect = new Rectangle2D.Double(5.0, 5.0, 100.0, 200.0);
        int i = 0;
        while (i < 10) {
            long time1 = BindingExample.testBinding(reflectionBinding, rect);
            long time2 = BindingExample.testBinding(handWrittenBinding, rect);
            time1 = BindingExample.testBinding(reflectionBinding, rect);
            time2 = BindingExample.testBinding(handWrittenBinding, rect);
            System.out.println("Time of reflection based binding: " + time1 + " ms");
            System.out.println("Time of Hand-Written binding: " + time2 + " ms");
            ++i;
        }
    }

    static long testBinding(Binding b, Rectangle2D rect) throws BindingException {
        RecordBinding record = (RecordBinding)b;
        Runtime.getRuntime().gc();
        long timeAtStart = System.currentTimeMillis();
        int i = 0;
        while (i < 10000000) {
            record.getComponent(rect, 0);
            record.getComponent(rect, 1);
            record.getComponent(rect, 2);
            record.getComponent(rect, 3);
            record.setComponents(rect, 5.0, 5.0, 100.0, 200.0);
            ++i;
        }
        return System.currentTimeMillis() - timeAtStart;
    }

    static class Rectangle2DBinding
    extends RecordBinding {
        public Rectangle2DBinding() {
            this.componentBindings = new Binding[4];
            this.componentBindings[0] = Bindings.getBindingUnchecked(Double.class);
            this.componentBindings[1] = Bindings.getBindingUnchecked(Double.class);
            this.componentBindings[2] = Bindings.getBindingUnchecked(Double.class);
            this.componentBindings[3] = Bindings.getBindingUnchecked(Double.class);
            this.type = Datatypes.getDatatypeUnchecked(Rectangle2D.Double.class);
        }

        @Override
        public Object create(Object ... value) {
            return new Rectangle2D.Double((Double)value[0], (Double)value[1], (Double)value[2], (Double)value[3]);
        }

        @Override
        public Object getComponent(Object obj, int index) {
            Rectangle2D rect = (Rectangle2D)obj;
            switch (index) {
                case 0: {
                    return rect.getX();
                }
                case 1: {
                    return rect.getY();
                }
                case 2: {
                    return rect.getWidth();
                }
                case 3: {
                    return rect.getHeight();
                }
            }
            throw new IllegalArgumentException("index out of range, expected 0..3, got " + index);
        }

        @Override
        public Object createPartial() throws BindingException {
            return new Rectangle2D.Double();
        }

        @Override
        public void setComponents(Object obj, Object ... value) {
            Rectangle2D rect = (Rectangle2D)obj;
            rect.setFrame((Double)value[0], (Double)value[1], (Double)value[2], (Double)value[3]);
        }

        @Override
        public void setComponent(Object obj, int index, Object value) throws BindingException {
            Rectangle2D rect = (Rectangle2D)obj;
            switch (index) {
                case 0: {
                    rect.setRect((Double)value, rect.getY(), rect.getWidth(), rect.getHeight());
                    break;
                }
                case 1: {
                    rect.setRect(rect.getX(), (Double)value, rect.getWidth(), rect.getHeight());
                    break;
                }
                case 2: {
                    rect.setRect(rect.getX(), rect.getY(), (Double)value, rect.getHeight());
                    break;
                }
                case 3: {
                    rect.setRect(rect.getX(), rect.getY(), rect.getWidth(), (Double)value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("index out of range, expected 0..3, got " + index);
                }
            }
        }

        @Override
        public boolean isInstance(Object obj) {
            return obj instanceof Rectangle2D;
        }

        @Override
        public void setDouble(Object r, int index, double x) throws BindingException {
            Rectangle2D.Double rect = (Rectangle2D.Double)r;
            switch (index) {
                case 0: {
                    rect.x = x;
                    break;
                }
                case 1: {
                    rect.y = x;
                    break;
                }
                case 2: {
                    rect.width = x;
                    break;
                }
                case 3: {
                    rect.height = x;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("index out of range, expected 0..3, got " + index);
                }
            }
        }

        @Override
        public double getDouble(Object r, int index) throws BindingException {
            Rectangle2D.Double rect = (Rectangle2D.Double)r;
            switch (index) {
                case 0: {
                    return rect.x;
                }
                case 1: {
                    return rect.y;
                }
                case 2: {
                    return rect.width;
                }
                case 3: {
                    return rect.height;
                }
            }
            throw new IllegalArgumentException("index out of range, expected 0..3, got " + index);
        }
    }
}

