/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.example.old;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.annotations.Unit;
import org.simantics.databoard.binding.error.BindingConstructionException;

public class AdaptionExample2 {
    public static void main(String[] args) throws AdapterConstructionException, AdaptException, BindingConstructionException {
        Adapter si2imAdapter = Bindings.getTypeAdapter(Bindings.getBinding(CarSI.class), Bindings.getBinding(CarIm.class));
        CarSI fiatSi = new CarSI();
        fiatSi.modelName = "Fiat 500";
        fiatSi.mass = 1035.0;
        fiatSi.length = 355.0;
        fiatSi.maxVelocity = 205.0;
        fiatSi.power = 75.0;
        CarIm fiatIm = (CarIm)si2imAdapter.adapt(fiatSi);
        System.out.println(fiatSi);
        System.out.println(fiatIm);
    }

    public static class CarIm {
        public String modelName;
        @Unit(value="mph")
        public float maxVelocity;
        @Unit(value="lbs")
        public float mass;
        @Unit(value="ft")
        public float length;
        @Unit(value="hp(M)")
        public float power;

        public String toString() {
            return String.format("Name:%s, Mass: %2.0f lbs, Power: %2.0f hp, Speed: %2.0f mph, Length: %2.0f ft", this.modelName, Float.valueOf(this.mass), Float.valueOf(this.power), Float.valueOf(this.maxVelocity), Float.valueOf(this.length));
        }
    }

    public static class CarSI {
        public String modelName;
        @Unit(value="km/h")
        public double maxVelocity;
        @Unit(value="kg")
        public double mass;
        @Unit(value="cm")
        public double length;
        @Unit(value="kW")
        public double power;

        public String toString() {
            return String.format("Name:%s, Mass: %2.0f kg, Power: %2.0f kW, Speed: %2.0f km/h, Length: %2.0f cm", this.modelName, this.mass, this.power, this.maxVelocity, this.length);
        }
    }
}

