/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.example;

import java.util.ArrayList;
import java.util.Arrays;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.impl.IntegerBindingDefault;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.IntegerType;

public class BindingExample {
    public static void main(String[] args) throws Exception {
        IntegerBinding binding = Bindings.INTEGER;
        Object obj = binding.create(5);
        Integer number = (Integer)obj;
        int value = binding.getValue_(obj);
        Object obj2 = binding.clone(obj);
        System.out.println("Sorting array");
        Object[] array = new Integer[]{5, 2, 10, 6000, -30};
        System.out.println(" unsorted = " + Arrays.toString(array));
        Arrays.sort(array, binding);
        System.out.println(Arrays.toString(array));
        System.out.println(" sorted = " + Arrays.toString(array));
        binding.hashValue(5);
        binding.equals(5, 6);
        binding = new IntegerBindingDefault(new IntegerType(null, "[0..10]"));
        try {
            value = 0;
            System.out.print("Validating " + value + " ");
            binding.assertInstaceIsValid(value);
            System.out.println("ok");
        }
        catch (BindingException e) {
            System.err.println(e);
        }
        try {
            value = 11;
            System.out.print("Validating " + value + " ");
            binding.assertInstaceIsValid(value);
        }
        catch (BindingException e) {
            System.out.println(e);
        }
        System.out.println();
        Object b1 = Bindings.getBinding(int[].class);
        Object b2 = Bindings.getBinding(Integer[].class);
        ArrayType arrayType = new ArrayType(Datatypes.INTEGER);
        Object b3 = Bindings.getMutableBinding(arrayType);
        int[] array1 = new int[]{1, 10, 100, 1000, -23432};
        Object[] array2 = (Integer[])Bindings.adapt(array1, b1, b2);
        ArrayList array3 = (ArrayList)Bindings.adapt(array2, b2, b3);
        System.out.println("Adapting classes:");
        System.out.println(" int[]              = " + Arrays.toString(array1));
        System.out.println(" Integer[]          = " + Arrays.toString(array2));
        System.out.println(" ArrayList<Integer> = " + array3);
        System.out.println();
        value = (Integer)binding.createDefault();
        IntegerType type = new IntegerType(null, "[100..200]");
        binding = new IntegerBindingDefault(type);
        value = (Integer)binding.createDefault();
        System.out.println("Default Value for value for " + type + " is " + value);
        value = (Integer)binding.createRandom(23243);
        System.out.println("Random Value for value for " + type + " is " + value);
        Serializer s = Bindings.getSerializer(binding);
        value = 50;
        byte[] data = s.serialize(value);
        value = (Integer)s.deserialize(data);
    }
}

