/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.AdapterFactory;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.factory.BindingRepository;
import org.simantics.databoard.binding.reflection.BindingRequest;
import org.simantics.databoard.binding.reflection.ClassBindingFactory;
import org.simantics.databoard.binding.reflection.VoidBinding;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.UnionType;

public class ObjectVariantBinding
extends VariantBinding {
    ClassBindingFactory bindingFactory;
    AdapterFactory adapterFactory;

    public ObjectVariantBinding(ClassBindingFactory bindingFactory, AdapterFactory adapterFactory) {
        this.bindingFactory = bindingFactory;
        this.adapterFactory = adapterFactory;
    }

    public ClassBindingFactory getBindingFactory() {
        return this.bindingFactory;
    }

    public BindingRepository getRepository() {
        return this.bindingFactory.getRepository();
    }

    @Override
    public Object create(Binding srcBinding, Object value) throws BindingException {
        if (srcBinding instanceof VoidBinding) {
            return null;
        }
        try {
            BindingRequest request = new BindingRequest(value.getClass(), new Annotation[0]);
            request.componentBinding = srcBinding.getComponentCount() > 0 ? srcBinding.getComponentBinding(0) : null;
            Binding dstBinding = this.bindingFactory.getBinding(request);
            return this.adapterFactory.adapt(value, srcBinding, dstBinding);
        }
        catch (BindingConstructionException e) {
            throw new BindingException(e);
        }
        catch (AdaptException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public Binding getContentBinding(Object variant) throws BindingException {
        try {
            if (variant == null) {
                return VoidBinding.VOID_BINDING;
            }
            BindingRequest request = new BindingRequest(variant.getClass(), new Annotation[0]);
            return this.bindingFactory.construct(request);
        }
        catch (BindingConstructionException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public Datatype getContentType(Object variant) throws BindingException {
        return this.getContentBinding(variant).type();
    }

    @Override
    public Object getContent(Object variant, Binding binding) throws BindingException {
        try {
            Binding binding1 = this.getContentBinding(variant);
            Object value1 = variant;
            Binding binding2 = binding;
            Object value2 = this.adapterFactory.adapt(value1, binding1, binding2);
            return value2;
        }
        catch (AdaptException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public Object getContent(Object variant) throws BindingException {
        return variant;
    }

    @Override
    public void setContent(Object variant, Binding binding, Object value) throws BindingException {
        block7: {
            if (variant == value) {
                return;
            }
            try {
                Binding binding1 = this.getContentBinding(variant);
                Datatype type1 = binding1.type();
                Binding binding2 = binding;
                Datatype type2 = binding2.type();
                if (!type1.equals(type2)) {
                    throw new BindingException("Cannot assign " + value.getClass() + " to " + variant.getClass());
                }
                if (type1 instanceof RecordType) {
                    RecordType recordType = (RecordType)type1;
                    int count = recordType.getComponentCount();
                    RecordBinding rb1 = (RecordBinding)binding1;
                    RecordBinding rb2 = (RecordBinding)binding2;
                    Object[] resultValues = new Object[count];
                    int i = 0;
                    while (i < count) {
                        Object componentValue1;
                        Binding cb1 = rb1.componentBindings[i];
                        Binding cb2 = rb2.componentBindings[i];
                        Object componentValue2 = rb2.getComponent(value, i);
                        resultValues[i] = componentValue1 = this.adapterFactory.adapt(componentValue2, cb2, cb1);
                        ++i;
                    }
                    rb1.setComponents(variant, resultValues);
                    break block7;
                }
                if (type1 instanceof UnionType) {
                    UnionBinding ub1 = (UnionBinding)binding1;
                    UnionBinding ub2 = (UnionBinding)binding2;
                    int tag = ub2.getTag(value);
                    Binding cb1 = ub1.getComponentBindings()[tag];
                    Binding cb2 = ub2.getComponentBindings()[tag];
                    Object componentValue2 = ub2.getValue(value);
                    Object componentValue1 = this.adapterFactory.adapt(componentValue2, cb2, cb1);
                    ub1.setValue(variant, tag, componentValue1);
                    break block7;
                }
                throw new BindingException("Cannot assign " + value.getClass() + " to " + variant.getClass());
            }
            catch (AdaptException e) {
                throw new BindingException(e);
            }
        }
    }

    @Override
    public void assertInstaceIsValid(Object obj, Set<Object> validInstances) throws BindingException {
        this.getContentBinding(obj).assertInstaceIsValid(obj);
    }

    @Override
    public boolean isInstance(Object obj) {
        return true;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }
}

