/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.classfactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.simantics.databoard.binding.classfactory.TypeClassSubFactory;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.factory.TypeRepository;
import org.simantics.databoard.binding.reflection.BindingRequest;
import org.simantics.databoard.type.Datatype;

public class TypeClassFactory {
    Map<Datatype, BindingConstructionException> failures = new HashMap<Datatype, BindingConstructionException>();
    Map<Datatype, Datatype> inprogress = new HashMap<Datatype, Datatype>();
    TypeRepository repository;
    List<TypeClassSubFactory> subFactories = new ArrayList<TypeClassSubFactory>();

    public TypeClassFactory() {
        this.repository = new TypeRepository();
    }

    public TypeClassFactory(TypeRepository repository) {
        this.repository = repository;
    }

    public void addFactory(TypeClassSubFactory factory) {
        if (!this.subFactories.contains(factory)) {
            this.subFactories.add(factory);
        }
    }

    public void addFactoryFirst(TypeClassSubFactory factory) {
        if (!this.subFactories.contains(factory)) {
            this.subFactories.add(0, factory);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public BindingRequest getClass(Datatype type) throws BindingConstructionException {
        Datatype progress = this.inprogress.get(type);
        if (progress != null) {
            Datatype datatype = progress;
            // MONITORENTER : datatype
            // MONITOREXIT : datatype
        }
        if (this.failures.containsKey(type)) {
            throw this.failures.get(type);
        }
        if (this.repository.containsType(type)) {
            return this.repository.getRequestForType(type);
        }
        Datatype datatype = type;
        // MONITORENTER : datatype
        this.inprogress.put(type, type);
        try {
            TypeClassSubFactory sf;
            BindingRequest br = null;
            Iterator<TypeClassSubFactory> iterator = this.subFactories.iterator();
            while (iterator.hasNext() && (br = (sf = iterator.next()).construct(this, type)) == null) {
            }
            if (br == null) {
                throw new BindingConstructionException("Failed to create BindingRequest for type " + type);
            }
            this.repository.put(type, br);
            BindingRequest bindingRequest = br;
            return bindingRequest;
        }
        catch (RuntimeException e) {
            this.failures.put(type, new BindingConstructionException(e));
            throw e;
        }
        catch (BindingConstructionException bce) {
            this.failures.put(type, bce);
            throw bce;
        }
        finally {
            this.inprogress.remove(type);
        }
    }

    public TypeRepository getRepository() {
        return this.repository;
    }
}

