/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding;

import java.util.IdentityHashMap;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.accessor.reference.NameReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.impl.BindingPrintContext;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.util.IdentityPair;

public abstract class UnionBinding
extends Binding {
    protected Binding[] componentBindings;

    public UnionBinding() {
    }

    public UnionBinding(Binding ... componentBindings) {
        this.componentBindings = componentBindings;
    }

    @Override
    public UnionType type() {
        return (UnionType)this.type;
    }

    @Override
    public int getComponentCount() {
        return this.type().getComponentCount();
    }

    @Override
    public Binding getComponentBinding(int tagIndex) {
        return this.componentBindings[tagIndex];
    }

    public Binding getComponentBinding(String tagName) {
        return this.componentBindings[this.type().getComponentIndex2(tagName)];
    }

    public Binding[] getComponentBindings() {
        return this.componentBindings;
    }

    public abstract int getTag(Object var1) throws BindingException;

    public abstract Object getValue(Object var1) throws BindingException;

    public abstract Object create(int var1, Object var2) throws BindingException;

    public Object createDefault(int tag) throws BindingException {
        Binding cb = this.getComponentBinding(tag);
        Object to = cb.createDefault();
        return this.create(tag, to);
    }

    public Object create(String tag, Object value) throws BindingException {
        Integer tagIndex = this.type().getComponentIndex(tag);
        if (tagIndex == null) {
            throw new BindingException("Union type does not have a tag " + tag + ".");
        }
        return this.create(tagIndex, value);
    }

    public Object createUnchecked(int tag, Object value) throws RuntimeBindingException {
        try {
            return this.create(tag, value);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    @Override
    public void readFrom(Binding srcBinding, Object src, Object dst) throws BindingException {
        UnionBinding sb = (UnionBinding)srcBinding;
        int newTag = sb.getTag(src);
        int oldTag = this.getTag(dst);
        Binding nvb = sb.getComponentBinding(newTag);
        Object nv = sb.getValue(src);
        if (newTag == oldTag) {
            Binding ovb = this.getComponentBinding(oldTag);
            Object ov = this.getValue(dst);
            ov = ovb.readFromTry(nvb, nv, ov);
            this.setValue(dst, oldTag, ov);
        } else {
            boolean adapt;
            boolean clone = !nvb.isImmutable();
            Binding dcb = this.getComponentBinding(newTag);
            boolean bl = adapt = nvb != dcb;
            if (!adapt && !clone) {
                this.setValue(dst, newTag, nv);
            } else {
                try {
                    Object dv = Bindings.clone(nv, nvb, dcb);
                    this.setValue(dst, newTag, dv);
                }
                catch (AdaptException e) {
                    throw new BindingException(e);
                }
            }
        }
    }

    public abstract void setValue(Object var1, int var2, Object var3) throws BindingException;

    public void setTag(Object union, int tag) throws BindingException {
        Binding componentBinding = this.getComponentBinding(tag);
        Object instance = componentBinding.createDefault();
        this.setValue(union, tag, instance);
    }

    @Override
    public void accept(Binding.Visitor1 v, Object obj) {
        v.visit(this, obj);
    }

    @Override
    public <T> T accept(Binding.Visitor<T> v) {
        return v.visit(this);
    }

    @Override
    public void assertInstaceIsValid(Object obj, Set<Object> validInstances) throws BindingException {
        UnionType type = this.type();
        int length = type.getComponentCount();
        if (length == 0) {
            return;
        }
        int tag = this.getTag(obj);
        if (tag < 0 || tag >= length) {
            throw new BindingException("Instance tag (" + tag + ") is out of range [0.." + (length - 1) + "], faulty UnionBinding");
        }
        Object componentValue = this.getValue(obj);
        Binding componentBinding = this.getComponentBindings()[tag];
        componentBinding.assertInstaceIsValid(componentValue, validInstances);
    }

    @Override
    public int deepHashValue(Object value, IdentityHashMap<Object, Object> hashedObjects) throws BindingException {
        int tag = this.getTag(value);
        Object element = this.getValue(value);
        return tag + this.componentBindings[tag].deepHashValue(element, hashedObjects);
    }

    @Override
    public int deepCompare(Object o1, Object o2, Set<IdentityPair<Object, Object>> compareHistory) throws BindingException {
        Integer t2;
        Integer t1 = this.getTag(o1);
        int dif = t1.compareTo(t2 = Integer.valueOf(this.getTag(o2)));
        if (dif != 0) {
            return dif;
        }
        Object v1 = this.getValue(o1);
        Object v2 = this.getValue(o2);
        Binding c = this.getComponentBindings()[t1];
        return c.deepCompare(v1, v2, compareHistory);
    }

    public void setComponentBindings(Binding[] componentBindings) {
        this.componentBindings = componentBindings;
    }

    @Override
    protected void toString(Object value, BindingPrintContext ctx) throws BindingException {
        int tag = this.getTag(value);
        ctx.b.append(this.type().getComponent((int)tag).name);
        ctx.b.append(' ');
        this.getComponentBinding(tag).toString(this.getValue(value), ctx);
    }

    @Override
    public Binding getComponentBinding(ChildReference path) {
        if (path == null) {
            return this;
        }
        if (path instanceof IndexReference) {
            IndexReference ir = (IndexReference)path;
            return this.componentBindings[ir.index].getComponentBinding(path.childReference);
        }
        if (path instanceof NameReference) {
            NameReference nr = (NameReference)path;
            return this.getComponentBinding(nr.name).getComponentBinding(path.childReference);
        }
        if (path instanceof LabelReference) {
            LabelReference lr = (LabelReference)path;
            try {
                Integer i = new Integer(lr.label);
                return this.getComponentBinding(i).getComponentBinding(path.childReference);
            }
            catch (NumberFormatException nfe) {
                return this.getComponentBinding(lr.label).getComponentBinding(path.childReference);
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isTagMutable() {
        return true;
    }
}

