/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.wire;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Methods;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.ArrayAccessor;
import org.simantics.databoard.accessor.BooleanAccessor;
import org.simantics.databoard.accessor.ByteAccessor;
import org.simantics.databoard.accessor.CloseableAccessor;
import org.simantics.databoard.accessor.DoubleAccessor;
import org.simantics.databoard.accessor.FloatAccessor;
import org.simantics.databoard.accessor.IntegerAccessor;
import org.simantics.databoard.accessor.LongAccessor;
import org.simantics.databoard.accessor.MapAccessor;
import org.simantics.databoard.accessor.OptionalAccessor;
import org.simantics.databoard.accessor.RecordAccessor;
import org.simantics.databoard.accessor.StringAccessor;
import org.simantics.databoard.accessor.UnionAccessor;
import org.simantics.databoard.accessor.VariantAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.event.ArrayElementRemoved;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.MapEntryAdded;
import org.simantics.databoard.accessor.event.MapEntryRemoved;
import org.simantics.databoard.accessor.event.OptionalValueAssigned;
import org.simantics.databoard.accessor.event.OptionalValueRemoved;
import org.simantics.databoard.accessor.event.ValueAssigned;
import org.simantics.databoard.accessor.impl.ListenerEntry;
import org.simantics.databoard.accessor.interestset.InterestSet;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.ComponentReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.KeyReference;
import org.simantics.databoard.accessor.reference.NameReference;
import org.simantics.databoard.accessor.wire.IWireClient;
import org.simantics.databoard.accessor.wire.IWireServer;
import org.simantics.databoard.accessor.wire.WireException;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.impl.ArrayListBinding;
import org.simantics.databoard.binding.impl.ObjectArrayBinding;
import org.simantics.databoard.binding.impl.TreeMapBinding;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.method.MethodInterface;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.type.VariantType;
import org.simantics.databoard.util.BijectionMap;

public class WireClient
implements IWireClient {
    ReferenceQueue<WireAccessor> releaseQueue = new ReferenceQueue();
    Map<ChildReference, WireAccessorReference> subAccessorMap = new HashMap<ChildReference, WireAccessorReference>();
    BijectionMap<Integer, ListenerEntry> listenerMap = new BijectionMap();
    MethodInterface serverMi;
    MethodInterface clientMi;
    IWireServer server;
    WireAccessor root;

    public WireClient() {
        try {
            this.clientMi = Methods.bindInterface(IWireClient.class, this);
        }
        catch (BindingConstructionException e) {
            throw new RuntimeException(e);
        }
    }

    public void setServerMethodInterface(MethodInterface serverMi) {
        try {
            this.serverMi = serverMi;
            this.server = Methods.createProxy(IWireServer.class, serverMi);
        }
        catch (BindingConstructionException e) {
            throw new RuntimeException(e);
        }
    }

    public MethodInterface getServerMethodInterface() {
        return this.serverMi;
    }

    public MethodInterface getClientMethodInterface() {
        return this.clientMi;
    }

    public void close() {
        try {
            this.closeReleasedAccessors();
        }
        catch (WireException e) {
            e.printStackTrace();
        }
    }

    WireAccessor createAccessor(ChildReference ref) throws WireException {
        IWireServer.AccessorInfo ai = this.server.openAccessor(ref);
        if (ai.type instanceof BooleanType) {
            return new WireBoolean(ai.accessorId, ai.type, ref);
        }
        if (ai.type instanceof ByteType) {
            return new WireByte(ai.accessorId, ai.type, ref);
        }
        if (ai.type instanceof IntegerType) {
            return new WireInteger(ai.accessorId, ai.type, ref);
        }
        if (ai.type instanceof LongType) {
            return new WireLong(ai.accessorId, ai.type, ref);
        }
        if (ai.type instanceof FloatType) {
            return new WireFloat(ai.accessorId, ai.type, ref);
        }
        if (ai.type instanceof DoubleType) {
            return new WireDouble(ai.accessorId, ai.type, ref);
        }
        if (ai.type instanceof StringType) {
            return new WireByte(ai.accessorId, ai.type, ref);
        }
        if (ai.type instanceof MapType) {
            return new WireMap(ai.accessorId, ai.type, ref);
        }
        if (ai.type instanceof OptionalType) {
            return new WireOptional(ai.accessorId, ai.type, ref);
        }
        if (ai.type instanceof RecordType) {
            return new WireRecord(ai.accessorId, ai.type, ref);
        }
        if (ai.type instanceof UnionType) {
            return new WireUnion(ai.accessorId, ai.type, ref);
        }
        if (ai.type instanceof VariantType) {
            return new WireVariant(ai.accessorId, ai.type, ref);
        }
        throw new WireException("error, unknown data type " + ai.type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WireAccessor getAccessor(ChildReference ref) throws WireException {
        Map<ChildReference, WireAccessorReference> map = this.subAccessorMap;
        synchronized (map) {
            WireAccessor result;
            this.closeReleasedAccessors();
            WireAccessorReference war = this.subAccessorMap.get(ref);
            WireAccessor wireAccessor = result = war == null ? null : (WireAccessor)war.get();
            if (result != null) {
                return result;
            }
            result = this.createAccessor(ref);
            war = new WireAccessorReference(result);
            this.subAccessorMap.put(ref, war);
            return result;
        }
    }

    void closeReleasedAccessors() throws WireException {
        if (this.releaseQueue.poll() == null) {
            return;
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        while (this.releaseQueue.poll() != null) {
            try {
                WireAccessorReference ref = (WireAccessorReference)this.releaseQueue.remove();
                ids.add(ref.accId);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.server.closeAccessors(ids.toArray(new Integer[ids.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int onEvents(int lisId, Event[] events) {
        ListenerEntry listener = null;
        BijectionMap<Integer, ListenerEntry> bijectionMap = this.listenerMap;
        synchronized (bijectionMap) {
            listener = this.listenerMap.getRight(lisId);
        }
        if (listener == null) {
            return 0;
        }
        CopyOnWriteArrayList<Event> list = new CopyOnWriteArrayList<Event>(events);
        listener.emitEvents(list);
        return 0;
    }

    abstract class WireAccessor
    implements Accessor,
    CloseableAccessor {
        int accId;
        ChildReference ref;
        Datatype type;

        WireAccessor(int accId, Datatype type, ChildReference ref) {
            this.accId = accId;
            this.type = type;
            this.ref = ref;
        }

        @Override
        public Object getValue(Binding binding) throws AccessorException {
            try {
                MutableVariant value = WireClient.this.server.getValue(this.accId);
                return value.getValue(binding);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public void getValue(Binding binding, Object obj) throws AccessorException {
            throw new AccessorException("not implemented");
        }

        void applyEvent(Event ... events) throws AccessorException {
            IWireServer.ApplyResult result = WireClient.this.server.apply(this.accId, events, false);
            if (result.error != null) {
                throw new AccessorException(result.error);
            }
        }

        @Override
        public void setValue(Binding binding, Object newValue) throws AccessorException {
            this.applyEvent(new ValueAssigned(binding, newValue));
        }

        @Override
        public <T extends Accessor> T getComponent(ChildReference reference) throws AccessorConstructionException {
            try {
                ChildReference r = ChildReference.concatenate(this.ref, reference);
                return (T)WireClient.this.getAccessor(r);
            }
            catch (WireException e) {
                throw new AccessorConstructionException(e);
            }
        }

        @Override
        public void apply(List<Event> changeSet, LinkedList<Event> rollback) throws AccessorException {
            IWireServer.ApplyResult result = WireClient.this.server.apply(this.accId, changeSet.toArray(new Event[changeSet.size()]), rollback != null);
            if (rollback != null && result.rollbackLog != null) {
                rollback.addAll(result.rollbackLog);
            }
            if (result.error != null) {
                throw new AccessorException(result.error);
            }
        }

        @Override
        public Datatype type() {
            return this.type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListener(Accessor.Listener listener, InterestSet interestSet, ChildReference pathPrefix, Executor executor) throws AccessorException {
            try {
                ListenerEntry le = new ListenerEntry(listener, interestSet, pathPrefix, executor);
                int lisId = WireClient.this.server.addListener(this.accId, interestSet, pathPrefix);
                BijectionMap<Integer, ListenerEntry> bijectionMap = WireClient.this.listenerMap;
                synchronized (bijectionMap) {
                    WireClient.this.listenerMap.map(lisId, le);
                }
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListener(Accessor.Listener listener) throws AccessorException {
            Integer lisId = null;
            BijectionMap<Integer, ListenerEntry> bijectionMap = WireClient.this.listenerMap;
            synchronized (bijectionMap) {
                for (Map.Entry<Integer, ListenerEntry> e : WireClient.this.listenerMap.getEntries()) {
                    if (e.getValue().listener != listener) continue;
                    lisId = e.getKey();
                    break;
                }
                if (lisId == null) {
                    return;
                }
                WireClient.this.listenerMap.removeWithLeft(lisId);
            }
            try {
                WireClient.this.server.removeListener(lisId);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public void close() throws AccessorException {
            try {
                WireClient.this.server.closeAccessors(new Integer[]{this.accId});
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
        }
    }

    class WireAccessorReference
    extends WeakReference<WireAccessor> {
        int accId;

        public WireAccessorReference(WireAccessor referent) {
            super(referent, WireClient.this.releaseQueue);
            this.accId = referent.accId;
        }
    }

    class WireArray
    extends WireAccessor
    implements ArrayAccessor {
        WireArray(int accId, Datatype type, ChildReference ref) {
            super(accId, type, ref);
        }

        @Override
        public ArrayType type() {
            return (ArrayType)this.type;
        }

        @Override
        public void add(Binding binding, Object value) throws AccessorException {
            try {
                WireClient.this.server.addAll(this.accId, -1, new MutableVariant(binding, value));
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public void addAll(Binding binding, Object[] values) throws AccessorException {
            try {
                ObjectArrayBinding ab = new ObjectArrayBinding(new ArrayType(binding.type()), binding);
                MutableVariant array = new MutableVariant(ab, values);
                WireClient.this.server.addAll(this.accId, -1, array);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public void addAll(int index, Binding binding, Object[] values) throws AccessorException {
            try {
                ObjectArrayBinding ab = new ObjectArrayBinding(new ArrayType(binding.type()), binding);
                MutableVariant array = new MutableVariant(ab, values);
                WireClient.this.server.addAll(this.accId, index, array);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public void add(int index, Binding binding, Object value) throws AccessorException {
            try {
                WireClient.this.server.addAll(this.accId, index, new MutableVariant(binding, value));
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public void set(int index, Binding binding, Object value) throws AccessorException {
            this.applyEvent(new ValueAssigned(new IndexReference(index), binding, value));
        }

        @Override
        public void remove(int index, int count) throws AccessorException {
            this.applyEvent(new ArrayElementRemoved(index));
        }

        @Override
        public <T extends Accessor> T getAccessor(int index) throws AccessorConstructionException {
            return this.getComponent(new IndexReference(index));
        }

        @Override
        public Object get(int index, Binding valueBinding) throws AccessorException {
            try {
                MutableVariant v = WireClient.this.server.getArrayElement(this.accId, index);
                return v.getValue(valueBinding);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public void get(int index, Binding valueBinding, Object dst) throws AccessorException {
            try {
                MutableVariant v = WireClient.this.server.getArrayElement(this.accId, index);
                valueBinding.readFrom(v.getBinding(), v.getValue(), v);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
            catch (BindingException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public void getAll(Binding valueBinding, Object[] array) throws AccessorException {
            ObjectArrayBinding arrayBinding = new ObjectArrayBinding(this.type(), valueBinding);
            Object[] a2 = (Object[])this.getValue(arrayBinding);
            System.arraycopy(a2, 0, array, 0, a2.length);
        }

        @Override
        public void getAll(Binding valueBinding, Collection<Object> values) throws AccessorException {
            ArrayListBinding arrayBinding = new ArrayListBinding(this.type(), valueBinding);
            ArrayList a2 = (ArrayList)this.getValue(arrayBinding);
            values.addAll(a2);
        }

        @Override
        public void setSize(int newSize) throws AccessorException {
            throw new AccessorException("Not implemented");
        }

        @Override
        public int size() throws AccessorException {
            try {
                return WireClient.this.server.size(this.accId);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
        }
    }

    class WireBoolean
    extends WireAccessor
    implements BooleanAccessor {
        WireBoolean(int accId, Datatype type, ChildReference ref) {
            super(accId, type, ref);
        }

        @Override
        public BooleanType type() {
            return (BooleanType)this.type;
        }

        @Override
        public boolean getValue() throws AccessorException {
            try {
                MutableVariant value = WireClient.this.server.getValue(this.accId);
                return (Boolean)value.getValue(Bindings.BOOLEAN);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public void setValue(boolean value) throws AccessorException {
            ValueAssigned e = new ValueAssigned(null, Bindings.BOOLEAN, value);
            Event[] list = new Event[]{e};
            IWireServer.ApplyResult result = WireClient.this.server.apply(this.accId, list, false);
            if (result.error != null) {
                throw new AccessorException(result.error);
            }
        }
    }

    class WireByte
    extends WireAccessor
    implements ByteAccessor {
        WireByte(int accId, Datatype type, ChildReference ref) {
            super(accId, type, ref);
        }

        @Override
        public ByteType type() {
            return (ByteType)this.type;
        }

        @Override
        public byte getValue() throws AccessorException {
            try {
                MutableVariant value = WireClient.this.server.getValue(this.accId);
                return (Byte)value.getValue(Bindings.BYTE);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public void setValue(byte value) throws AccessorException {
            ValueAssigned e = new ValueAssigned(null, Bindings.BYTE, value);
            Event[] list = new Event[]{e};
            IWireServer.ApplyResult result = WireClient.this.server.apply(this.accId, list, false);
            if (result.error != null) {
                throw new AccessorException(result.error);
            }
        }
    }

    class WireDouble
    extends WireAccessor
    implements DoubleAccessor {
        WireDouble(int accId, Datatype type, ChildReference ref) {
            super(accId, type, ref);
        }

        @Override
        public DoubleType type() {
            return (DoubleType)this.type;
        }

        @Override
        public double getValue() throws AccessorException {
            try {
                MutableVariant value = WireClient.this.server.getValue(this.accId);
                return (Double)value.getValue(Bindings.DOUBLE);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public void setValue(double value) throws AccessorException {
            ValueAssigned e = new ValueAssigned(Bindings.DOUBLE, value);
            Event[] list = new Event[]{e};
            IWireServer.ApplyResult result = WireClient.this.server.apply(this.accId, list, false);
            if (result.error != null) {
                throw new AccessorException(result.error);
            }
        }
    }

    class WireFloat
    extends WireAccessor
    implements FloatAccessor {
        WireFloat(int accId, Datatype type, ChildReference ref) {
            super(accId, type, ref);
        }

        @Override
        public FloatType type() {
            return (FloatType)this.type;
        }

        @Override
        public float getValue() throws AccessorException {
            try {
                MutableVariant value = WireClient.this.server.getValue(this.accId);
                return ((Float)value.getValue(Bindings.FLOAT)).floatValue();
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public void setValue(float value) throws AccessorException {
            ValueAssigned e = new ValueAssigned(Bindings.FLOAT, Float.valueOf(value));
            Event[] list = new Event[]{e};
            IWireServer.ApplyResult result = WireClient.this.server.apply(this.accId, list, false);
            if (result.error != null) {
                throw new AccessorException(result.error);
            }
        }
    }

    class WireInteger
    extends WireAccessor
    implements IntegerAccessor {
        WireInteger(int accId, Datatype type, ChildReference ref) {
            super(accId, type, ref);
        }

        @Override
        public IntegerType type() {
            return (IntegerType)this.type;
        }

        @Override
        public int getValue() throws AccessorException {
            try {
                MutableVariant value = WireClient.this.server.getValue(this.accId);
                return (Integer)value.getValue(Bindings.INTEGER);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public void setValue(int value) throws AccessorException {
            ValueAssigned e = new ValueAssigned(Bindings.INTEGER, value);
            Event[] list = new Event[]{e};
            IWireServer.ApplyResult result = WireClient.this.server.apply(this.accId, list, false);
            if (result.error != null) {
                throw new AccessorException(result.error);
            }
        }
    }

    class WireLong
    extends WireAccessor
    implements LongAccessor {
        WireLong(int accId, Datatype type, ChildReference ref) {
            super(accId, type, ref);
        }

        @Override
        public LongType type() {
            return (LongType)this.type;
        }

        @Override
        public long getValue() throws AccessorException {
            try {
                MutableVariant value = WireClient.this.server.getValue(this.accId);
                return (Long)value.getValue(Bindings.LONG);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public void setValue(long value) throws AccessorException {
            ValueAssigned e = new ValueAssigned(Bindings.LONG, value);
            Event[] list = new Event[]{e};
            IWireServer.ApplyResult result = WireClient.this.server.apply(this.accId, list, false);
            if (result.error != null) {
                throw new AccessorException(result.error);
            }
        }
    }

    class WireMap
    extends WireAccessor
    implements MapAccessor {
        WireMap(int accId, Datatype type, ChildReference ref) {
            super(accId, type, ref);
        }

        @Override
        public MapType type() {
            return (MapType)this.type;
        }

        @Override
        public int size() throws AccessorException {
            try {
                return WireClient.this.server.size(this.accId);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public Object get(Binding keyBinding, Object key, Binding valueBinding) throws AccessorException {
            try {
                MutableVariant value = WireClient.this.server.getMapValue(this.accId, new MutableVariant(keyBinding, key));
                return value.getValue(valueBinding);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public boolean containsKey(Binding keyBinding, Object key) throws AccessorException {
            try {
                return WireClient.this.server.containsKey(this.accId, new MutableVariant(keyBinding, key));
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public boolean containsValue(Binding valueBinding, Object value) throws AccessorException {
            try {
                return WireClient.this.server.containsValue(this.accId, new MutableVariant(valueBinding, value));
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public void put(Binding keyBinding, Object key, Binding valueBinding, Object value) throws AccessorException {
            this.applyEvent(new MapEntryAdded(new MutableVariant(keyBinding, key), new MutableVariant(valueBinding, value)));
        }

        @Override
        public void remove(Binding keyBinding, Object key) throws AccessorException {
            this.applyEvent(new MapEntryRemoved(new MutableVariant(keyBinding, key)));
        }

        @Override
        public void clear() throws AccessorException {
            try {
                WireClient.this.server.clear(this.accId);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public void putAll(Binding keyBinding, Binding valueBinding, Map<Object, Object> from) throws AccessorException {
            int count = from.size();
            Event[] events = new Event[count];
            int i = 0;
            for (Map.Entry<Object, Object> e : from.entrySet()) {
                MutableVariant key = new MutableVariant(keyBinding, e.getKey());
                MutableVariant value = new MutableVariant(valueBinding, e.getValue());
                events[i] = new MapEntryAdded(key, value);
            }
            this.applyEvent(events);
        }

        @Override
        public void putAll(Binding keyBinding, Binding valueBinding, Object[] keys, Object[] values) throws AccessorException {
            if (keys.length != values.length) {
                throw new AccessorException("bad args");
            }
            int count = keys.length;
            Event[] events = new Event[count];
            int i = 0;
            while (i < count) {
                events[i] = new MapEntryAdded(new MutableVariant(keyBinding, keys[i]), new MutableVariant(valueBinding, values[i]));
                ++i;
            }
            this.applyEvent(events);
        }

        @Override
        public void getAll(Binding keyBinding, Binding valueBinding, Map<Object, Object> to) throws AccessorException {
            TreeMapBinding binding = new TreeMapBinding(keyBinding, valueBinding);
            TreeMap v = (TreeMap)this.getValue(binding);
            to.putAll(v);
        }

        @Override
        public void getAll(Binding keyBinding, Binding valueBinding, Object[] keys, Object[] values) throws AccessorException {
            TreeMapBinding binding = new TreeMapBinding(keyBinding, valueBinding);
            TreeMap v = (TreeMap)this.getValue(binding);
            int i = 0;
            for (Map.Entry e : v.entrySet()) {
                keys[i] = e.getKey();
                values[i] = e.getValue();
            }
        }

        @Override
        public Object[] getKeys(Binding keyBinding) throws AccessorException {
            try {
                MutableVariant array = WireClient.this.server.getMapKeys(this.accId);
                ObjectArrayBinding binding = new ObjectArrayBinding(keyBinding);
                return (Object[])array.getValue(binding);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public int count(Binding keyBinding, Object from, boolean fromInclusive, Object end, boolean endInclusive) throws AccessorException {
            throw new AccessorException("Not implemented");
        }

        @Override
        public int getEntries(Binding keyBinding, Object from, boolean fromInclusive, Object end, boolean endInclusive, ArrayBinding keyArrayBinding, Object dstKeys, ArrayBinding valueArrayBinding, Object dstValues, int limit) throws AccessorException {
            throw new AccessorException("Not implemented");
        }

        @Override
        public Object[] getValues(Binding valueBinding) throws AccessorException {
            try {
                MutableVariant array = WireClient.this.server.getMapValues(this.accId);
                ObjectArrayBinding binding = new ObjectArrayBinding(valueBinding);
                return (Object[])array.getValue(binding);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public <T extends Accessor> T getValueAccessor(Binding keyBinding, Object key) throws AccessorConstructionException {
            return this.getComponent(new KeyReference(keyBinding, key));
        }

        @Override
        public Object getFirstKey(Binding keyBinding) throws AccessorException {
            try {
                MutableVariant result = WireClient.this.server.getFirstKey(this.accId);
                return result.getValue(keyBinding);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public Object getLastKey(Binding keyBinding) throws AccessorException {
            try {
                MutableVariant result = WireClient.this.server.getLastKey(this.accId);
                return result.getValue(keyBinding);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public Object getLowerKey(Binding keyBinding, Object key) throws AccessorException {
            try {
                MutableVariant result = WireClient.this.server.getLowerKey(this.accId, new MutableVariant(keyBinding, key));
                return result.getValue(keyBinding);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public Object getFloorKey(Binding keyBinding, Object key) throws AccessorException {
            try {
                MutableVariant result = WireClient.this.server.getFloorKey(this.accId, new MutableVariant(keyBinding, key));
                return result.getValue(keyBinding);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public Object getCeilingKey(Binding keyBinding, Object key) throws AccessorException {
            try {
                MutableVariant result = WireClient.this.server.getCeilingKey(this.accId, new MutableVariant(keyBinding, key));
                return result.getValue(keyBinding);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public Object getHigherKey(Binding keyBinding, Object key) throws AccessorException {
            try {
                MutableVariant result = WireClient.this.server.getHigherKey(this.accId, new MutableVariant(keyBinding, key));
                return result.getValue(keyBinding);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }
    }

    class WireOptional
    extends WireAccessor
    implements OptionalAccessor {
        WireOptional(int accId, Datatype type, ChildReference ref) {
            super(accId, type, ref);
        }

        @Override
        public OptionalType type() {
            return (OptionalType)this.type;
        }

        @Override
        public void setNoValue() throws AccessorException {
            this.applyEvent(new OptionalValueRemoved());
        }

        @Override
        public boolean hasValue() throws AccessorException {
            try {
                return WireClient.this.server.hasValue(this.accId);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public Object getComponentValue(Binding componentBinding) throws AccessorException {
            Object object;
            WireAccessor sa = WireClient.this.createAccessor(new ComponentReference());
            try {
                object = sa.getValue(componentBinding);
            }
            catch (Throwable throwable) {
                try {
                    sa.close();
                    throw throwable;
                }
                catch (WireException e) {
                    throw new AccessorException(e);
                }
            }
            sa.close();
            return object;
        }

        @Override
        public void setComponentValue(Binding binding, Object value) throws AccessorException {
            this.applyEvent(new OptionalValueAssigned(binding, value));
        }

        @Override
        public <T extends Accessor> T getComponentAccessor() throws AccessorConstructionException {
            return this.getComponent(new ComponentReference());
        }
    }

    class WireRecord
    extends WireAccessor
    implements RecordAccessor {
        WireRecord(int accId, Datatype type, ChildReference ref) {
            super(accId, type, ref);
        }

        @Override
        public RecordType type() {
            return (RecordType)this.type;
        }

        @Override
        public int count() throws AccessorException {
            try {
                return WireClient.this.server.size(this.accId);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public <T extends Accessor> T getFieldAccessor(int index) throws AccessorConstructionException {
            return this.getComponent(new IndexReference(index));
        }

        @Override
        public <T extends Accessor> T getFieldAccessor(String fieldName) throws AccessorConstructionException {
            return this.getComponent(new NameReference(fieldName));
        }

        @Override
        public Object getFieldValue(String fieldName, Binding fieldBinding) throws AccessorException {
            int fieldIndex = this.type().getComponentIndex(fieldName);
            if (fieldIndex < 0) {
                throw new AccessorException("Field " + fieldName + " does not exist");
            }
            return this.getFieldValue(fieldIndex, fieldBinding);
        }

        @Override
        public Object getFieldValue(int index, Binding fieldBinding) throws AccessorException {
            Object object;
            WireAccessor sa = WireClient.this.createAccessor(new IndexReference(index));
            try {
                object = sa.getValue(fieldBinding);
            }
            catch (Throwable throwable) {
                try {
                    sa.close();
                    throw throwable;
                }
                catch (WireException e) {
                    throw new AccessorException(e);
                }
            }
            sa.close();
            return object;
        }

        @Override
        public void setFieldValue(String fieldName, Binding fieldBinding, Object value) throws AccessorException {
            int fieldIndex = this.type().getComponentIndex(fieldName);
            if (fieldIndex < 0) {
                throw new AccessorException("Field " + fieldName + " does not exist");
            }
            this.setFieldValue(fieldIndex, fieldBinding, value);
        }

        @Override
        public void setFieldValue(int index, Binding fieldBinding, Object value) throws AccessorException {
            try {
                WireAccessor sa = WireClient.this.createAccessor(new IndexReference(index));
                try {
                    sa.setValue(fieldBinding, value);
                }
                finally {
                    sa.close();
                }
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
        }
    }

    class WireString
    extends WireAccessor
    implements StringAccessor {
        WireString(int accId, Datatype type, ChildReference ref) {
            super(accId, type, ref);
        }

        @Override
        public StringType type() {
            return (StringType)this.type;
        }

        @Override
        public String getValue() throws AccessorException {
            try {
                MutableVariant value = WireClient.this.server.getValue(this.accId);
                return (String)value.getValue(Bindings.STRING);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
            catch (AdaptException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public void setValue(String newValue) throws AccessorException {
            ValueAssigned e = new ValueAssigned(Bindings.STRING, newValue);
            Event[] list = new Event[]{e};
            IWireServer.ApplyResult result = WireClient.this.server.apply(this.accId, list, false);
            if (result.error != null) {
                throw new AccessorException(result.error);
            }
        }
    }

    class WireUnion
    extends WireAccessor
    implements UnionAccessor {
        WireUnion(int accId, Datatype type, ChildReference ref) {
            super(accId, type, ref);
        }

        @Override
        public UnionType type() {
            return (UnionType)this.type;
        }

        @Override
        public int count() throws AccessorException {
            try {
                return WireClient.this.server.size(this.accId);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public int getTag() throws AccessorException {
            try {
                return WireClient.this.server.getTag(this.accId);
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public <T extends Accessor> T getComponentAccessor() throws AccessorConstructionException {
            return this.getComponent(new ComponentReference());
        }

        @Override
        public Object getComponentValue(Binding componentBinding) throws AccessorException {
            Object object;
            WireAccessor sa = WireClient.this.createAccessor(new ComponentReference());
            try {
                object = sa.getValue(componentBinding);
            }
            catch (Throwable throwable) {
                try {
                    sa.close();
                    throw throwable;
                }
                catch (WireException e) {
                    throw new AccessorException(e);
                }
            }
            sa.close();
            return object;
        }

        @Override
        public void setComponentValue(int tag, Binding componentBinding, Object componentValue) throws AccessorException {
            try {
                WireAccessor sa = WireClient.this.createAccessor(new ComponentReference());
                try {
                    sa.setValue(componentBinding, componentValue);
                }
                finally {
                    sa.close();
                }
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
        }
    }

    class WireVariant
    extends WireAccessor
    implements VariantAccessor {
        WireVariant(int accId, Datatype type, ChildReference ref) {
            super(accId, type, ref);
        }

        @Override
        public VariantType type() {
            return (VariantType)this.type;
        }

        @Override
        public <T extends Accessor> T getContentAccessor() throws AccessorConstructionException {
            return this.getComponent(new ComponentReference());
        }

        @Override
        public void setContentValue(Binding valueBinding, Object value) throws AccessorException {
            try {
                WireAccessor sa = WireClient.this.createAccessor(new ComponentReference());
                try {
                    sa.setValue(valueBinding, value);
                }
                finally {
                    sa.close();
                }
            }
            catch (WireException e) {
                throw new AccessorException(e);
            }
        }

        @Override
        public Object getContentValue(Binding contentBinding) throws AccessorException {
            Object object;
            WireAccessor sa = WireClient.this.createAccessor(new ComponentReference());
            try {
                object = sa.getValue(contentBinding);
            }
            catch (Throwable throwable) {
                try {
                    sa.close();
                    throw throwable;
                }
                catch (WireException e) {
                    throw new AccessorException(e);
                }
            }
            sa.close();
            return object;
        }

        @Override
        public Datatype getContentType() throws AccessorException {
            Datatype datatype;
            WireAccessor sa = WireClient.this.createAccessor(new ComponentReference());
            try {
                datatype = sa.type();
            }
            catch (Throwable throwable) {
                try {
                    sa.close();
                    throw throwable;
                }
                catch (WireException e) {
                    throw new AccessorException(e);
                }
            }
            sa.close();
            return datatype;
        }
    }
}

