/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.binary;

import java.io.IOException;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.ByteAccessor;
import org.simantics.databoard.accessor.binary.BinaryObject;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.ValueAssigned;
import org.simantics.databoard.accessor.file.FileByteAccessor;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.impl.ListenerEntry;
import org.simantics.databoard.accessor.interestset.ByteInterestSet;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.util.binary.Blob;

public class BinaryByte
extends BinaryObject
implements ByteAccessor,
FileByteAccessor {
    public BinaryByte(BinaryObject parent, Blob blob, ByteType type, AccessorParams params) throws AccessorConstructionException {
        super(parent, blob, type, params);
        try {
            blob.setLength(1L);
        }
        catch (IOException e) {
            throw new AccessorConstructionException(e);
        }
    }

    @Override
    public ByteType type() {
        return (ByteType)this.type;
    }

    @Override
    public byte getValue() throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            this.b.position(0L);
            byte by = this.b.readByte();
            return by;
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    Event applyLocal(Event e, boolean makeRollback) throws AccessorException {
        ValueAssigned rollback;
        ValueAssigned valueAssigned = rollback = makeRollback ? new ValueAssigned(Bindings.BYTE, this.getValue()) : null;
        if (e instanceof ValueAssigned) {
            ValueAssigned va = (ValueAssigned)e;
            if (va.newValue == null) {
                throw new AccessorException("Byte value expected, got null");
            }
            this.setValueNoflush(va.newValue.getBinding(), va.newValue.getValue());
            return rollback;
        }
        throw new AccessorException("Cannot apply " + e.getClass().getName() + " to Byte");
    }

    @Override
    public <T extends Accessor> T getComponent(ChildReference reference) throws AccessorConstructionException {
        if (reference == null) {
            return (T)this;
        }
        throw new ReferenceException(reference.getClass() + " is not a subreference of ByteType");
    }

    @Override
    public Object getValue(Binding binding) throws AccessorException {
        try {
            ByteBinding bb = (ByteBinding)binding;
            byte v = this.getValue();
            return bb.create(v);
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public void setValueNoflush(byte newValue) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.b.position(0L);
                this.b.write(newValue);
                ListenerEntry le = this.listeners;
                while (le != null) {
                    ByteInterestSet is = (ByteInterestSet)le.getInterestSet();
                    if (is.inNotifications()) {
                        ValueAssigned e = new ValueAssigned(Bindings.BYTE, is.inValues() ? Byte.valueOf(newValue) : null);
                        this.emitEvent(le, e);
                    }
                    le = le.next;
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setValue(byte newValue) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.setValueNoflush(newValue);
                this.b.flush();
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setValueNoflush(Binding binding, Object newValue) throws AccessorException {
        try {
            byte nv = ((ByteBinding)binding).getValue_(newValue);
            this.setValueNoflush(nv);
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
    }
}

