/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.route.internal;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.district.route.Route;
import org.simantics.district.route.Waypoint;
import org.simantics.district.route.internal.RoutePersistence;
import org.simantics.district.route.internal.RouteServiceImpl;
import org.simantics.district.route.internal.WaypointImpl;
import org.simantics.utils.threads.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteImpl
implements Route {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteImpl.class);
    private String name;
    private Resource model;
    private Resource backend;
    private RouteServiceImpl rs;
    private List<Waypoint> waypoints;
    private List<Waypoint> unmodifiableWaypoints;

    public RouteImpl(String name) {
        this.name = name;
        this.routeService(this.rs);
        this.waypoints(new CopyOnWriteArrayList<Waypoint>());
    }

    public RouteImpl modelEntity(Resource model) {
        this.model = model;
        return this;
    }

    public Resource modelEntity() {
        return this.model;
    }

    @Override
    public <T> T adapt(Class<T> clazz) {
        if (clazz == Resource.class) {
            return (T)this.backend;
        }
        return null;
    }

    public RouteImpl backend(Resource backend) {
        this.backend = backend;
        return this;
    }

    public Resource backend() {
        return this.backend;
    }

    public RouteImpl waypoints(List<Waypoint> waypoints) {
        this.waypoints = waypoints;
        this.unmodifiableWaypoints = Collections.unmodifiableList(waypoints);
        return this;
    }

    public RouteImpl routeService(RouteServiceImpl rs) {
        this.rs = rs;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.fireEvent(7);
    }

    @Override
    public boolean persisted() {
        return this.backend != null;
    }

    @Override
    public Waypoint createWaypoint(Object backend) {
        if (backend instanceof Resource) {
            Resource waypoint = (Resource)backend;
            WaypointImpl wp = new WaypointImpl(waypoint, "");
            ThreadUtils.getBlockingWorkExecutor().submit(() -> {
                try {
                    Waypoint p = (Waypoint)Simantics.getSession().syncRequest(graph -> RoutePersistence.toWaypoint(graph, waypoint));
                    if (p != null) {
                        wp.setLabel(p.getLabel());
                        this.rs.fireEvent(8, this);
                    }
                }
                catch (DatabaseException e) {
                    LOGGER.error("Failed to read waypoint {} label", backend, (Object)e);
                }
            });
            return wp.owner(this);
        }
        throw new IllegalArgumentException("only Resource type waypoints supported, got " + backend);
    }

    @Override
    public void addWaypoint(int index, Waypoint r) {
        this.waypoints.add(index, r);
        this.fireEvent(8);
    }

    @Override
    public void removeWaypoint(Waypoint r) {
        int i = this.waypoints.lastIndexOf(r);
        if (i >= 0) {
            this.waypoints.remove(i);
            this.fireEvent(8);
        }
    }

    @Override
    public List<Waypoint> waypoints() {
        return this.unmodifiableWaypoints;
    }

    public String toString() {
        return String.format("%s@%x [%s, waypoints=%s]", this.getClass().getName(), System.identityHashCode(this), this.name, this.waypoints.toString());
    }

    private void fireEvent(int type) {
        if (this.rs != null) {
            this.rs.fireEvent(type, this);
        }
    }

    public int hashCode() {
        return Objects.hash(this.backend, this.model);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RouteImpl other = (RouteImpl)obj;
        return Objects.equals(this.backend, other.backend) && Objects.equals(this.model, other.model);
    }
}

