/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.route.ui.handlers;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.district.network.ui.DistrictNetworkUIUtil;
import org.simantics.district.route.Route;
import org.simantics.district.route.RouteJob;
import org.simantics.district.route.RouterConfiguration;
import org.simantics.district.route.Waypoint;
import org.simantics.utils.ui.ISelectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectRouteOnDiagram {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectRouteOnDiagram.class);

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ISelection selection) {
        return ISelectionUtils.filterSingleSelection((Object)selection, Route.class) != null || ISelectionUtils.filterSingleSelection((Object)selection, Waypoint.class) != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell activeShell, @Named(value="e4ActivePart") MPart part, @Named(value="org.eclipse.ui.selection") ISelection selection) {
        SelectRouteOnDiagram.select(activeShell, selection);
    }

    public static void select(Shell activeShell, ISelection selection) {
        Resource dnElement;
        Route route = (Route)ISelectionUtils.filterSingleSelection((Object)selection, Route.class);
        Waypoint wp = (Waypoint)ISelectionUtils.filterSingleSelection((Object)selection, Waypoint.class);
        if (route == null && wp == null) {
            return;
        }
        Display display = activeShell.getDisplay();
        CompletableFuture<List<Resource>> result = new CompletableFuture<List<Resource>>();
        ((CompletableFuture)result.exceptionally(e -> Collections.emptyList())).thenAccept(dnElements -> {
            if (!dnElements.isEmpty()) {
                try {
                    DistrictNetworkUIUtil.openDNDiagramWithSelection((Display)display, (List)dnElements);
                }
                catch (DatabaseException databaseException) {
                    LOGGER.error("Failed to open district network diagram with selection {}", dnElements);
                }
            }
        });
        if (route != null) {
            RouterConfiguration config = new RouterConfiguration();
            new RouteJob(config, route, result).schedule();
        } else if (wp != null && (dnElement = (Resource)wp.adapt(Resource.class)) != null) {
            result.complete(Collections.singletonList(dnElement));
        }
    }
}

