/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.simantics.NameLabelMode;
import org.simantics.NameLabelUtil;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.datatypes.literal.RGB;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleChild;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.BindingException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.indexing.IndexUtils;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.db.layer0.request.PossibleActiveModel;
import org.simantics.db.layer0.request.PossibleVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.layer.GraphLayer;
import org.simantics.diagram.synchronization.graph.layer.IGraphLayerUtil;
import org.simantics.district.network.CRS;
import org.simantics.district.network.DNEdgeBuilder;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.layer0.Layer0;
import org.simantics.maps.elevation.server.SingletonTiffTileInterface;
import org.simantics.maps.elevation.server.prefs.MapsElevationServerPreferences;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.adapters.NewCompositeActionFactory;
import org.simantics.operation.Layer0X;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistrictNetworkUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistrictNetworkUtil.class);
    private static final double[] EMPTY = new double[0];

    public static Resource createEdge(WriteGraph graph, Resource composite, double[] detailedGeometryCoords) throws DatabaseException {
        return DistrictNetworkUtil.createEdge(graph, composite, graph.getPossibleObject(composite, DistrictNetworkResource.getInstance((ReadGraph)graph).EdgeDefaultMapping), detailedGeometryCoords);
    }

    public static Resource createEdge(WriteGraph graph, Resource diagramResource, Resource mapping, double[] detailedGeometryCoords) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        if (mapping == null) {
            mapping = graph.getSingleObject(diagramResource, DN.EdgeDefaultMapping);
        }
        Resource edge = graph.newResource();
        graph.claim(edge, L0.InstanceOf, DN.Edge);
        graph.claim(edge, DN.HasMapping, null, mapping);
        OrderedSetUtils.addFirst((WriteGraph)graph, (Resource)diagramResource, (Resource)edge);
        graph.claim(diagramResource, L0.ConsistsOf, L0.PartOf, edge);
        DistrictNetworkUtil.claimFreshElementName(graph, diagramResource, edge);
        for (Resource layer : graph.getObjects(diagramResource, DiagramResource.getInstance((ReadGraph)graph).HasLayer)) {
            IGraphLayerUtil layerUtil = (IGraphLayerUtil)graph.adapt(graph.getSingleObject(layer, Layer0.getInstance((ReadGraph)graph).InstanceOf), IGraphLayerUtil.class);
            GraphLayer gl = layerUtil.loadLayer((ReadGraph)graph, layer);
            gl.forEachTag(tag -> DiagramGraphUtil.tag((WriteGraph)graph, (Resource)edge, (Resource)tag, (boolean)true));
        }
        graph.claimLiteral(edge, DN.Edge_HasGeometry, (Object)detailedGeometryCoords, (Binding)Bindings.DOUBLE_ARRAY);
        Object pipeCode = graph.getRelatedValue(diagramResource, DN.Diagram_DefaultPipeTechTypeId);
        if (pipeCode != null) {
            graph.claimLiteral(edge, DN.Edge_HasPipeCode, pipeCode, (Binding)Bindings.STRING);
        }
        return edge;
    }

    public static Resource createVertex(WriteGraph graph, Resource composite, double[] coords, double elevation) throws DatabaseException {
        Resource defaultVertexMapping = graph.getPossibleObject(composite, DistrictNetworkResource.getInstance((ReadGraph)graph).VertexDefaultMapping);
        return DistrictNetworkUtil.createVertex(graph, composite, coords, elevation, defaultVertexMapping);
    }

    public static Resource createVertex(WriteGraph graph, Resource composite, double[] coords, double elevation, Resource mapping) throws DatabaseException {
        if (elevation == Double.MAX_VALUE) {
            elevation = DistrictNetworkUtil.elevationFromServer(coords);
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource vertex = graph.newResource();
        graph.claim(vertex, L0.InstanceOf, DN.Vertex);
        graph.claimLiteral(vertex, DIA.HasLocation, (Object)coords);
        graph.claimLiteral(vertex, DN.Vertex_HasElevation, (Object)elevation, (Binding)Bindings.DOUBLE);
        graph.claim(vertex, DN.HasMapping, null, mapping);
        OrderedSetUtils.add((WriteGraph)graph, (Resource)composite, (Resource)vertex);
        graph.claim(composite, L0.ConsistsOf, L0.PartOf, vertex);
        DistrictNetworkUtil.claimFreshElementName(graph, composite, vertex);
        for (Resource layer : graph.getObjects(composite, DiagramResource.getInstance((ReadGraph)graph).HasLayer)) {
            IGraphLayerUtil layerUtil = (IGraphLayerUtil)graph.adapt(graph.getSingleObject(layer, Layer0.getInstance((ReadGraph)graph).InstanceOf), IGraphLayerUtil.class);
            GraphLayer gl = layerUtil.loadLayer((ReadGraph)graph, layer);
            gl.forEachTag(tag -> DiagramGraphUtil.tag((WriteGraph)graph, (Resource)vertex, (Resource)tag, (boolean)true));
        }
        return vertex;
    }

    public static double elevationFromServer(double[] coords) {
        double elevation = 0.0;
        if (MapsElevationServerPreferences.useElevationServer()) {
            try {
                elevation = SingletonTiffTileInterface.lookup((double)coords[1], (double)coords[0]).doubleValue();
            }
            catch (Exception ee) {
                LOGGER.error("Could not get elevation from tiff interface", (Throwable)ee);
            }
        }
        return elevation;
    }

    public static Resource joinVertices(WriteGraph graph, Collection<Resource> vertices) throws DatabaseException {
        if (vertices.isEmpty()) {
            throw new IllegalArgumentException("vertices-collection should not be empty for joining vertices!");
        }
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Iterator<Resource> verticeIterator = vertices.iterator();
        Resource master = verticeIterator.next();
        while (verticeIterator.hasNext()) {
            Resource slave = verticeIterator.next();
            Resource composite = graph.getSingleObject(slave, Layer0.getInstance((ReadGraph)graph).PartOf);
            Collection startVertexEdges = graph.getObjects(slave, DN.HasStartVertex_Inverse);
            for (Resource startVertexEdge : startVertexEdges) {
                graph.deny(startVertexEdge, DN.HasStartVertex);
                graph.claim(startVertexEdge, DN.HasStartVertex, master);
            }
            Collection endVertexEdges = graph.getObjects(slave, DN.HasEndVertex_Inverse);
            for (Resource endVertexEdge : endVertexEdges) {
                graph.deny(endVertexEdge, DN.HasEndVertex);
                graph.claim(endVertexEdge, DN.HasEndVertex, master);
            }
            OrderedSetUtils.remove((WriteGraph)graph, (Resource)composite, (Resource)slave);
            graph.deny(composite, Layer0.getInstance((ReadGraph)graph).ConsistsOf, slave);
        }
        return master;
    }

    public static double calculateDistance(ReadGraph graph, Resource startVertex, Resource endVertex) throws DatabaseException {
        Resource endComposite;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource startComposite = graph.getSingleObject(startVertex, L0.PartOf);
        if (!startComposite.equalsResource(endComposite = graph.getSingleObject(endVertex, L0.PartOf))) {
            throw new DatabaseException("Can not calculate distance between vertices on different composites! " + startVertex + " -> " + endVertex);
        }
        Resource crs = graph.getSingleObject(startComposite, DistrictNetworkResource.getInstance((ReadGraph)graph).HasSpatialRefSystem);
        CRS crsClass = (CRS)graph.adapt(crs, CRS.class);
        double[] startCoords = (double[])graph.getRelatedValue2(startVertex, DiagramResource.getInstance((ReadGraph)graph).HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
        double[] endCoords = (double[])graph.getRelatedValue2(endVertex, DiagramResource.getInstance((ReadGraph)graph).HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
        return crsClass.calculateDistance(startCoords, endCoords);
    }

    public static double calculateDetailedDistance(ReadGraph graph, Resource edge, Resource startVertex, Resource endVertex) throws DatabaseException {
        Resource endComposite;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Resource startComposite = graph.getSingleObject(startVertex, L0.PartOf);
        if (!startComposite.equalsResource(endComposite = graph.getSingleObject(endVertex, L0.PartOf))) {
            throw new DatabaseException("Can not calculate distance between vertices on different composites! " + startVertex + " -> " + endVertex);
        }
        Resource crs = graph.getSingleObject(startComposite, DN.HasSpatialRefSystem);
        CRS crsClass = (CRS)graph.adapt(crs, CRS.class);
        double[] geometry = EMPTY;
        try {
            geometry = (double[])graph.getPossibleRelatedValue2(edge, DN.Edge_HasGeometry, (Binding)Bindings.DOUBLE_ARRAY);
        }
        catch (Exception exception) {}
        if (geometry != EMPTY && geometry.length > 0) {
            double[] startCoords = (double[])graph.getRelatedValue2(startVertex, DiagramResource.getInstance((ReadGraph)graph).HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
            double totalLength = 0.0;
            int i = 0;
            while (i < geometry.length) {
                double detailedGeometryX = geometry[i];
                double detailedGeometryY = geometry[i + 1];
                double[] endCoords = new double[]{detailedGeometryX, detailedGeometryY};
                double length = crsClass.calculateDistance(startCoords, endCoords);
                totalLength += length;
                startCoords[0] = detailedGeometryX;
                startCoords[1] = detailedGeometryY;
                i += 2;
            }
            double[] endCoords = (double[])graph.getRelatedValue2(endVertex, DiagramResource.getInstance((ReadGraph)graph).HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
            double length = crsClass.calculateDistance(startCoords, endCoords);
            return totalLength += length;
        }
        return DistrictNetworkUtil.calculateDistance(graph, startVertex, endVertex);
    }

    public static final String claimFreshElementName(WriteGraph graph, Resource diagram, Resource element) throws DatabaseException {
        Long l;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        String namePrefix = (String)graph.getPossibleRelatedValue2(diagram, Layer0X.getInstance((ReadGraph)graph).HasGeneratedNamePrefix);
        if (namePrefix == null) {
            namePrefix = "";
        }
        if ((l = (Long)graph.getPossibleRelatedValue(diagram, DIA.HasModCount, (Binding)Bindings.LONG)) == null) {
            l = 0L;
        }
        String name = String.valueOf(namePrefix) + l.toString();
        graph.claimLiteral(element, L0.HasName, (Object)name, (Binding)Bindings.STRING);
        l = l + 1L;
        graph.claimLiteral(diagram, DIA.HasModCount, (Object)l, (Binding)Bindings.LONG);
        return name;
    }

    public static Resource getDiagramElement(ReadGraph graph, Resource component) throws DatabaseException {
        if (component == null) {
            return null;
        }
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(component, DIA.Element)) {
            return component;
        }
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource element = graph.getPossibleObject(component, MOD.ComponentToElement);
        return element != null && graph.isInstanceOf(element, DIA.Element) ? element : null;
    }

    public static Resource getMappedElement(ReadGraph graph, Resource element) throws DatabaseException {
        if (element == null) {
            return null;
        }
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        return graph.getPossibleObject(element, DN.MappedComponent);
    }

    public static Resource getMappedComponent(ReadGraph graph, Resource element) throws DatabaseException {
        if (element == null) {
            return null;
        }
        Resource mappedElement = DistrictNetworkUtil.getMappedElement(graph, element);
        if (mappedElement == null) {
            return null;
        }
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        return graph.getPossibleObject(mappedElement, MOD.ElementToComponent);
    }

    public static Resource getMappedComponentCached(ReadGraph graph, Resource vertex) throws DatabaseException {
        return (Resource)graph.syncRequest((Read)new MappedComponentRequest(vertex), (Listener)TransientCacheListener.instance());
    }

    public static Resource getMappedDNElement(ReadGraph graph, Resource element) throws DatabaseException {
        if (element == null) {
            return null;
        }
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        return graph.getPossibleObject(element, DN.MappedFromElement);
    }

    public static Variable toMappedConfigurationModule(ReadGraph graph, Resource input) throws DatabaseException {
        if (input == null) {
            return null;
        }
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(input, DN.Element)) {
            Resource mappedElement = DistrictNetworkUtil.getMappedElement(graph, input);
            if (mappedElement == null) {
                return null;
            }
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            Resource mappedComponent = graph.getPossibleObject(mappedElement, MOD.ElementToComponent);
            if (mappedComponent == null) {
                return null;
            }
            return (Variable)graph.syncRequest((Read)new PossibleVariable(mappedComponent));
        }
        return null;
    }

    public static void toggleDrawMap(WriteGraph graph, Resource diagram) throws ManyObjectsForFunctionalRelationException, BindingException, ServiceException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Boolean current = (Boolean)graph.getPossibleRelatedValue(diagram, DN.Diagram_drawMapEnabled, (Binding)Bindings.BOOLEAN);
        if (current == null) {
            current = true;
        }
        graph.claimLiteral(diagram, DN.Diagram_drawMapEnabled, (Object)(current == false ? 1 : 0), (Binding)Bindings.BOOLEAN);
    }

    public static Boolean drawMapEnabled(ReadGraph graph, Resource diagram) throws ManyObjectsForFunctionalRelationException, BindingException, ServiceException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Boolean current = (Boolean)graph.getPossibleRelatedValue(diagram, DN.Diagram_drawMapEnabled, (Binding)Bindings.BOOLEAN);
        return current != null ? current : true;
    }

    public static void changeMapBackgroundColor(WriteGraph graph, Resource diagram, RGB.Integer integer) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        graph.claimLiteral(diagram, DN.Diagram_backgroundColor, (Object)integer, Bindings.getBindingUnchecked(RGB.Integer.class));
    }

    public static Boolean trackChangesEnabled(ReadGraph graph, Resource diagram) throws DatabaseException {
        if (diagram != null && graph.hasStatement(diagram)) {
            return Boolean.TRUE.equals(graph.getPossibleRelatedValue(diagram, DistrictNetworkResource.getInstance((ReadGraph)graph).Diagram_trackChangesEnabled));
        }
        return false;
    }

    public static RGB.Integer backgroundColor(ReadGraph graph, Resource diagram) throws DatabaseException {
        return (RGB.Integer)graph.getPossibleRelatedValue(diagram, DistrictNetworkResource.getInstance((ReadGraph)graph).Diagram_backgroundColor, Bindings.getBindingUnchecked(RGB.Integer.class));
    }

    public static Resource createNetworkDiagram(WriteGraph graph, Resource target, Resource compositeType, String defaultName, Resource defaultEdgeMapping, Resource defaultVertexMapping, Resource rightClickVertexMapping, Resource leftClickVertexMapping, Resource crs) throws DatabaseException {
        Resource composite = NewCompositeActionFactory.createComposite((WriteGraph)graph, (Resource)target, (String)defaultName, (Resource)compositeType);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Resource diagram = graph.getSingleObject(composite, ModelingResources.getInstance((ReadGraph)graph).CompositeToDiagram);
        graph.claim(diagram, DN.EdgeDefaultMapping, defaultEdgeMapping);
        graph.claim(diagram, DN.VertexDefaultMapping, defaultVertexMapping);
        graph.claim(diagram, DN.RightClickDefaultMapping, rightClickVertexMapping);
        graph.claim(diagram, DN.LeftClickDefaultMapping, leftClickVertexMapping);
        graph.claim(diagram, DN.HasSpatialRefSystem, crs);
        String compositeName = (String)graph.getRelatedValue2(composite, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING);
        graph.claimLiteral(diagram, Layer0X.getInstance((ReadGraph)graph).HasGeneratedNamePrefix, (Object)("N" + compositeName.substring(compositeName.length() - 1, compositeName.length())));
        return composite;
    }

    public static void changeMappingType(WriteGraph graph, Resource newMapping, List<Resource> elements) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        for (Resource element : elements) {
            graph.deny(element, DN.HasMapping);
            graph.claim(element, DN.HasMapping, newMapping);
        }
    }

    public static Stream<Resource> findDNElementsById(ReadGraph graph, Resource context, String idToFind) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        return IndexUtils.findByType((ReadGraph)graph, (Resource)((Resource)graph.syncRequest((Read)new IndexRoot(context))), (Resource)DN.Element).stream().filter(element -> {
            try {
                String id = (String)graph.getPossibleRelatedValue(element, districtNetworkResource.HasId, (Binding)Bindings.STRING);
                return id != null && id.contains(idToFind);
            }
            catch (DatabaseException e) {
                LOGGER.error("Could not read id for element {]", element, (Object)e);
                return false;
            }
        });
    }

    public static Resource findDNElementById(ReadGraph graph, Resource context, String idToFind) throws DatabaseException {
        List elements = DistrictNetworkUtil.findDNElementsById(graph, context, idToFind).collect(Collectors.toList());
        if (elements.size() == 1) {
            return (Resource)elements.iterator().next();
        }
        return null;
    }

    public static List<Resource> findDNElementByXYCoordinates(ReadGraph graph, Resource context, double lat, double lon, double padding) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ArrayList<Resource> results = new ArrayList<Resource>();
        Collection vertices = IndexUtils.findByType((ReadGraph)graph, (Resource)((Resource)graph.syncRequest((Read)new IndexRoot(context))), (Resource)DN.Vertex);
        Rectangle2D.Double rect = new Rectangle2D.Double(lat, lon, padding, padding);
        for (Resource vertex : vertices) {
            double[] location = (double[])graph.getRelatedValue(vertex, DIA.HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
            if (!rect.contains(location[0], location[1])) continue;
            results.add(vertex);
        }
        return results;
    }

    public static List<ResourceVertex> nearbyResourceVertices(ReadGraph graph, Resource diagramResource, Resource vertex, Double padding) throws DatabaseException {
        List result;
        double halfPadding = padding / 2.0;
        Quadtree existingVertices = (Quadtree)graph.syncRequest((Read)new ExistingVerticesRead(diagramResource, halfPadding), (Listener)TransientCacheListener.instance());
        double[] coords = (double[])graph.getRelatedValue(vertex, DiagramResource.getInstance((ReadGraph)graph).HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
        double x1 = coords[0] - halfPadding;
        double y1 = coords[1] - halfPadding;
        double x2 = coords[0] + halfPadding;
        double y2 = coords[1] + halfPadding;
        Envelope e = new Envelope(x1, x2, y1, y2);
        List vertices = result = existingVertices.query(e);
        Rectangle2D.Double vertexRectangle = new Rectangle2D.Double(coords[0] - halfPadding, coords[1] - halfPadding, padding, padding);
        List<ResourceVertex> sortedVertices = vertices.stream().filter(rv -> {
            if (rv.vertex.equals(vertex)) {
                return false;
            }
            Rectangle2D.Double nearbyRectangle = new Rectangle2D.Double(rv.coords[0] - halfPadding, rv.coords[1] - halfPadding, padding, padding);
            return vertexRectangle.intersects(nearbyRectangle);
        }).sorted((o1, o2) -> {
            double disto1 = Math.sqrt(Math.pow(coords[0] - o1.coords[0], 2.0) + Math.pow(coords[1] - o1.coords[1], 2.0));
            double disto2 = Math.sqrt(Math.pow(coords[0] - o2.coords[0], 2.0) + Math.pow(coords[1] - o2.coords[1], 2.0));
            if (o1.vertex.getResourceId() == 2554883L) {
                System.err.println("here we are");
            }
            return Double.compare(disto1, disto2);
        }).collect(Collectors.toList());
        return sortedVertices;
    }

    public static List<Resource> nearbyVertices(ReadGraph graph, Resource vertex, double padding) throws DatabaseException {
        Resource diagramResource = graph.getSingleObject(vertex, Layer0.getInstance((ReadGraph)graph).PartOf);
        return DistrictNetworkUtil.nearbyResourceVertices(graph, diagramResource, vertex, padding).stream().map(rv -> rv.vertex).collect(Collectors.toList());
    }

    public static Quadtree existingVertices(Resource diagramResource, Double padding) throws DatabaseException {
        Quadtree vv = (Quadtree)Simantics.getSession().syncRequest((Read)new ExistingVerticesRead(diagramResource, padding));
        return vv;
    }

    public static List<NamedResource> getDistrictComponents() throws DatabaseException {
        return DistrictNetworkUtil.getDistrictComponents((RequestProcessor)Simantics.getSession());
    }

    public static List<NamedResource> getDistrictComponents(RequestProcessor session) throws DatabaseException {
        Resource model = (Resource)session.syncRequest((Read)new PossibleActiveModel(Simantics.getProjectResource()));
        if (model == null) {
            return Collections.emptyList();
        }
        return DistrictNetworkUtil.getDistrictComponents(session, model);
    }

    public static List<NamedResource> getDistrictComponents(RequestProcessor session, Resource model) throws DatabaseException {
        return (List)session.syncRequest((Read)new DistrictComponentListRequest(model), (Listener)TransientCacheListener.instance());
    }

    public static ResourceEdge splitPipe(WriteGraph graph, Resource edge, Point2D initialPoint) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        double[] midVertexCoords = new double[]{initialPoint.getX(), initialPoint.getY()};
        double[] detailedLeftEdgeGeometryCoords = new double[]{};
        double[] detailedRightEdgeGeometryCoords = new double[]{};
        double[] detailedGeom = (double[])graph.getPossibleRelatedValue(edge, DN.Edge_HasGeometry, (Binding)Bindings.DOUBLE_ARRAY);
        if (detailedGeom != null) {
            double closestDistance = Double.MAX_VALUE;
            Point2D.Double closestPoint = null;
            int j = 0;
            int i = 0;
            while (i < detailedGeom.length) {
                double x = detailedGeom[i];
                double y = detailedGeom[i + 1];
                Point2D.Double currentPoint = new Point2D.Double(x, y);
                double currentDistance = initialPoint.distance(currentPoint);
                if (currentDistance < closestDistance) {
                    closestDistance = currentDistance;
                    closestPoint = currentPoint;
                    j = i;
                }
                i += 2;
            }
            Point2D.Double finalClosestPoint = closestPoint;
            if (finalClosestPoint != null) {
                double y;
                detailedLeftEdgeGeometryCoords = new double[j];
                int k = 0;
                while (k < j) {
                    double x = detailedGeom[k];
                    y = detailedGeom[k + 1];
                    detailedLeftEdgeGeometryCoords[k] = x;
                    detailedLeftEdgeGeometryCoords[k + 1] = y;
                    k += 2;
                }
                detailedRightEdgeGeometryCoords = new double[detailedGeom.length - j - 2];
                int i2 = 0;
                int k2 = j + 2;
                while (k2 < detailedGeom.length) {
                    double x = detailedGeom[k2];
                    double y2 = detailedGeom[k2 + 1];
                    detailedRightEdgeGeometryCoords[i2++] = x;
                    detailedRightEdgeGeometryCoords[i2++] = y2;
                    k2 += 2;
                }
                double x = ((Point2D)finalClosestPoint).getX();
                y = ((Point2D)finalClosestPoint).getY();
                midVertexCoords = new double[]{x, y};
            }
        }
        Resource diagram = graph.getSingleObject(edge, Layer0.getInstance((ReadGraph)graph).PartOf);
        Resource mapping = graph.getSingleObject(diagram, DistrictNetworkResource.getInstance((ReadGraph)graph).VertexDefaultMapping);
        Resource createdVertex = DistrictNetworkUtil.createVertex(graph, diagram, midVertexCoords, Double.MAX_VALUE, mapping);
        return DistrictNetworkUtil.splitPipeAndConnect(graph, edge, createdVertex, detailedLeftEdgeGeometryCoords, detailedRightEdgeGeometryCoords);
    }

    public static double pointDistanceFromEdge(double x, double y, double x1, double y1, double x2, double y2) {
        double yy;
        double xx;
        double A = x - x1;
        double B = y - y1;
        double C = x2 - x1;
        double D = y2 - y1;
        double dot = A * C + B * D;
        double len_sq = C * C + D * D;
        double param = -1.0;
        if (len_sq != 0.0) {
            param = dot / len_sq;
        }
        if (param < 0.0) {
            xx = x1;
            yy = y1;
        } else if (param > 1.0) {
            xx = x2;
            yy = y2;
        } else {
            xx = x1 + param * C;
            yy = y1 + param * D;
        }
        double dx = x - xx;
        double dy = y - yy;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static ResourceEdge splitPipeAndConnect(WriteGraph graph, Resource edge, Resource vertex, double[] detailedLeftEdgeGeometryCoords, double[] detailedRightEdgeGeometryCoords) throws DatabaseException {
        String pipeId;
        ResourceVertex endVertex;
        ResourceVertex startVertex;
        double[] startCoords;
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource currentEndVertex = graph.getSingleObject(edge, DN.HasEndVertex);
        if (currentEndVertex.equals(vertex)) {
            currentEndVertex = graph.getSingleObject(edge, DN.HasStartVertex);
            graph.deny(edge, DN.HasStartVertex);
            graph.claim(edge, DN.HasStartVertex, vertex);
            graph.deny(edge, DN.Edge_HasGeometry);
            graph.claimLiteral(edge, DN.Edge_HasGeometry, (Object)detailedLeftEdgeGeometryCoords, (Binding)Bindings.DOUBLE_ARRAY);
            startCoords = (double[])graph.getRelatedValue(vertex, DIA.HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
            startVertex = new ResourceVertex(vertex, startCoords, false);
            double[] endCoords = (double[])graph.getRelatedValue(currentEndVertex, DIA.HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
            endVertex = new ResourceVertex(currentEndVertex, endCoords, false);
        } else {
            graph.deny(edge, DN.HasEndVertex);
            graph.claim(edge, DN.HasEndVertex, vertex);
            graph.deny(edge, DN.Edge_HasGeometry);
            graph.claimLiteral(edge, DN.Edge_HasGeometry, (Object)detailedLeftEdgeGeometryCoords, (Binding)Bindings.DOUBLE_ARRAY);
            startCoords = (double[])graph.getRelatedValue(currentEndVertex, DIA.HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
            startVertex = new ResourceVertex(currentEndVertex, startCoords, false);
            double[] endCoords = (double[])graph.getRelatedValue(vertex, DIA.HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
            endVertex = new ResourceVertex(vertex, endCoords, false);
        }
        double length = DistrictNetworkUtil.calculateDetailedDistance((ReadGraph)graph, edge, startVertex.vertex, endVertex.vertex);
        graph.deny(edge, DN.Edge_HasLength);
        graph.claimLiteral(edge, DN.Edge_HasLength, (Object)length, (Binding)Bindings.DOUBLE);
        Resource diagram = graph.getSingleObject(edge, Layer0.getInstance((ReadGraph)graph).PartOf);
        Resource rightEdge = DistrictNetworkUtil.createEdge(graph, diagram, null, detailedRightEdgeGeometryCoords);
        graph.claimLiteral(rightEdge, DN.Edge_HasElevation, (Object)DNEdgeBuilder.calculateElevationFromVertices(graph, vertex, currentEndVertex), (Binding)Bindings.DOUBLE);
        graph.claim(rightEdge, DN.HasStartVertex, vertex);
        graph.claim(rightEdge, DN.HasEndVertex, currentEndVertex);
        String pipeCode = (String)graph.getPossibleRelatedValue2(edge, DN.Edge_HasPipeCode, (Binding)Bindings.STRING);
        if (pipeCode != null && !pipeCode.isEmpty()) {
            graph.claimLiteral(rightEdge, DN.Edge_HasPipeCode, (Object)pipeCode, (Binding)Bindings.STRING);
        }
        if ((pipeId = (String)graph.getPossibleRelatedValue2(edge, DN.HasId, (Binding)Bindings.STRING)) != null && !pipeId.isEmpty()) {
            graph.claimLiteral(rightEdge, DN.HasId, (Object)pipeId, (Binding)Bindings.STRING);
        }
        double rightLength = DistrictNetworkUtil.calculateDetailedDistance((ReadGraph)graph, rightEdge, vertex, currentEndVertex);
        graph.deny(rightEdge, DN.Edge_HasLength);
        graph.claimLiteral(rightEdge, DN.Edge_HasLength, (Object)rightLength, (Binding)Bindings.DOUBLE);
        return new ResourceEdge(rightEdge, startVertex, endVertex);
    }

    public static class DistrictComponentListRequest
    extends ResourceRead<List<NamedResource>> {
        protected DistrictComponentListRequest(Resource model) {
            super(model);
        }

        public List<NamedResource> perform(ReadGraph graph) throws DatabaseException {
            DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
            Resource model = this.resource;
            HashSet<Resource> componentTypes = new HashSet<Resource>();
            List mappings = QueryIndexUtils.searchByType((ReadGraph)graph, (Resource)model, (Resource)DN.Mapping_Base);
            for (Resource r : mappings) {
                Resource type;
                Resource root;
                String componentType = (String)graph.getPossibleRelatedValue2(r, DN.Mapping_ComponentType);
                if (componentType == null || (root = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(r))) == null || (type = (Resource)graph.syncRequest((Read)new PossibleChild(root, componentType))) == null) continue;
                componentTypes.add(type);
            }
            ArrayList<NamedResource> result = new ArrayList<NamedResource>(componentTypes.size());
            for (Resource r : componentTypes) {
                String name = NameLabelUtil.modalName((ReadGraph)graph, (Resource)r, (NameLabelMode)NameLabelMode.NAME);
                result.add(new NamedResource(name, r));
            }
            result.sort(Comparator.comparing(NamedResource::getName));
            return result;
        }
    }

    public static class ExistingVerticesRead
    extends BinaryRead<Resource, Double, Quadtree> {
        public ExistingVerticesRead(Resource diagramResource, Double padding) {
            super((Object)diagramResource, (Object)padding);
        }

        public Quadtree perform(ReadGraph graph) throws DatabaseException {
            Collection vertices = (Collection)graph.syncRequest((Read)new ObjectsWithType((Resource)this.parameter, Layer0.getInstance((ReadGraph)graph).ConsistsOf, DistrictNetworkResource.getInstance((ReadGraph)graph).Vertex));
            Quadtree vv = new Quadtree();
            for (Resource vertex : vertices) {
                double[] coords = (double[])graph.getRelatedValue2(vertex, DiagramResource.getInstance((ReadGraph)graph).HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
                double x1 = coords[0] - (Double)this.parameter2;
                double y1 = coords[1] - (Double)this.parameter2;
                double x2 = coords[0] + (Double)this.parameter2;
                double y2 = coords[1] + (Double)this.parameter2;
                Envelope e = new Envelope(x1, x2, y1, y2);
                vv.insert(e, (Object)new ResourceVertex(vertex, coords, true));
            }
            return vv;
        }
    }

    public static final class MappedComponentRequest
    extends ResourceRead<Resource> {
        public MappedComponentRequest(Resource element) {
            super(element);
        }

        public Resource perform(ReadGraph graph) throws DatabaseException {
            return DistrictNetworkUtil.getMappedComponent(graph, this.resource);
        }
    }

    public static class ResourceEdge {
        public final Resource edge;
        public final ResourceVertex startVertex;
        public final ResourceVertex endVertex;

        public ResourceEdge(Resource edge, ResourceVertex startVertex, ResourceVertex endVertex) {
            this.edge = edge;
            this.startVertex = startVertex;
            this.endVertex = endVertex;
        }

        public int hashCode() {
            return Objects.hash(this.edge, this.endVertex, this.startVertex);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResourceEdge other = (ResourceEdge)obj;
            return Objects.equals(this.edge, other.edge) && Objects.equals(this.endVertex, other.endVertex) && Objects.equals(this.startVertex, other.startVertex);
        }
    }

    public static class ResourceVertex {
        public final boolean isConsumer;
        public final Resource vertex;
        public final double[] coords;

        public ResourceVertex(Resource vertex, double[] coords, boolean isConsumer) {
            this.vertex = vertex;
            this.coords = coords;
            this.isConsumer = isConsumer;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.coords);
            result = 31 * result + Objects.hash(this.isConsumer, this.vertex);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResourceVertex other = (ResourceVertex)obj;
            return Arrays.equals(this.coords, other.coords) && this.isConsumer == other.isConsumer && Objects.equals(this.vertex, other.vertex);
        }
    }
}

