/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.techtype.table;

import java.util.Set;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.district.network.techtype.TechTypeValidationUtils;
import org.simantics.district.network.ui.techtype.table.TechTypeTable;
import org.simantics.district.network.ui.techtype.table.TechTypeTableView;
import org.simantics.utils.ui.ExceptionUtils;

public class ValidateTechTypeTableHandler {
    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MPart part) {
        if (part.getObject() instanceof TechTypeTableView) {
            TechTypeTableView view = (TechTypeTableView)part.getObject();
            TechTypeTable t = view.getTable();
            return t != null && t.getTable() != null && t.getComponentType() != null;
        }
        return false;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell s, @Named(value="e4ActivePart") MPart part) {
        if (!(part.getObject() instanceof TechTypeTableView)) {
            return;
        }
        TechTypeTableView view = (TechTypeTableView)part.getObject();
        TechTypeTable table = view.getTable();
        Resource tableResource = table.getTable();
        if (tableResource == null) {
            return;
        }
        try {
            Set result = TechTypeValidationUtils.validateTechTypeTable((Resource)tableResource);
            table.setValidationResult(result);
            MessageDialog.openInformation((Shell)s, (String)"Validation result", (String)(result.isEmpty() ? "No invalid values found" : NLS.bind((String)"{0} invalid values found", (Object)result.size())));
        }
        catch (DatabaseException e) {
            ExceptionUtils.logAndShowError((String)"Tech type table validation failed", (Throwable)e);
        }
    }
}

