/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.techtype.adapters;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.ui.techtype.table.TechTypeTableView;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TechTypeEditorAdapter
extends AbstractResourceEditorAdapter
implements EditorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TechTypeEditorAdapter.class);

    public TechTypeEditorAdapter() throws MalformedURLException, IOException {
        super("Tech Type Table View");
        this.setIcon(ImageDescriptor.createFromURL((URL)FileLocator.resolve((URL)new URL("platform:/plugin/com.famfamfam.silk/icons/table.png"))));
    }

    public boolean canHandle(ReadGraph graph, Object input) throws DatabaseException {
        Resource r = ResourceAdaptionUtils.toSingleResource((Object)input);
        if (r == null) {
            return false;
        }
        return graph.isInstanceOf(r, DistrictNetworkResource.getInstance((ReadGraph)graph).TechType_TechTypeTable);
    }

    public void openEditor(Resource table) throws Exception {
        TechTypeTableView.openTechTypeTable(table);
    }
}

