/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.techtype;

import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.PlatformUI;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.exception.CannotRemoveException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.techtype.requests.TechTypeTableData;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.adapters.ExistingInstancesRemover;
import org.simantics.modeling.adapters.RemoveInstancesDialog;
import org.simantics.utils.strings.AlphanumComparator;

public class TechTypeTableRemover
extends ExistingInstancesRemover {
    public TechTypeTableRemover(Resource resource) {
        super(resource, "Tech Type Table");
    }

    public void remove(WriteGraph graph) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Resource componentType = graph.getPossibleObject(this.resource, DN.TechType_TechTypeTable_HasComponentType);
        if (componentType == null) {
            this.justRemove(graph);
            return;
        }
        this.remove(graph, this.resource, componentType, componentType);
    }

    protected void remove(WriteGraph graph, Resource resource, Resource typeResource, Resource typeNameResource) throws DatabaseException {
        if (Layer0Utils.isContainerPublished((ReadGraph)graph, (Resource)resource)) {
            throw new CannotRemoveException("Items in published libraries cannot be removed. Please create a new version to perform modifications.");
        }
        Resource root = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(resource));
        if (root == null) {
            this.justRemove(graph);
            return;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String componentTypeName = (String)graph.getPossibleRelatedValue(typeNameResource, L0.HasName, (Binding)Bindings.STRING);
        if (componentTypeName == null) {
            this.justRemove(graph);
            return;
        }
        Set<Resource> instances = this.discoverInstances((ReadGraph)graph, typeResource, root);
        if (!instances.isEmpty()) {
            this.confirmRemoval(graph, instances, this.typeDescription, componentTypeName);
        } else {
            this.justRemove(graph);
        }
    }

    protected Set<Resource> discoverInstances(ReadGraph graph, Resource componentType, Resource startRoot) throws DatabaseException {
        Resource keyPredicate = (Resource)graph.syncRequest((Read)new PossibleTechTypeKeyPredicate(componentType), (Listener)TransientCacheListener.instance());
        if (keyPredicate == null) {
            return Collections.emptySet();
        }
        Map data = (Map)graph.syncRequest((Read)new TechTypeTableData(this.resource), (Listener)TransientCacheListener.instance());
        HashSet<Resource> used = new HashSet<Resource>();
        for (Resource comp : this.discoverAllInstances(graph, componentType, startRoot)) {
            Object code = graph.getPossibleRelatedValue(comp, keyPredicate);
            if (code == null || !(code instanceof String) || !data.containsKey(code)) continue;
            used.add(comp);
        }
        return used;
    }

    private Set<Resource> discoverAllInstances(ReadGraph graph, Resource componentType, Resource startRoot) throws DatabaseException {
        THashSet result = new THashSet();
        Instances searcher = (Instances)graph.adapt(componentType, Instances.class);
        this.discoverInstancesRec(graph, componentType, startRoot, searcher, (Set<Resource>)result);
        return result;
    }

    private void discoverInstancesRec(ReadGraph graph, Resource typeResource, Resource indexRoot, Instances instances, Set<Resource> result) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection rs = instances.find(graph, indexRoot);
        result.addAll(rs);
        for (Resource linkee : graph.getObjects(indexRoot, L0.IsLinkedTo_Inverse)) {
            this.discoverInstancesRec(graph, typeResource, linkee, instances, result);
        }
    }

    protected void confirmRemoval(WriteGraph graph, final Set<Resource> instances, final String typeDescription, final String typeName) throws DatabaseException {
        Map instanceAddresses = this.resolveInstanceAddresses((ReadGraph)graph, instances);
        final RemoveInstancesDialog.Content[] content = new RemoveInstancesDialog.Content[instanceAddresses.size()];
        int i = 0;
        for (Map.Entry entry : instanceAddresses.entrySet()) {
            content[i] = new RemoveInstancesDialog.Content((String)entry.getValue());
            ++i;
        }
        Arrays.sort(content, new Comparator<RemoveInstancesDialog.Content>(){

            @Override
            public int compare(RemoveInstancesDialog.Content o1, RemoveInstancesDialog.Content o2) {
                return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)o1.label, (Object)o2.label);
            }
        });
        final Session session = graph.getSession();
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    boolean doIt;
                    RemoveInstancesDialog dialog = new RemoveInstancesDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Remove " + typeDescription + "?", String.valueOf(typeDescription) + " for '" + typeName + "' is still in use in " + instances.size() + " instances. Are you sure you want to remove it?", content);
                    int result = dialog.open();
                    boolean bl = doIt = result == 0;
                    if (!doIt) {
                        return;
                    }
                    session.asyncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            TechTypeTableRemover.this.justRemove(graph);
                        }
                    });
                }
            });
        } else {
            this.justRemove(graph);
        }
    }

    private static class PossibleTechTypeKeyPredicate
    extends ResourceRead<Resource> {
        public PossibleTechTypeKeyPredicate(Resource componentType) {
            super(componentType);
        }

        public Resource perform(ReadGraph graph) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
            for (Resource r : graph.getObjects(this.resource, L0.DomainOf)) {
                Resource accessor = graph.getPossibleObject(r, L0.valueAccessor);
                if (!accessor.equals(DN.TechType_Functions_techTypeCodeValueAccessor)) continue;
                return r;
            }
            return null;
        }
    }
}

