/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.table;

import java.util.Set;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.ui.action.IKeyAction;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.simantics.district.network.ui.table.CustomPasteDataCommand;
import org.simantics.district.network.ui.table.DistrictCSVTable;

public class CustomPasteDataAction
implements IKeyAction {
    private DistrictCSVTable table;

    public CustomPasteDataAction(DistrictCSVTable table) {
        this.table = table;
    }

    public void run(NatTable natTable, KeyEvent event) {
        Object data = this.table.cpb.getContents((Transfer)TextTransfer.getInstance());
        if (data instanceof String) {
            String textData = (String)data;
            String[][] fullData = CustomPasteDataAction.computeData(textData);
            int[] cols = this.table.selectionLayer.getSelectedColumnPositions();
            int firstCol = cols[0];
            int column = this.table.selectionLayer.getColumnIndexByPosition(firstCol);
            Set ranges = this.table.selectionLayer.getSelectedRowPositions();
            if (!ranges.isEmpty()) {
                int rowPosition = ((Range)ranges.iterator().next()).start;
                int[] columns = new int[fullData.length];
                columns[0] = column;
                int i = 1;
                while (i < fullData.length) {
                    columns[i] = this.table.selectionLayer.getColumnIndexByPosition(firstCol + i);
                    ++i;
                }
                this.table.bodyDataLayer.doCommand((ILayerCommand)new CustomPasteDataCommand((ILayer)this.table.bodyDataLayer, columns, rowPosition, fullData));
            }
        }
    }

    private static String[][] computeData(String textData) {
        String separator = textData.contains(",") && !textData.contains(";") ? "," : (textData.contains(";") && !textData.contains("\t") ? ";" : "\\t");
        textData = textData.replaceAll("\\r", "");
        String[] rows = textData.split("\\n");
        String[][] cells = new String[rows.length][];
        int i = 0;
        while (i < rows.length) {
            cells[i] = rows[i].split(separator, -1);
            ++i;
        }
        String[][] fullData = cells;
        return fullData;
    }

    private static String[][] transpose(String[][] cells) {
        int rowCount = 0;
        String[][] stringArray = cells;
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            String[] cols = stringArray[n2];
            rowCount = Math.max(rowCount, cols.length);
            ++n2;
        }
        String[][] result = new String[rowCount][cells.length];
        int i = 0;
        while (i < cells.length) {
            String[] cols = cells[i];
            int j = 0;
            while (j < cols.length) {
                result[j][i] = cols[j];
                ++j;
            }
            while (j < rowCount) {
                result[j][i] = "";
                ++j;
            }
            ++i;
        }
        return result;
    }
}

