/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.styles;

import java.awt.geom.Point2D;
import java.util.List;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.ui.nodes.DistrictNetworkEdgeNode;
import org.simantics.district.network.ui.nodes.DistrictNetworkNodeUtils;
import org.simantics.district.network.ui.nodes.DistrictNetworkVertexNode;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.INode;
import org.simantics.scl.compiler.top.ValueNotFound;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.tuple.Tuple3;
import org.simantics.structural.stubs.StructuralResource2;

public class DistrictNetworkHoverInfoStyle {
    private static final String ACTIONS_MODULE = "Actions";
    private static final String HOVER_CONTRIBUTION = "hoverContribution";

    public static List<Tuple3> calculateGridTexts(ReadGraph graph, Resource runtimeDiagram, Resource mapElement) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        String variableURI = (String)graph.getPossibleRelatedValue(runtimeDiagram, DIA.RuntimeDiagram_HasVariable, (Binding)Bindings.STRING);
        Variable activeVariable = Variables.getPossibleVariable((ReadGraph)graph, (String)variableURI);
        if (activeVariable == null) {
            return null;
        }
        Resource module = DistrictNetworkUtil.getMappedComponentCached((ReadGraph)graph, (Resource)mapElement);
        if (module == null) {
            return null;
        }
        Resource moduleType = graph.getPossibleType(module, STR.Component);
        if (moduleType == null) {
            return null;
        }
        Function1<Variable, List<Tuple3>> function = DistrictNetworkHoverInfoStyle.getUCTextGridFunctionCached(graph, moduleType);
        if (function == null) {
            return null;
        }
        Variable variable = Variables.getVariable((ReadGraph)graph, (Resource)module);
        Variable moduleVariable = Variables.possibleActiveVariable((ReadGraph)graph, (Variable)variable);
        if (moduleVariable == null) {
            moduleVariable = variable;
        }
        return (List)Simantics.applySCLRead((ReadGraph)graph, function, (Object)moduleVariable);
    }

    public static Point2D calculateOrigin(ReadGraph graph, Resource mapElement) throws DatabaseException {
        Point2D point;
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(mapElement, DN.Vertex)) {
            double[] coords = (double[])graph.getRelatedValue(mapElement, DIA.HasLocation);
            point = DistrictNetworkNodeUtils.calculatePoint2D(new Point2D.Double(coords[0], coords[1]), null);
        } else if (graph.isInstanceOf(mapElement, DN.Edge)) {
            Resource v1 = graph.getSingleObject(mapElement, DN.HasStartVertex);
            double[] coords1 = (double[])graph.getRelatedValue(v1, DIA.HasLocation);
            Resource v2 = graph.getSingleObject(mapElement, DN.HasEndVertex);
            double[] coords2 = (double[])graph.getRelatedValue(v2, DIA.HasLocation);
            point = DistrictNetworkNodeUtils.calculatePoint2D(new Point2D.Double((coords1[0] + coords2[0]) / 2.0, (coords1[1] + coords2[1]) / 2.0), null);
        } else {
            return null;
        }
        return point;
    }

    public static Point2D calculatePoint(INode node, int zoomLevel, Point2D result) {
        if (node instanceof DistrictNetworkVertexNode) {
            DistrictNetworkVertexNode vertex = (DistrictNetworkVertexNode)node;
            return DistrictNetworkNodeUtils.calculatePoint2D(vertex.getVertex().getPoint(), result);
        }
        if (node instanceof DistrictNetworkEdgeNode) {
            DistrictNetworkEdgeNode edge = (DistrictNetworkEdgeNode)node;
            Point2D cp = edge.getCenterPoint(zoomLevel);
            if (result == null) {
                result = new Point2D.Double();
            }
            result.setLocation(cp);
            return result;
        }
        return null;
    }

    private static Function1<Variable, List<Tuple3>> getUCTextGridFunctionCached(ReadGraph graph, Resource componentType) throws DatabaseException {
        return (Function1)graph.syncRequest((Read)new UCTextGridFunctionRequest(componentType), (Listener)TransientCacheListener.instance());
    }

    private static final class UCTextGridFunctionRequest
    extends ResourceRead<Function1<Variable, List<Tuple3>>> {
        public UCTextGridFunctionRequest(Resource resource) {
            super(resource);
        }

        public Function1<Variable, List<Tuple3>> perform(ReadGraph graph) throws DatabaseException {
            Resource actionsModule = CommonDBUtils.getPossibleChild((ReadGraph)graph, (Resource)this.resource, (String)DistrictNetworkHoverInfoStyle.ACTIONS_MODULE);
            if (actionsModule == null || !graph.isInstanceOf(actionsModule, Layer0.getInstance((ReadGraph)graph).SCLModule)) {
                return null;
            }
            String uri = graph.getURI(actionsModule);
            SCLContext sclContext = SCLContext.getCurrent();
            Object oldGraph = sclContext.get((Object)"graph");
            try {
                sclContext.put((Object)"graph", (Object)graph);
                Function1 function1 = (Function1)SCLOsgi.MODULE_REPOSITORY.getValue(uri, DistrictNetworkHoverInfoStyle.HOVER_CONTRIBUTION);
                return function1;
            }
            catch (ValueNotFound valueNotFound) {
                return null;
            }
            finally {
                sclContext.put((Object)"graph", oldGraph);
            }
        }
    }
}

