/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.participants;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.district.network.ui.adapters.DistrictNetworkVertexElement;
import org.simantics.district.network.ui.internal.Activator;
import org.simantics.district.network.ui.nodes.RouteHighlightNode;
import org.simantics.district.network.ui.participants.DNPickSorter;
import org.simantics.district.network.ui.participants.Modes;
import org.simantics.district.route.Route;
import org.simantics.district.route.RouteService;
import org.simantics.district.route.RouteServiceListener;
import org.simantics.district.route.Waypoint;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.IMouseCursorContext;
import org.simantics.g2d.canvas.IMouseCursorHandle;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickContext;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.pointertool.AbstractMode;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.participant.TimeParticipant;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.utils.GeometryUtils;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.command.Command;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.utils.ui.SWTUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingMode
extends AbstractMode {
    private static final String DEFAULT_NEW_ROUTE_NAME = "Route";
    private static final Logger LOGGER = LoggerFactory.getLogger(RoutingMode.class);
    @DependencyReflection.Dependency
    protected TransformUtil util;
    @DependencyReflection.Dependency
    protected PickContext pickContext;
    @DependencyReflection.Dependency
    protected Selection selection;
    @DependencyReflection.Dependency
    protected TimeParticipant time;
    protected IMouseCursorHandle cursor;
    private RouteService routeService;
    private Route route;
    protected G2DParentNode parent;
    protected SingleElementNode node = null;
    private RouteHighlightNode highlight = null;
    private RouteServiceListener routeServiceListener;
    private PickRequest.PickFilter pickFilter = new PickRequest.PickFilter(){

        public boolean accept(IElement e) {
            return RoutingMode.this.filterAcceptableElement(e);
        }
    };
    private PickRequest.PickSorter pickSorter = new DNPickSorter();
    private List<IElement> pickedElements = new ArrayList<IElement>();

    public RoutingMode(int mouseId) {
        super(mouseId);
    }

    public Route definedRoute() {
        return this.route;
    }

    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        IMouseCursorContext mcc = this.getContext().getMouseCursorContext();
        this.cursor = mcc == null ? null : mcc.setCursor(this.mouseId, new Cursor(1));
        this.routeService = Activator.getInstance().getRouteService();
        if (this.routeService != null) {
            this.routeServiceListener = e -> {
                switch (e.type) {
                    case 6: 
                    case 10: {
                        this.asyncExec(this::dispose);
                    }
                }
            };
            this.routeService.addListener(this.routeServiceListener);
            Resource diagramResource = (Resource)this.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
            LOGGER.debug("Starting routing mode for diagram resource: {}", (Object)diagramResource);
            this.route = this.routeService.createRoute(this.uniqueRouteName(DEFAULT_NEW_ROUTE_NAME), (Object)diagramResource);
            this.routeService.registerRoute(this.route);
            this.highlight.init(this.getContext(), this.selection, this.routeService);
            this.highlight.setHighlightedRoute(this.route);
        }
        if (this.time != null) {
            this.time.registerForEvents(((Object)((Object)this)).getClass());
        }
    }

    public void removedFromContext(ICanvasContext ctx) {
        if (this.time != null) {
            this.time.unregisterForEvents(((Object)((Object)this)).getClass());
        }
        if (this.cursor != null) {
            this.cursor.remove();
            this.cursor = null;
        }
        if (this.routeService != null) {
            this.highlight.setHighlightedRoute(null);
            this.routeService.removeListener(this.routeServiceListener);
            if (this.route != null && !this.route.persisted()) {
                this.routeService.discardRoute(this.route);
                this.route = null;
            }
        }
        super.removedFromContext(ctx);
    }

    private void addWaypoint(IElement element) {
        if (this.route == null) {
            return;
        }
        Object o = ElementUtils.getObject((IElement)element);
        if (o instanceof Resource && this.filterAcceptableElement(element)) {
            Waypoint wp = this.route.createWaypoint(o);
            this.route.addWaypoint(wp);
        }
    }

    private void removeLastWaypoint() {
        List wps;
        if (this.route != null && (wps = this.route.waypoints()).size() > 0) {
            this.route.removeWaypoint((Waypoint)wps.get(wps.size() - 1));
        }
    }

    private boolean filterAcceptableElement(IElement element) {
        ElementClass elementClass = element.getElementClass();
        return elementClass.getId().equals(DistrictNetworkVertexElement.CLASS.getId());
    }

    @SGNodeReflection.SGInit
    public void initSG(G2DParentNode parent) {
        this.parent = parent;
        this.node = (SingleElementNode)parent.addNode("route highlight", SingleElementNode.class);
        this.node.setZIndex(2000);
        this.node.setVisible(Boolean.TRUE);
        this.node.setComposite((Composite)AlphaComposite.SrcOver.derive(0.75f));
        this.highlight = (RouteHighlightNode)((Object)this.node.addNode("1", RouteHighlightNode.class));
    }

    protected void onDiagramSet(IDiagram newDiagram, IDiagram oldDiagram) {
        this.highlight.setDiagram(newDiagram);
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
        if (this.node != null) {
            this.node.remove();
            this.node = null;
        }
        this.parent = null;
    }

    private List<IElement> pick(Point2D controlPos) {
        AffineTransform inverse = this.util.getInverseTransform();
        if (inverse == null) {
            return Collections.emptyList();
        }
        double pd = 4.0;
        Rectangle2D.Double controlPickRect = new Rectangle2D.Double(controlPos.getX() - pd, controlPos.getY() - pd, pd * 2.0 + 1.0, pd * 2.0 + 1.0);
        Shape canvasShape = GeometryUtils.transformShape((Shape)controlPickRect, (AffineTransform)inverse);
        PickRequest req = new PickRequest(canvasShape).context(this.getContext());
        req.pickPolicy = PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS;
        req.pickFilter = this.pickFilter;
        req.pickSorter = this.pickSorter;
        this.pickedElements.clear();
        this.pickContext.pick(this.diagram, req, this.pickedElements);
        return this.pickedElements;
    }

    @EventHandlerReflection.EventHandler(priority=0x200001)
    public boolean handleEvent(MouseEvent.MouseMovedEvent e) {
        if (this.route == null) {
            return false;
        }
        if (e.buttons == 0) {
            List<IElement> elements = this.pick(e.controlPosition);
            if (elements.size() > 0) {
                this.highlight.setHighlightedElement(elements.size() > 0 ? elements.get(0) : null);
                this.setDirty();
            } else {
                this.highlight.setHighlightedElement(null);
            }
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=0x200001)
    public boolean handleEvent(MouseEvent.MouseClickEvent e) {
        if (this.route == null) {
            return false;
        }
        if (this.pickedElements.size() > 0) {
            IElement nearest = this.pickedElements.get(0);
            this.addWaypoint(nearest);
            return true;
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=30)
    public boolean handleEvent(Event e) {
        if (e instanceof KeyEvent.KeyPressedEvent) {
            if (this.route == null) {
                return false;
            }
            KeyEvent.KeyPressedEvent kpe = (KeyEvent.KeyPressedEvent)e;
            if (kpe.keyCode == 10) {
                this.commitRoute();
                return true;
            }
        } else if (e instanceof CommandEvent) {
            Command cmd = ((CommandEvent)e).command;
            if (cmd.equals((Object)Commands.DELETE)) {
                this.removeLastWaypoint();
                return true;
            }
            if (cmd.equals((Object)Commands.CANCEL)) {
                if (this.route != null && !this.route.persisted() && this.route.count() > 1) {
                    SWTUtils.asyncExec((Display)Display.getDefault(), () -> {
                        if (Display.getCurrent().isDisposed()) {
                            return;
                        }
                        if (this.askDiscardUnpersistedRoute()) {
                            this.asyncExec(() -> {
                                if (!this.isRemoved()) {
                                    this.dispose();
                                }
                            });
                        }
                    });
                    return false;
                }
                return this.dispose();
            }
            if (cmd.equals((Object)Commands.RENAME)) {
                SWTUtils.asyncExec((Display)Display.getDefault(), () -> {
                    String newName = this.askRouteName("Rename Route", this.route.getName());
                    if (newName != null) {
                        this.route.setName(newName);
                        this.routeService.refreshRoute(this.route);
                    }
                });
            } else if (cmd.equals((Object)Modes.COMMIT_ROUTE_COMMAND)) {
                this.commitRoute();
                return true;
            }
        }
        return false;
    }

    private void commitRoute() {
        Route committedRoute = this.route;
        this.route = null;
        SWTUtils.asyncExec((Display)Display.getDefault(), () -> this.askRouteNameAndPersist(committedRoute));
        this.dispose();
    }

    private String uniqueRouteName(String initialProposition) {
        TreeSet reservedNames = new TreeSet(NameUtils.STRING_CHARBUFFER_COMPARATOR);
        this.routeService.listRoutes().stream().filter(Route::persisted).map(Route::getName).forEach(reservedNames::add);
        return NameUtils.findFreshNameNumbered((String)initialProposition, reservedNames, (String)" ");
    }

    private void askRouteNameAndPersist(Route committedRoute) {
        String newName = this.askRouteName("Confirm Route", this.uniqueRouteName(committedRoute.getName()));
        if (newName != null) {
            committedRoute.setName(newName);
            this.routeService.persistRoute(committedRoute);
        } else {
            this.routeService.discardRoute(committedRoute);
        }
    }

    private boolean askDiscardUnpersistedRoute() {
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Discard route", null, "Discard current unsaved route?", 2, 0, new String[]{"OK", "Cancel"});
        return dialog.open() == 0;
    }

    private String askRouteName(String dialogTitle, String initialValue) {
        InputDialog dialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), dialogTitle, "Route name", initialValue, s -> s.trim().length() > 0 ? null : "Name must be non-empty");
        if (dialog.open() == 0) {
            return dialog.getValue();
        }
        return null;
    }

    protected boolean dispose() {
        this.setDirty();
        this.remove();
        return false;
    }

    static class RenameDialog
    extends InputDialog {
        public RenameDialog(Shell parent, String title, String message, String initialValue, IInputValidator validator) {
            super(parent, title, message, initialValue, validator);
        }

        protected IDialogSettings getDialogBoundsSettings() {
            String sectionName = String.valueOf(((Object)((Object)this)).getClass().getName()) + "_dialogBounds";
            IDialogSettings settings = Activator.getInstance().getDialogSettings();
            IDialogSettings section = settings.getSection(sectionName);
            if (section == null) {
                section = settings.addNewSection(sectionName);
            }
            return section;
        }

        protected int getDialogBoundsStrategy() {
            return 1;
        }
    }
}

