/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.participants;

import java.awt.Color;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.StructuredSelection;
import org.simantics.browsing.ui.common.AdaptableHintContext;
import org.simantics.db.Resource;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.district.network.ui.adapters.DistrictNetworkEdgeElement;
import org.simantics.district.network.ui.adapters.DistrictNetworkVertexElement;
import org.simantics.district.network.ui.nodes.DistrictNetworkEdgeNode;
import org.simantics.district.network.ui.nodes.DistrictNetworkVertexNode;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.utils.datastructures.hints.IHintContext;

public class DistrictFinderVisualisationParticipant
extends AbstractDiagramParticipant {
    private static final String TOPIC = "org/simantics/district/selection/elementQuerySelection";
    private static final String TOPIC2 = "org/simantics/district/visualisationTrigger";
    private IEventBroker broker;
    public static final IHintContext.Key COLOR_KEY = new IHintContext.KeyOf(Color.class, "COLOR");

    public DistrictFinderVisualisationParticipant(IEventBroker broker) {
        this.broker = broker;
    }

    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.broker.subscribe(TOPIC, event -> {
            StructuredSelection selection = (StructuredSelection)event.getProperty("org.eclipse.e4.data");
            for (AdaptableHintContext next : selection) {
                Resource resource = (Resource)next.getHint(SelectionHints.KEY_MAIN);
                Color colorr = (Color)next.getHint(COLOR_KEY);
                IElement element = DiagramNodeUtil.findElement((ICanvasContext)ctx, (Resource)resource);
                G2DParentNode node = (G2DParentNode)element.getHint(DistrictNetworkEdgeElement.KEY_DN_EDGE_NODE);
                if (node != null) {
                    ((DistrictNetworkEdgeNode)node).setEventColor(colorr);
                    node.repaint();
                    continue;
                }
                G2DParentNode vertexNode = (G2DParentNode)element.getHint(DistrictNetworkVertexElement.KEY_DN_VERTEX_NODE);
                ((DistrictNetworkVertexNode)vertexNode).setEventColor(colorr);
                vertexNode.repaint();
            }
        });
        this.broker.subscribe(TOPIC2, event -> {
            Tuple2 data = (Tuple2)event.getProperty("org.eclipse.e4.data");
            Resource resource = (Resource)data.c0;
            Color colorr = (Color)data.c1;
            IElement element = DiagramNodeUtil.findElement((ICanvasContext)ctx, (Resource)resource);
            G2DParentNode node = (G2DParentNode)element.getHint(DistrictNetworkEdgeElement.KEY_DN_EDGE_NODE);
            if (node != null) {
                ((DistrictNetworkEdgeNode)node).setEventColor(colorr);
                node.repaint();
            } else {
                G2DParentNode vertexNode = (G2DParentNode)element.getHint(DistrictNetworkVertexElement.KEY_DN_VERTEX_NODE);
                ((DistrictNetworkVertexNode)vertexNode).setEventColor(colorr);
                vertexNode.repaint();
            }
        });
    }

    public void removedFromContext(ICanvasContext ctx) {
        super.removedFromContext(ctx);
    }
}

