/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.nodes;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.simantics.db.Resource;
import org.simantics.district.network.ui.nodes.DistrictNetworkVertexNode;
import org.simantics.district.route.Route;
import org.simantics.district.route.RouteJob;
import org.simantics.district.route.RouteService;
import org.simantics.district.route.RouteServiceListener;
import org.simantics.district.route.RouterConfiguration;
import org.simantics.district.route.internal.RoutePersistence;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.utils.Container;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteHighlightNode
extends G2DNode {
    private static final long serialVersionUID = 5428005886752226766L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteHighlightNode.class);
    private static final long MIN_QUIET_TIME_MS = 200L;
    private static final long MIN_DELAY_BEFORE_REROUTING_MS = 1000L;
    private ICanvasContext context;
    private Selection selection;
    private RouteService routeService;
    private IDiagram diagram;
    private Point highlight = null;
    private Rectangle2D highlightShape = new Rectangle2D.Double();
    private boolean routeDirty = false;
    private boolean routePointsDirty = false;
    private Route highlightedRoute;
    private List<Point> routePoints = new ArrayList<Point>();
    private AtomicReference<CompletableFuture<List<Resource>>> currentRouteTask = new AtomicReference();
    private long lastRouteModificationTime = 0L;
    private long lastRoutingFinishTime = 0L;
    private RouterConfiguration routerConfiguration = new RouterConfiguration();
    RouteServiceListener routeListener = e -> {
        Route r = this.highlightedRoute;
        if (r == null || e.obj != r) {
            return;
        }
        switch (e.type) {
            case 6: {
                this.highlightedRoute = null;
                this.routeDirty = true;
                this.routePointsDirty = true;
                break;
            }
            case 8: {
                this.routeDirty = true;
                this.routePointsDirty = true;
                this.lastRouteModificationTime = System.currentTimeMillis();
                this.cancelCurrentRouteTask(false);
                ThreadUtils.asyncExec((IThreadWorkQueue)this.context.getThreadAccess(), this::updateRoutePointsIfNecessary);
            }
        }
    };
    private Path2D badgePath;
    private Consumer<List<Resource>> routeReady = dnElements -> {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("routing complete: {}", dnElements);
        }
        if (dnElements != RouteJob.CANCELLED_RESULT) {
            this.scheduleUpdateRouteToSelection((List<Resource>)dnElements);
        }
    };

    private void cancelCurrentRouteTask(boolean mayInterruptIfRunning) {
        Future c = this.currentRouteTask.getAndSet(null);
        if (c != null) {
            c.cancel(mayInterruptIfRunning);
        }
    }

    public void init(ICanvasContext context, Selection selection, RouteService routeService) {
        this.context = context;
        this.selection = selection;
        this.routeService = routeService;
        if (routeService != null) {
            routeService.addListener(this.routeListener);
        }
    }

    public void init() {
        super.init();
        this.addEventHandler((IEventHandler)this);
    }

    public void cleanup() {
        this.removeEventHandler((IEventHandler)this);
        this.cancelCurrentRouteTask(false);
        this.highlight = null;
        this.highlightedRoute = null;
        this.context = null;
        this.diagram = null;
        this.selection = null;
        if (this.routeService != null) {
            this.routeService.removeListener(this.routeListener);
        }
        this.routeService = null;
        super.cleanup();
    }

    public void setDiagram(IDiagram diagram) {
        this.diagram = diagram;
    }

    public void setHighlightedElement(IElement highlight) {
        this.highlight = Point.resolve(highlight);
    }

    private boolean scheduleRouting(Route route, Consumer<List<Resource>> consumer) {
        if (this.currentRouteTask.get() != null) {
            return false;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("lastRoutingFinishTime: {}", (Object)this.lastRoutingFinishTime);
        }
        long t = System.currentTimeMillis();
        long sinceLastRouting = t - this.lastRoutingFinishTime;
        long sinceLastModification = t - this.lastRouteModificationTime;
        if (this.lastRoutingFinishTime == -1L || sinceLastRouting < 1000L || sinceLastModification < 200L) {
            return false;
        }
        int points = route.count();
        if (points < 2) {
            this.scheduleUpdateRouteToSelection(RoutePersistence.toResources((List)route.waypoints()));
            return true;
        }
        CompletableFuture future = new CompletableFuture();
        this.currentRouteTask.set(future);
        future.exceptionally(e -> {
            LOGGER.trace("routing complete exceptionally");
            this.currentRouteTask.compareAndSet(future, null);
            this.lastRoutingFinishTime = System.currentTimeMillis();
            return Collections.emptyList();
        });
        future.thenAccept(e -> {
            LOGGER.trace("routing completed");
            this.currentRouteTask.compareAndSet(future, null);
            this.lastRoutingFinishTime = System.currentTimeMillis();
        });
        future.thenAccept(consumer);
        this.lastRoutingFinishTime = -1L;
        new RouteJob(this.routerConfiguration, route, future).schedule();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("scheduled routing for route {}", (Object)route);
        }
        return true;
    }

    public Rectangle2D getBoundsInLocal() {
        return null;
    }

    private void scheduleUpdateRouteToSelection(List<Resource> dnElements) {
        ThreadUtils.asyncExec((IThreadWorkQueue)this.context.getThreadAccess(), () -> this.updateRouteToSelection(dnElements));
    }

    private List<IElement> resolveElements(List<Resource> dnElements) {
        if (this.diagram != null) {
            DataElementMap map = (DataElementMap)this.diagram.getDiagramClass().getAtMostOneItemOfClass(DataElementMap.class);
            return dnElements.stream().map(e -> map.getElement(this.diagram, e)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void updateRouteToSelection(List<Resource> dnElements) {
        if (this.highlightedRoute != null && this.diagram != null && this.selection != null) {
            List<IElement> elements = this.resolveElements(dnElements);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("converted route to elements: {}", elements);
            }
            this.selection.setSelection(0, elements);
        }
    }

    public void render(Graphics2D g) {
        Rectangle2D bounds;
        Composite oldComposite = g.getComposite();
        double scale = GeometryUtils.getScale((AffineTransform)g.getTransform());
        g.setComposite(AlphaComposite.getInstance(3, 0.8f));
        if (this.highlight != null && (bounds = this.highlight.node.getBounds()) != null) {
            this.highlightShape.setFrame(bounds);
            GeometryUtils.expandRectangle((Rectangle2D)this.highlightShape, (double)(3.0 / scale));
            g.setStroke(new BasicStroke(3.0f / (float)scale));
            g.setPaint(Color.BLACK);
            g.draw(this.highlightShape);
        }
        if (this.routePoints != null && !this.routePoints.isEmpty()) {
            AffineTransform origAt = g.getTransform();
            for (Point p : this.routePoints) {
                this.drawPinBadge(g, p, scale);
                g.setTransform(origAt);
            }
        }
        g.setComposite(oldComposite);
    }

    private Shape getBadgeShape() {
        if (this.badgePath != null) {
            return this.badgePath;
        }
        Path2D.Double p = new Path2D.Double(0);
        double r = 2.0;
        double r2 = r / 3.0;
        double e = 5.0;
        ((Path2D)p).moveTo(0.0, 0.0);
        p.append(new Arc2D.Double(-r, -r - e, 2.0 * r, 2.0 * r, -25.0, 230.0, 0), true);
        ((Path2D)p).lineTo(0.0, 0.0);
        p.append(new Ellipse2D.Double(-r2, -r2 - e, r2 * 2.0, r2 * 2.0), false);
        this.badgePath = p;
        return p;
    }

    private void drawPinBadge(Graphics2D g, Point pt, double scale) {
        Rectangle2D b = pt.node.getBounds();
        double xs = b.getCenterX();
        double ys = b.getCenterY();
        g.translate(xs, ys);
        double s = 5.0 / scale;
        g.scale(s, s);
        g.setColor(Color.RED);
        g.fill(this.getBadgeShape());
    }

    public int getEventMask() {
        return EventTypes.TimeMask;
    }

    public boolean handleEvent(Event e) {
        this.updateRouteIfNecessary();
        this.updateRoutePointsIfNecessary();
        return false;
    }

    private void updateRouteIfNecessary() {
        Route r = this.highlightedRoute;
        IDiagram d = this.diagram;
        if (r != null && d != null && this.routeDirty && this.scheduleRouting(r, this.routeReady)) {
            this.routeDirty = false;
        }
    }

    private boolean updateRoutePointsIfNecessary() {
        if (!this.routePointsDirty) {
            return false;
        }
        this.routePointsDirty = false;
        Route r = this.highlightedRoute;
        IDiagram d = this.diagram;
        if (r == null || d == null) {
            this.routePoints.clear();
            return true;
        }
        DataElementMap map = (DataElementMap)d.getDiagramClass().getAtMostOneItemOfClass(DataElementMap.class);
        this.routePoints.clear();
        RoutePersistence.toResources((List)r.waypoints()).stream().map(el -> map.getElement(this.diagram, el)).filter(Objects::nonNull).map(Point::resolve).forEach(this.routePoints::add);
        return true;
    }

    public void setHighlightedRoute(Route route) {
        if (route != this.highlightedRoute) {
            this.highlightedRoute = route;
            this.routeDirty = true;
            this.routePointsDirty = true;
        }
    }

    private static class Point
    implements Container<Resource> {
        IElement element;
        DistrictNetworkVertexNode node;
        Resource dnResource;

        private Point(IElement element, DistrictNetworkVertexNode node, Resource dnResource) {
            this.element = element;
            this.node = node;
            this.dnResource = dnResource;
        }

        static Point resolve(IElement e) {
            if (e == null) {
                return null;
            }
            INode node = (INode)e.getHint(ElementHints.KEY_SG_NODE);
            if (node == null) {
                return null;
            }
            if (!((node = NodeUtil.getFirstChild((INode)node)) instanceof DistrictNetworkVertexNode)) {
                return null;
            }
            Object r = e.getHint(ElementHints.KEY_OBJECT);
            if (!(r instanceof Resource)) {
                return null;
            }
            return new Point(e, (DistrictNetworkVertexNode)node, (Resource)r);
        }

        public Resource get() {
            return this.dnResource;
        }

        public String toString() {
            return this.element.toString();
        }
    }
}

