/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Optional;
import org.simantics.district.network.ui.adapters.DistrictNetworkVertex;
import org.simantics.district.network.ui.nodes.ConnectionLineNode;
import org.simantics.district.network.ui.nodes.DistrictNetworkNode;
import org.simantics.district.network.ui.nodes.DistrictNetworkNodeUtils;
import org.simantics.district.network.ui.nodes.DistrictNetworkStaticInfoNode;
import org.simantics.district.network.ui.nodes.DistrictRenderingHints;
import org.simantics.district.network.ui.nodes.HoverSensitiveNode;
import org.simantics.district.network.ui.nodes.NotInSimulationNode;
import org.simantics.maps.MapScalingTransform;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ISelectionPainterNode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.G2DRenderingHints;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.SVGNode;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;

public class DistrictNetworkVertexNode
extends DistrictNetworkNode
implements ISelectionPainterNode,
HoverSensitiveNode {
    private static final long serialVersionUID = -2641639101400236719L;
    private static final double left = -15.0;
    private static final double top = -15.0;
    public static final double width = 30.0;
    private static final double height = 30.0;
    private static final BasicStroke STROKE = new BasicStroke(30.0f, 1, 1);
    private static final Color SELECTION_COLOR = new Color(255, 0, 255, 96);
    private static final Color HILITE_COLOR = new Color(247, 247, 67, 96);
    private static final Rectangle2D NORMAL = new Rectangle2D.Double(-15.0, -15.0, 30.0, 30.0);
    private static final Rectangle2D HOVERED = new Rectangle2D.Double(-30.0, -30.0, 60.0, 60.0);
    private DistrictNetworkVertex vertex;
    private static boolean scaleStroke = true;
    private boolean hover;
    private Color color;
    private transient Color dynamicColor;
    private transient Color eventColor;
    private transient Point2D point;
    private transient Rectangle2D rect;
    private transient AffineTransform symbolTransform;
    private double nodeSize = 1.0;
    private boolean hidden = false;
    private boolean hilite = false;

    public void init() {
        this.setZIndex(2);
    }

    public void render(Graphics2D g2d) {
        double viewScaleRecip;
        AffineTransform ot = null;
        AffineTransform t = this.getTransform();
        double d = viewScaleRecip = scaleStroke ? (Double)g2d.getRenderingHint(DistrictRenderingHints.KEY_VIEW_SCALE_RECIPROCAL_UNDER_SPATIAL_ROOT) : 1.0;
        if (t != null && !t.isIdentity()) {
            ot = (AffineTransform)g2d.getRenderingHint((RenderingHints.Key)G2DRenderingHints.KEY_TRANSFORM_UNDER_SPATIAL_ROOT);
            if (ot == null) {
                ot = g2d.getTransform();
            }
            g2d.transform(t);
            if (scaleStroke) {
                AffineTransform work = DistrictNetworkNodeUtils.sharedTransform.get();
                work.setTransform(ot);
                work.concatenate(t);
                viewScaleRecip = DistrictNetworkNodeUtils.calculateScaleRecip(work);
            }
        }
        Point2D p = this.point = DistrictNetworkNodeUtils.calculatePoint2D(this.vertex.getPoint(), this.point);
        if (!this.hidden && this.nodeSize > 0.0) {
            Object oaaHint = null;
            Object aaHint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            if (aaHint != RenderingHints.VALUE_ANTIALIAS_OFF) {
                oaaHint = aaHint;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            Color oldColor = g2d.getColor();
            Color newColor = this.eventColor != null ? this.eventColor : (this.dynamicColor != null ? this.dynamicColor : this.color);
            boolean changeColor = !oldColor.equals(newColor);
            double scaleRecip = viewScaleRecip * this.nodeSize;
            Rectangle2D toDraw = this.rect = DistrictNetworkNodeUtils.calculateDrawnGeometry(p, this.hover ? HOVERED : NORMAL, this.rect, scaleRecip);
            if (NodeUtil.isSelected((INode)this, (int)1) || this.hilite) {
                changeColor = true;
                if (this.hilite) {
                    g2d.setColor(HILITE_COLOR);
                } else {
                    g2d.setColor(SELECTION_COLOR);
                }
                BasicStroke ss = GeometryUtils.scaleStroke((Stroke)STROKE, (float)((float)viewScaleRecip));
                g2d.setStroke(ss);
                g2d.draw(toDraw);
            }
            if (changeColor) {
                g2d.setColor(newColor);
            }
            g2d.fill(toDraw);
            if (changeColor) {
                g2d.setColor(oldColor);
            }
            if (oaaHint != null) {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaHint);
            }
        }
        for (INode nn : this.getNodes()) {
            G2DNode g2dNode = (G2DNode)nn;
            if (nn instanceof SVGNode) {
                Rectangle2D toDraw = this.rect = DistrictNetworkNodeUtils.calculateDrawnGeometry(p, this.hover ? HOVERED : NORMAL, this.rect, viewScaleRecip);
                this.symbolTransform = DistrictNetworkNodeUtils.getTransformToRectangle(toDraw, this.symbolTransform);
                g2dNode.setTransform(this.symbolTransform);
            }
            g2dNode.render(g2d);
        }
        if (ot != null) {
            g2d.setTransform(ot);
        }
    }

    @Override
    protected Rectangle2D _getOwnBounds() {
        this.updateBounds();
        return this.bounds;
    }

    public void setTransform(AffineTransform transform) {
        super.setTransform(transform);
        this.updateBounds();
    }

    @Override
    protected Rectangle2D calculateBounds(Rectangle2D rect) {
        Point2D calcPoint = DistrictNetworkNodeUtils.calculatePoint2D(this.vertex.getPoint(), this.point);
        AffineTransform at = NodeUtil.getLocalToGlobalTransform((IG2DNode)this);
        at.concatenate(MapScalingTransform.INSTANCE);
        double x = calcPoint.getX();
        double y = calcPoint.getY();
        double scaleRecip = DistrictNetworkNodeUtils.calculateScaleRecip(at);
        double widthh = 30.0 * scaleRecip * this.nodeSize;
        double heighth = 30.0 * scaleRecip * this.nodeSize;
        if (rect == null) {
            rect = new Rectangle2D.Double();
        }
        rect.setRect(x - widthh / 2.0, y - heighth / 2.0, widthh, heighth);
        return rect;
    }

    public void setVertex(DistrictNetworkVertex vertex) {
        this.vertex = vertex;
        this.updateBounds();
    }

    public DistrictNetworkVertex getVertex() {
        return this.vertex;
    }

    @Override
    public boolean hover(boolean hover, boolean isConnectionTool) {
        boolean doHover = hover && isConnectionTool;
        boolean changed = this.hover ^ doHover;
        this.hover = doHover;
        for (IG2DNode child : this.getNodes()) {
            if (!(child instanceof HoverSensitiveNode)) continue;
            boolean bl = changed = ((HoverSensitiveNode)child).hover(hover, isConnectionTool) || changed;
        }
        return changed;
    }

    @Override
    public void setMousePosition(Point2D p) {
        for (IG2DNode child : this.getNodes()) {
            if (!(child instanceof HoverSensitiveNode)) continue;
            ((HoverSensitiveNode)child).setMousePosition(p);
        }
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    @INode.PropertySetter(value="SVG")
    public void setSVG(String value) {
        for (INode nn : this.getNodes()) {
            if (!(nn instanceof SVGNode)) continue;
            ((SVGNode)nn).setData(value);
        }
    }

    @INode.PropertySetter(value="size")
    public void setSize(double size) {
        boolean changed = false;
        if (size != Double.MIN_VALUE) {
            changed = size != this.nodeSize;
            this.nodeSize = size;
        } else {
            changed = this.nodeSize != 1.0;
            this.nodeSize = 1.0;
        }
        if (changed) {
            this.updateBounds();
        }
    }

    @INode.PropertySetter(value="dynamicColor")
    public void setDynamicColor(Color color) {
        this.dynamicColor = color;
    }

    @INode.PropertySetter(value="eventColor")
    public void setEventColor(Color colorr) {
        this.eventColor = colorr;
    }

    @INode.PropertySetter(value="hidden")
    public void setHidden(Boolean value) {
        this.hidden = value;
    }

    @INode.PropertySetter(value="hilite")
    public void setHilite(boolean hilited) {
        this.hilite = hilited;
    }

    public void setStaticInformation(Optional<String> staticInformation) {
        DistrictNetworkStaticInfoNode child = (DistrictNetworkStaticInfoNode)this.getOrCreateNode("DISTRICT_NETWORK_STATIC_INFO", DistrictNetworkStaticInfoNode.class);
        Point2D calculatePoint2D = DistrictNetworkNodeUtils.calculatePoint2D(this.vertex.getPoint(), null);
        child.setLocation(calculatePoint2D, new Point2D.Double(1.0, 0.0));
        if (staticInformation.isPresent()) {
            child.setInfo(staticInformation.get());
        } else {
            child.setInfo(null);
        }
    }

    public void setInSimulation(Optional<Boolean> isInSimulation) {
        if (!isInSimulation.isPresent()) {
            this.removeNode("notInSimulation");
        } else {
            NotInSimulationNode child = (NotInSimulationNode)((Object)this.getOrCreateNode("notInSimulation", NotInSimulationNode.class));
            child.setZIndex(1000);
            child.setIsInSimulation(isInSimulation.get());
        }
    }

    public void setConnectionLinePoints(List<Point2D> points) {
        if (points == null) {
            this.removeNode("districtNetworkConnection");
        } else {
            ConnectionLineNode child = (ConnectionLineNode)((Object)this.getOrCreateNode("districtNetworkConnection", ConnectionLineNode.class));
            child.setZIndex(0);
            child.setStrokeWidth(2.0f);
            child.setPoints(points);
        }
    }
}

