/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Optional;
import org.simantics.district.network.ModelledCRS;
import org.simantics.district.network.ui.DistrictNetworkEdge;
import org.simantics.district.network.ui.adapters.DistrictNetworkEdgeElementFactory;
import org.simantics.district.network.ui.nodes.DistrictNetworkEdgeArrayNode;
import org.simantics.district.network.ui.nodes.DistrictNetworkNode;
import org.simantics.district.network.ui.nodes.DistrictNetworkNodeUtils;
import org.simantics.district.network.ui.nodes.DistrictNetworkStaticInfoNode;
import org.simantics.district.network.ui.nodes.DistrictRenderingHints;
import org.simantics.district.network.ui.nodes.NotInSimulationNode;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ISelectionPainterNode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.G2DRenderingHints;
import org.simantics.scenegraph.g2d.nodes.SVGNode;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;

public class DistrictNetworkEdgeNode
extends DistrictNetworkNode
implements ISelectionPainterNode {
    private static final long serialVersionUID = 8049769475036519806L;
    public static final BasicStroke STROKE = new BasicStroke(4.0f, 1, 1);
    private static final Color SELECTION_COLOR = new Color(255, 0, 255, 96);
    private static final Color HILITE_COLOR = new Color(247, 229, 67, 196);
    private DistrictNetworkEdge edge;
    private transient Path2D path;
    private transient Path2D detailedPath;
    private transient int zoomLevel = 0;
    static final boolean scaleStroke = true;
    private Color color;
    private double stroke;
    private transient Color dynamicColor = null;
    private transient Color eventColor = null;
    private static final double left = -0.25;
    private static final double top = -0.25;
    private static final double width = 0.5;
    private static final double height = 0.5;
    private static final Rectangle2D NORMAL = new Rectangle2D.Double(-0.25, -0.25, 0.5, 0.5);
    private transient Point2D centerPoint;
    private transient Point2D detailedCenterPoint;
    private transient Point2D direction;
    private transient Point2D detailedDirection;
    private transient Rectangle2D symbolRect;
    private transient AffineTransform symbolTransform;
    private boolean hidden = false;
    private boolean hilite = false;
    private static double startX;
    private static double startY;
    private static double endX;
    private static double endY;

    public void init() {
    }

    public void render(Graphics2D g2d) {
        AffineTransform ot = null;
        AffineTransform t = this.getTransform();
        double scale = (Double)g2d.getRenderingHint(DistrictRenderingHints.KEY_VIEW_SCALE_UNDER_SPATIAL_ROOT);
        if (t != null && !t.isIdentity()) {
            ot = (AffineTransform)g2d.getRenderingHint((RenderingHints.Key)G2DRenderingHints.KEY_TRANSFORM_UNDER_SPATIAL_ROOT);
            if (ot == null) {
                ot = g2d.getTransform();
            }
            g2d.transform(t);
            AffineTransform work = DistrictNetworkNodeUtils.sharedTransform.get();
            work.setTransform(ot);
            work.concatenate(t);
            scale = DistrictNetworkNodeUtils.getScale(work);
        }
        this.zoomLevel = (Integer)g2d.getRenderingHint(DistrictRenderingHints.KEY_VIEW_ZOOM_LEVEL);
        if (!this.hidden) {
            Path2D path;
            Object aaHint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color oldColor = g2d.getColor();
            BasicStroke oldStroke = (BasicStroke)g2d.getStroke();
            BasicStroke bs = null;
            bs = GeometryUtils.scaleStroke((Stroke)STROKE, (float)this.getStrokeWidth(scale));
            Path2D path2D = path = this.renderDetailed(this.zoomLevel) ? this.detailedPath : this.path;
            if (this.isSelected() || this.hilite) {
                if (this.hilite) {
                    g2d.setColor(HILITE_COLOR);
                } else {
                    g2d.setColor(SELECTION_COLOR);
                }
                g2d.setStroke(GeometryUtils.scaleAndOffsetStrokeWidth((Stroke)bs, (float)1.0f, (float)((float)((double)(2.0f * STROKE.getLineWidth()) / scale))));
                g2d.draw(path);
            }
            g2d.setColor(this.dynamicColor != null ? this.dynamicColor : this.color);
            g2d.setColor(this.eventColor != null ? this.eventColor : g2d.getColor());
            g2d.setStroke(bs);
            g2d.draw(path);
            g2d.setStroke(oldStroke);
            g2d.setColor(oldColor);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaHint);
        }
        Point2D centerP = this.getCenterPoint(this.zoomLevel);
        for (INode nn : this.getNodes()) {
            G2DNode g2dNode = (G2DNode)nn;
            if (g2dNode instanceof SVGNode) {
                if (!DistrictNetworkEdgeNode.isDefined(centerP)) break;
                double viewScaleRecip = 10.0 / scale;
                this.symbolRect = DistrictNetworkNodeUtils.calculateDrawnGeometry(centerP, NORMAL, this.symbolRect, viewScaleRecip);
                this.symbolTransform = DistrictNetworkNodeUtils.getTransformToRectangle(this.symbolRect, this.symbolTransform);
                g2dNode.setTransform(this.symbolTransform);
            }
            g2dNode.render(g2d);
        }
        if (ot != null) {
            g2d.setTransform(ot);
        }
    }

    static boolean isDefined(Point2D p) {
        return p != null && !Double.isNaN(p.getX()) && !Double.isNaN(p.getY());
    }

    boolean renderDetailed(int zoomLevel) {
        return zoomLevel > 13;
    }

    public float getStrokeWidth(AffineTransform tr, boolean selection) {
        double scale = DistrictNetworkNodeUtils.getScale(tr);
        float width = STROKE.getLineWidth() * this.getStrokeWidth(scale);
        if (selection) {
            width += (float)((double)(2.0f * STROKE.getLineWidth()) / scale);
        }
        return width;
    }

    private float getStrokeWidth(double scale) {
        double str = this.stroke != Double.MIN_VALUE ? Math.abs(this.stroke) : 1.0;
        float strokeWidth = (float)(str / scale);
        return strokeWidth;
    }

    public Path2D getPath() {
        return this.renderDetailed(this.zoomLevel) ? this.detailedPath : this.path;
    }

    public Point2D getCenterPoint(int zoomLevel) {
        return this.renderDetailed(zoomLevel) ? this.detailedCenterPoint : this.centerPoint;
    }

    public Point2D getDirection(int zoomLevel) {
        return this.renderDetailed(zoomLevel) ? this.detailedDirection : this.direction;
    }

    public static Path2D calculatePath(DistrictNetworkEdge edge, Path2D result, boolean detailed) {
        double[] detailedGeometry;
        startX = ModelledCRS.longitudeToX((double)edge.getStartPoint().getX());
        startY = ModelledCRS.latitudeToY((double)(-edge.getStartPoint().getY()));
        endX = ModelledCRS.longitudeToX((double)edge.getEndPoint().getX());
        endY = ModelledCRS.latitudeToY((double)(-edge.getEndPoint().getY()));
        if (result == null) {
            result = new Path2D.Double();
        } else {
            result.reset();
        }
        result.moveTo(startX, startY);
        if (detailed && (detailedGeometry = edge.getGeometry()) != null && !DistrictNetworkEdgeElementFactory.EMPTY.equals(detailedGeometry)) {
            int i = 0;
            while (i < detailedGeometry.length) {
                double x = ModelledCRS.longitudeToX((double)detailedGeometry[i]);
                double y = ModelledCRS.latitudeToY((double)(-detailedGeometry[i + 1]));
                result.lineTo(x, y);
                i += 2;
            }
        }
        result.lineTo(endX, endY);
        return result;
    }

    private boolean isSelected() {
        return NodeUtil.isSelected((INode)this, (int)1);
    }

    @Override
    protected Rectangle2D calculateBounds(Rectangle2D rect) {
        if (this.detailedPath == null) {
            this.detailedPath = DistrictNetworkEdgeNode.calculatePath(this.edge, this.detailedPath, true);
        }
        return this.detailedPath.getBounds2D();
    }

    public void setDNEdge(DistrictNetworkEdge edge) {
        this.edge = edge;
        this.path = DistrictNetworkEdgeNode.calculatePath(edge, this.path, false);
        this.detailedPath = DistrictNetworkEdgeNode.calculatePath(edge, this.detailedPath, true);
        this.centerPoint = new Point2D.Double();
        this.detailedCenterPoint = new Point2D.Double();
        this.direction = new Point2D.Double();
        this.detailedDirection = new Point2D.Double();
        DistrictNetworkNodeUtils.calculateCenterPointAndDirection(this.path, this.centerPoint, this.direction);
        DistrictNetworkNodeUtils.calculateCenterPointAndDirection(this.detailedPath, this.detailedCenterPoint, this.detailedDirection);
        this.updateBounds();
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    @INode.PropertySetter(value="stroke")
    public void setStroke(double stroke) {
        this.stroke = stroke;
    }

    @INode.PropertySetter(value="dynamicColor")
    public void setDynamicColor(Color color) {
        this.dynamicColor = color;
    }

    @INode.PropertySetter(value="eventColor")
    public void setEventColor(Color color) {
        this.eventColor = color;
    }

    @INode.PropertySetter(value="arrowLength")
    public void setArrowLength(double length) {
        DistrictNetworkEdgeArrayNode child = (DistrictNetworkEdgeArrayNode)this.getOrCreateNode("DISTRICT_NETWORK_EDGE_ARRAY", DistrictNetworkEdgeArrayNode.class);
        child.setEdgeNode(this);
        child.setArrowLength(length);
    }

    @INode.PropertySetter(value="SVG")
    public void setSVG(String value) {
        for (INode nn : this.getNodes()) {
            if (!(nn instanceof SVGNode)) continue;
            ((SVGNode)nn).setData(value);
        }
    }

    @INode.PropertySetter(value="hidden")
    public void setHidden(Boolean value) {
        this.hidden = value;
    }

    @INode.PropertySetter(value="hilite")
    public void setHilite(boolean hilited) {
        this.hilite = hilited;
    }

    public void setStaticInformation(Optional<String> staticInformation) {
        DistrictNetworkStaticInfoNode child = (DistrictNetworkStaticInfoNode)this.getOrCreateNode("DISTRICT_NETWORK_STATIC_INFO", DistrictNetworkStaticInfoNode.class);
        child.setEdgeNode(this);
        if (staticInformation.isPresent()) {
            child.setInfo(staticInformation.get());
        } else {
            child.setInfo(null);
        }
    }

    public void setInSimulation(Optional<Boolean> isInSimulation) {
        if (!isInSimulation.isPresent()) {
            this.removeNode("notInSimulation");
        } else {
            NotInSimulationNode child = (NotInSimulationNode)((Object)this.getOrCreateNode("notInSimulation", NotInSimulationNode.class));
            child.setZIndex(1000);
            child.setIsInSimulation(isInSimulation.get());
        }
    }
}

