/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.contributions;

import java.util.List;
import javax.inject.Named;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.progress.UIJob;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.datatypes.literal.RGB;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.color.Color;
import org.simantics.utils.ui.workbench.dialogs.ColorDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeMapBackgroundColorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeMapBackgroundColorHandler.class);

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ISelection selection) {
        List diagrams = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        return diagrams.size() > 0;
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") Object selection) {
        final List diagrams = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        UIJob uijob = new UIJob("Change Map Background Color"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ColorDialog dialog = new ColorDialog(this.getDisplay().getActiveShell());
                if (dialog.open() == 0) {
                    final Color c = dialog.getColor();
                    LOGGER.info("Found color {}", (Object)c);
                    DatabaseJob job = new DatabaseJob("Toggle draw map"){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                Simantics.getSession().syncRequest(graph -> DistrictNetworkUtil.changeMapBackgroundColor((WriteGraph)graph, (Resource)((Resource)diagrams.get(0)), (RGB.Integer)new RGB.Integer(c.getR(), c.getG(), c.getB())));
                            }
                            catch (DatabaseException e) {
                                return new Status(4, "org.simantics.district.network.ui", String.valueOf(this.getName()) + " failed.", (Throwable)e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                }
                return Status.OK_STATUS;
            }
        };
        uijob.setUser(true);
        uijob.schedule();
    }
}

