/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.swing;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JSlider;
import org.simantics.scenegraph.ExportableWidget;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.swing.ComponentNode;

@ExportableWidget.OutputWidget(value={"value", "min", "max"})
@ExportableWidget.InputWidget(value={"value"})
public class SliderNode
extends ComponentNode<JSlider> {
    private static final long serialVersionUID = 3161843367263793336L;
    protected transient ActionListener actionListener = null;
    protected Integer value = 0;
    protected Integer min = 0;
    protected Integer max = 0;

    @INode.ClientSide
    public void setValue(Integer value) {
        this.value = value;
        if (this.component != null && !((JSlider)this.component).getValueIsAdjusting()) {
            ((JSlider)this.component).setValue(value);
        }
    }

    @Override
    public void init() {
        this.component = new JSlider();
        ((JSlider)this.component).setPaintTicks(true);
        ((JSlider)this.component).addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (((JSlider)SliderNode.this.component).getValueIsAdjusting()) {
                    SliderNode.this.valueChanged(((JSlider)SliderNode.this.component).getValue());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        super.init();
    }

    @INode.ServerSide
    protected void valueChanged(Integer value) {
        if (this.actionListener != null) {
            ActionEvent e = new ActionEvent(this.component, 1001, "" + value);
            this.actionListener.actionPerformed(e);
        }
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    @INode.PropertySetter(value="Value Extent")
    @INode.ClientSide
    public void setExtent(Integer extent) {
        if (this.component != null) {
            ((JSlider)this.component).setExtent(extent);
        }
    }

    @INode.PropertySetter(value="Min Value")
    @INode.ClientSide
    public void setMinimum(Integer min) {
        this.min = min;
        if (this.component != null) {
            ((JSlider)this.component).setMinimum(min);
        }
    }

    @INode.PropertySetter(value="Max Value")
    @INode.ClientSide
    public void setMaximum(Integer max) {
        this.max = max;
        if (this.component != null) {
            ((JSlider)this.component).setMaximum(max);
        }
    }

    @INode.ClientSide
    public void setOrientation(Integer orientation) {
        if (this.component != null) {
            ((JSlider)this.component).setOrientation(orientation);
        }
    }

    @INode.ClientSide
    public void setTitle(String string) {
        if (this.component != null) {
            ((JSlider)this.component).setBorder(BorderFactory.createTitledBorder(string));
        }
    }

    @INode.PropertySetter(value="Major Tick Spacing")
    @INode.ClientSide
    public void setMajorTickSpacing(Integer i) {
        if (this.component != null) {
            ((JSlider)this.component).setLabelTable(((JSlider)this.component).createStandardLabels(i, ((JSlider)this.component).getMinimum()));
            ((JSlider)this.component).setMajorTickSpacing(i);
        }
    }

    @INode.PropertySetter(value="Minor Tick Spacing")
    @INode.ClientSide
    public void setMinorTickSpacing(Integer i) {
        if (this.component != null) {
            ((JSlider)this.component).setMinorTickSpacing(i);
        }
    }

    @INode.PropertySetter(value="Paint Ticks")
    @INode.ClientSide
    public void setPaintTicks(Boolean b) {
        if (this.component != null) {
            ((JSlider)this.component).setPaintTicks(b);
            ((JSlider)this.component).updateUI();
        }
    }

    @INode.PropertySetter(value="Paint Labels")
    @INode.ClientSide
    public void setPaintLabels(Boolean b) {
        if (this.component != null) {
            ((JSlider)this.component).setPaintLabels(b);
        }
    }

    @INode.PropertySetter(value="Paint Track")
    @INode.ClientSide
    public void setPaintTrack(Boolean b) {
        if (this.component != null) {
            ((JSlider)this.component).setPaintTrack(b);
        }
    }

    @INode.PropertySetter(value="Snap To Ticks")
    @INode.ClientSide
    public void setSnapToTicks(Boolean b) {
        if (this.component != null) {
            ((JSlider)this.component).setSnapToTicks(b);
        }
    }

    @INode.PropertySetter(value="Inverted")
    @INode.ClientSide
    public void setInverted(Boolean b) {
        if (this.component != null) {
            ((JSlider)this.component).setInverted(b);
        }
    }

    @Override
    @INode.PropertySetter(value="Background Color")
    @INode.ClientSide
    public void setBackgroundColor(Color color) {
    }

    public String widgetGet(String name) {
        if ("value".equals(name)) {
            return "" + this.value;
        }
        if ("min".equals(name)) {
            return "" + this.min;
        }
        if ("max".equals(name)) {
            return "" + this.max;
        }
        return null;
    }

    public void widgetSet(String name, String value) {
        if ("value".equals(name)) {
            this.value = Integer.parseInt(value);
            this.valueChanged(this.value);
        }
    }
}

