/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt.internal;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class Threads {
    private static ExecutorService executor;

    public static synchronized void initialize() {
        if (executor == null) {
            Threads.initializeExecutor();
        }
    }

    public static synchronized void shutdown() {
        if (executor != null) {
            executor.shutdown();
            executor = null;
        }
    }

    private static ExecutorService initializeExecutor() {
        if (executor == null) {
            final ThreadGroup tg = new ThreadGroup("GraphExplorer-Worker-Group");
            final AtomicInteger counter = new AtomicInteger(0);
            ThreadFactory tf = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(tg, r, "GraphExplorer-Worker-" + counter.incrementAndGet());
                    if (!t.isDaemon()) {
                        t.setDaemon(true);
                    }
                    if (t.getPriority() != 5) {
                        t.setPriority(5);
                    }
                    return t;
                }
            };
            int maxPoolSize = 1;
            executor = maxPoolSize == 1 ? Executors.newSingleThreadExecutor(tf) : new ThreadPoolExecutor(maxPoolSize / 2, maxPoolSize, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), tf);
        }
        return executor;
    }

    public static ExecutorService getExecutor() {
        ExecutorService service = executor;
        if (service == null) {
            throw new IllegalStateException("executor not initialized");
        }
        return service;
    }
}

