/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.modifiers.EnumeratedValue;
import org.simantics.browsing.ui.common.modifiers.Enumeration;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.swt.contentassist.ContentAssistTextField;
import org.simantics.browsing.ui.swt.contentassist.INamedObject;
import org.simantics.browsing.ui.swt.contentassist.NamedObject;

public class AbstractContentAssistEnumerationModifier<T>
implements Labeler.CustomModifier {
    protected final Enumeration<T> enumeration;
    protected final EnumeratedValue<T> value;
    protected ContentAssistTextField text;

    public AbstractContentAssistEnumerationModifier(Enumeration<T> enumeration, T value) {
        this(enumeration, enumeration.find(value));
    }

    public AbstractContentAssistEnumerationModifier(Enumeration<T> enumeration, EnumeratedValue<T> value) {
        if (enumeration == null) {
            throw new NullPointerException("null enumeration");
        }
        if (enumeration.size() == 0) {
            throw new IllegalArgumentException("");
        }
        this.enumeration = enumeration;
        this.value = value;
    }

    public String getValue() {
        if (this.value != null) {
            return this.value.getName();
        }
        return ((EnumeratedValue)this.enumeration.values().get(0)).getName();
    }

    public String isValid(String label) {
        if (this.enumeration.findByName(label) == null) {
            return "Value '" + label + "' is not among the enumerated values " + this.enumeration.values();
        }
        return null;
    }

    public void modify(String label) {
        EnumeratedValue value = this.enumeration.findByName(label);
        if (value == null) {
            throw new IllegalArgumentException("Cannot modify enumeration with value '" + label + "', not among the enumerated values " + this.enumeration.values());
        }
        this.modifyWithValue(this.value, value);
    }

    protected void modifyWithValue(EnumeratedValue<T> oldEnumValue, EnumeratedValue<T> enumValue) {
        Object oldObject = oldEnumValue != null ? oldEnumValue.getObject() : null;
        Object newObject = enumValue != null ? enumValue.getObject() : null;
        this.modifyWithObject(oldObject, newObject, EnumeratedValue.isInvalid(oldEnumValue));
    }

    protected void modifyWithObject(T oldEnumObject, T enumObject, boolean force) {
    }

    protected NamedObject<T> createNamedObject(EnumeratedValue<T> value) {
        return new NamedObject<Object>(value.getObject(), value.getName());
    }

    protected List<NamedObject<T>> toNamedObjects(Enumeration<T> enumeration) {
        ArrayList<NamedObject<T>> namedObjects = new ArrayList<NamedObject<T>>();
        for (EnumeratedValue v : enumeration.values()) {
            namedObjects.add(this.createNamedObject(v));
        }
        return namedObjects;
    }

    public Object createControl(Object parentControl, Object controlItem, final int columnIndex, NodeContext context) {
        Composite parent = (Composite)parentControl;
        final TreeItem item = (TreeItem)controlItem;
        List<NamedObject<T>> possibleValues = this.toNamedObjects(this.enumeration);
        NamedObject<T> selectedValue = this.value != null ? this.createNamedObject(this.value) : null;
        this.text = new ContentAssistTextField(parent, selectedValue, possibleValues, 0);
        Listener textListener = new Listener(){
            String error;

            public void handleEvent(Event e) {
                block0 : switch (e.type) {
                    case 24: {
                        String newText = AbstractContentAssistEnumerationModifier.this.text.getControl().getText();
                        this.error = AbstractContentAssistEnumerationModifier.this.isValid(newText);
                        if (this.error != null) {
                            AbstractContentAssistEnumerationModifier.this.text.getControl().setBackground(AbstractContentAssistEnumerationModifier.this.text.getDisplay().getSystemColor(3));
                            break;
                        }
                        AbstractContentAssistEnumerationModifier.this.text.getControl().setBackground(null);
                        break;
                    }
                    case 25: {
                        break;
                    }
                    case 31: {
                        switch (e.detail) {
                            case 4: {
                                String txt;
                                INamedObject obj = AbstractContentAssistEnumerationModifier.this.text.getResult();
                                String string = txt = obj != null ? obj.getName() : AbstractContentAssistEnumerationModifier.this.text.getControl().getText();
                                if (txt == null || this.error != null) {
                                    e.doit = false;
                                    return;
                                }
                                AbstractContentAssistEnumerationModifier.this.modify(txt);
                                if (!item.isDisposed()) {
                                    item.setText(columnIndex, txt);
                                }
                            }
                            case 2: {
                                AbstractContentAssistEnumerationModifier.this.text.dispose();
                                e.doit = false;
                                break block0;
                            }
                        }
                    }
                }
            }
        };
        this.text.getControl().addListener(24, textListener);
        this.text.getControl().addListener(31, textListener);
        this.text.setFocus();
        this.text.text.selectAll();
        this.text.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!AbstractContentAssistEnumerationModifier.this.text.isDisposed()) {
                    AbstractContentAssistEnumerationModifier.this.text.openAssist();
                }
            }
        });
        return this.text;
    }
}

