/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.ResourceIdArray;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class ListUtils {
    private static void insertBetween(WriteGraph g, Layer0 L0, Resource list, Resource before, Resource after, Iterable<Resource> elements) throws DatabaseException {
        Resource elementPredicate = ListUtils.getElementPredicate((ReadGraph)g, list);
        for (Resource item : elements) {
            Resource cur = g.newResource();
            g.claim(cur, L0.InstanceOf, null, L0.List_Entry);
            g.claim(cur, L0.IsOwnedBy, L0.IsComposedOf, list);
            g.claim(before, L0.List_Next, L0.List_Previous, cur);
            g.claim(cur, elementPredicate, item);
            before = cur;
        }
        g.claim(before, L0.List_Next, L0.List_Previous, after);
    }

    private static void insertBetween(WriteGraph g, Layer0 L0, Resource list, Resource before, Resource after, Resource[] elements) throws DatabaseException {
        Resource elementPredicate = ListUtils.getElementPredicate((ReadGraph)g, list);
        Resource[] resourceArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Resource item = resourceArray[n2];
            Resource cur = g.newResource();
            g.claim(cur, L0.InstanceOf, null, L0.List_Entry);
            g.claim(cur, L0.IsOwnedBy, L0.IsComposedOf, list);
            g.claim(before, L0.List_Next, L0.List_Previous, cur);
            g.claim(cur, elementPredicate, item);
            before = cur;
            ++n2;
        }
        g.claim(before, L0.List_Next, L0.List_Previous, after);
    }

    public static Resource create(WriteGraph g, Iterable<Resource> elements) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        return ListUtils.create((WriteOnlyGraph)g, L0.List, L0.List_Element, null, elements);
    }

    public static Resource createWithInverses(WriteGraph g, Iterable<Resource> elements) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        return ListUtils.create((WriteOnlyGraph)g, L0.ListWithInverses, L0.List_ElementWithInverse, L0.List_ElementWithInverse_Inverse, elements);
    }

    public static Resource create(WriteGraph g, Resource type, Iterable<Resource> elements) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource list = g.newResource();
        g.claim(list, L0.InstanceOf, null, type);
        ListUtils.insertBetween(g, L0, list, list, list, elements);
        return list;
    }

    public static Resource create(WriteGraph g, Resource type, Resource ... elements) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource list = g.newResource();
        g.claim(list, L0.InstanceOf, null, type);
        ListUtils.insertBetween(g, L0, list, list, list, elements);
        return list;
    }

    public static Resource create(WriteOnlyGraph g, Resource type, Resource elementPredicate, Resource elementPredicateInverse, Iterable<Resource> elements) throws DatabaseException {
        Layer0 L0 = (Layer0)g.getService(Layer0.class);
        Resource list = g.newResource();
        g.claim(list, L0.InstanceOf, null, type);
        if (!elementPredicate.equals(L0.List_Element)) {
            g.claim(list, L0.List_ElementPredicate, L0.List_ElementPredicate_Inverse, elementPredicate);
        }
        ListUtils.createExisting(g, list, elementPredicate, elementPredicateInverse, elements);
        return list;
    }

    public static Resource create(WriteOnlyGraph g, Resource type, Resource elementPredicate, Resource elementPredicateInverse, Resource ... elements) throws DatabaseException {
        return ListUtils.create(g, type, elementPredicate, elementPredicateInverse, Arrays.asList(elements));
    }

    public static void insertFront(WriteGraph g, Resource list, Iterable<Resource> elements) throws DatabaseException {
        if (!elements.iterator().hasNext()) {
            return;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource first = g.getSingleObject(list, L0.List_Next);
        g.deny(list, L0.List_Next, L0.List_Previous, first);
        ListUtils.insertBetween(g, L0, list, list, first, elements);
    }

    public static void createExisting(WriteOnlyGraph g, Resource list, Iterable<Resource> elements) throws DatabaseException {
        ListUtils.createExisting(g, list, false, elements);
    }

    public static void createExisting(WriteOnlyGraph g, Resource list, boolean withInverses, Iterable<Resource> elements) throws DatabaseException {
        Layer0 L0 = (Layer0)g.getService(Layer0.class);
        Resource elementPredicate = withInverses ? L0.List_ElementWithInverse : L0.List_Element;
        Resource elementPredicateInverse = withInverses ? L0.List_ElementWithInverse_Inverse : null;
        ListUtils.createExisting(g, list, elementPredicate, elementPredicateInverse, elements);
    }

    public static void createExisting(WriteOnlyGraph g, Resource list, Resource elementPredicate, Resource elementPredicateInverse, Iterable<Resource> elements) throws DatabaseException {
        Layer0 L0 = (Layer0)g.getService(Layer0.class);
        Resource before = list;
        for (Resource item : elements) {
            Resource cur = g.newResource();
            g.claim(cur, L0.InstanceOf, null, L0.List_Entry);
            g.claim(cur, L0.IsOwnedBy, L0.IsComposedOf, list);
            g.claim(before, L0.List_Next, L0.List_Previous, cur);
            g.claim(cur, elementPredicate, elementPredicateInverse, item);
            before = cur;
        }
        g.claim(before, L0.List_Next, L0.List_Previous, list);
    }

    public static void createExisting(WriteOnlyGraph g, Resource list, Resource elementPredicate, Resource elementPredicateInverse, Resource ... elements) throws DatabaseException {
        ListUtils.createExisting(g, list, elementPredicate, elementPredicateInverse, Arrays.asList(elements));
    }

    public static void insertBack(WriteGraph g, Resource list, Iterable<Resource> elements) throws DatabaseException {
        if (!elements.iterator().hasNext()) {
            return;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource last = g.getSingleObject(list, L0.List_Previous);
        g.deny(last, L0.List_Next, L0.List_Previous, list);
        ListUtils.insertBetween(g, L0, list, last, list, elements);
    }

    public static boolean replace(WriteGraph g, Resource list, Resource element, Resource replacement) throws DatabaseException {
        if (list == null || element == null || replacement == null) {
            return false;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource node = ListUtils.getNode((ReadGraph)g, list, element);
        if (node != null) {
            Resource elementPredicate = ListUtils.getElementPredicate((ReadGraph)g, list);
            g.deny(node, L0.List_Element);
            g.claim(node, elementPredicate, replacement);
            return true;
        }
        return false;
    }

    private static void toList(ReadGraph g, List<Resource> result, Resource list) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Set types = g.getTypes(list);
        if (types.contains(L0.List)) {
            Resource cur = g.getSingleObject(list, L0.List_Next);
            while (!cur.equals(list)) {
                Resource el = g.getPossibleObject(cur, L0.List_Element);
                if (el != null) {
                    result.add(el);
                }
                cur = g.getSingleObject(cur, L0.List_Next);
            }
        } else if (types.contains(L0.ResourceIdArray)) {
            ResourceIdArray arr = (ResourceIdArray)((Object)g.getValue(list, ResourceIdArray.BINDING));
            result.addAll(arr.toList());
        } else {
            throw new DatabaseException("Unknown list type: " + NameUtils.getSafeName(g, list, true) + " : " + NameUtils.toString(g, types, true));
        }
    }

    public static List<Resource> toList(ReadGraph g, Resource list) throws DatabaseException {
        ArrayList<Resource> result = new ArrayList<Resource>();
        ListUtils.toList(g, result, list);
        return result;
    }

    public static List<Resource> toPossibleList(ReadGraph g, Resource list) throws DatabaseException {
        try {
            return ListUtils.toList(g, list);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    public static boolean removeElement(WriteGraph g, Resource list, Resource element) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource prev = list;
        Resource cur = g.getSingleObject(list, L0.List_Next);
        while (!cur.equals(list)) {
            Resource el = g.getPossibleObject(cur, L0.List_Element);
            Resource next = g.getSingleObject(cur, L0.List_Next);
            if (element.equals(el)) {
                g.deny(cur);
                g.claim(prev, L0.List_Next, next);
                return true;
            }
            prev = cur;
            cur = next;
        }
        return false;
    }

    public static boolean removeElements(WriteGraph g, Resource list, Set<Resource> elements) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource prev = list;
        Resource cur = g.getSingleObject(list, L0.List_Next);
        boolean removed = false;
        while (!cur.equals(list)) {
            Resource el = g.getPossibleObject(cur, L0.List_Element);
            Resource next = g.getSingleObject(cur, L0.List_Next);
            if (elements.contains(el)) {
                g.deny(cur);
                g.claim(prev, L0.List_Next, next);
                removed = true;
            } else {
                prev = cur;
            }
            cur = next;
        }
        return removed;
    }

    private static void getListNodes(ReadGraph g, List<Resource> result, Resource list) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource cur = g.getSingleObject(list, L0.List_Next);
        while (!cur.equals(list)) {
            result.add(cur);
            cur = g.getSingleObject(cur, L0.List_Next);
        }
    }

    public static List<Resource> getListNodes(ReadGraph g, Resource list) throws DatabaseException {
        ArrayList<Resource> result = new ArrayList<Resource>();
        ListUtils.getListNodes(g, result, list);
        return result;
    }

    public static Resource getNode(ReadGraph g, Resource list, Resource element) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource cur = g.getSingleObject(list, L0.List_Next);
        while (!cur.equals(list)) {
            Resource el = g.getPossibleObject(cur, L0.List_Element);
            if (element.equals(el)) {
                return cur;
            }
            cur = g.getSingleObject(cur, L0.List_Next);
        }
        return null;
    }

    public static boolean swapWithPrevious(WriteGraph g, Resource list, Resource element) throws DatabaseException {
        Resource node = ListUtils.getNode((ReadGraph)g, list, element);
        if (node == null) {
            return false;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource prev = g.getSingleObject(node, L0.List_Previous);
        if (list.equals(prev)) {
            return false;
        }
        ListUtils.swap(g, list, node, prev);
        return true;
    }

    public static boolean swapWithNext(WriteGraph g, Resource list, Resource element) throws DatabaseException {
        Resource node = ListUtils.getNode((ReadGraph)g, list, element);
        if (node == null) {
            return false;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource next = g.getSingleObject(node, L0.List_Next);
        if (list.equals(next)) {
            return false;
        }
        ListUtils.swap(g, list, node, next);
        return true;
    }

    private static void swap(WriteGraph g, Resource list, Resource a, Resource b) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource ea = g.getPossibleObject(a, L0.List_Element);
        Resource eb = g.getPossibleObject(b, L0.List_Element);
        g.deny(a, L0.List_Element);
        g.deny(b, L0.List_Element);
        Resource elementPredicate = ListUtils.getElementPredicate((ReadGraph)g, list);
        if (eb != null) {
            g.claim(a, elementPredicate, eb);
        }
        if (ea != null) {
            g.claim(b, elementPredicate, ea);
        }
    }

    public static Resource getElementPredicate(ReadGraph g, Resource list) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource predicate = g.getPossibleObject(list, L0.List_ElementPredicate);
        if (predicate != null) {
            return predicate;
        }
        return g.isInstanceOf(list, L0.ListWithInverses) ? L0.List_ElementWithInverse : L0.List_Element;
    }

    public static Resource getListElementList(ReadGraph g, Resource element) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        return g.getSingleObject(element, L0.IsOwnedBy);
    }
}

