/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn.lru;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.simantics.acorn.AcornKey;
import org.simantics.acorn.ClusterManager;
import org.simantics.acorn.exception.AcornAccessVerificationException;
import org.simantics.acorn.exception.IllegalAcornStateException;
import org.simantics.acorn.lru.LRUObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRU<MapKey, MapValue extends LRUObject<MapKey, MapValue>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LRU.class);
    public static boolean VERIFY = true;
    private final long swapTime = 5000000000L;
    private final int swapSize = 200;
    private final HashMap<MapKey, MapValue> map = new HashMap();
    private final TreeMap<Long, MapKey> priorityQueue = new TreeMap();
    private final Semaphore mutex = new Semaphore(1);
    private final String identifier;
    private AcornKey writeDir;
    private Thread mutexOwner;
    public Map<String, WriteRunnable> pending = new HashMap<String, WriteRunnable>();
    protected final ClusterManager manager;
    static int readCounter = 0;
    static int writeCounter = 0;
    ScheduledThreadPoolExecutor writers;

    public LRU(ClusterManager manager, String identifier, AcornKey writeDir) {
        this.manager = manager;
        this.identifier = identifier;
        this.writeDir = writeDir;
        this.resume();
    }

    public void acquireMutex() throws IllegalAcornStateException {
        try {
            while (!this.mutex.tryAcquire(3L, TimeUnit.SECONDS)) {
                LOGGER.info("Mutex is taking a long time to acquire - owner is " + this.mutexOwner);
            }
            if (VERIFY) {
                this.mutexOwner = Thread.currentThread();
            }
        }
        catch (InterruptedException e) {
            throw new IllegalAcornStateException(e);
        }
    }

    public void releaseMutex() {
        this.mutex.release();
        this.mutexOwner = null;
    }

    public void shutdown() {
        this.writers.shutdown();
        try {
            this.writers.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void resume() {
        this.writers = new ScheduledThreadPoolExecutor(2, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, String.valueOf(LRU.this.identifier) + " File Writer");
            }
        });
    }

    public void persist(ArrayList<String> state) throws IllegalAcornStateException {
        this.acquireMutex();
        try {
            try {
                for (LRUObject value : this.values()) {
                    value.acquireMutex();
                    try {
                        value.persist();
                    }
                    finally {
                        value.releaseMutex();
                    }
                    this.waitPending(value, false);
                    value.acquireMutex();
                    try {
                        state.add(value.getStateKey());
                    }
                    finally {
                        value.releaseMutex();
                    }
                }
            }
            catch (IllegalAcornStateException e) {
                throw e;
            }
            catch (IOException e) {
                throw new IllegalAcornStateException("Unable to waitPending for " + this.identifier, e);
            }
            catch (Throwable t) {
                throw new IllegalAcornStateException("Fatal error occured for " + this.identifier, t);
            }
        }
        finally {
            this.releaseMutex();
        }
    }

    public MapValue getWithoutMutex(MapKey key) throws AcornAccessVerificationException, IllegalAcornStateException {
        this.acquireMutex();
        try {
            MapValue MapValue = this.get(key);
            return MapValue;
        }
        finally {
            this.releaseMutex();
        }
    }

    public MapValue purge(MapKey id) {
        return (MapValue)((LRUObject)this.map.remove(id));
    }

    public MapValue get(MapKey key) throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        return (MapValue)((LRUObject)this.map.get(key));
    }

    public void map(MapValue info) throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        this.map.put(((LRUObject)info).getKey(), info);
    }

    public Collection<MapValue> values() throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        return this.map.values();
    }

    public boolean swapForced() throws IllegalAcornStateException, AcornAccessVerificationException {
        this.acquireMutex();
        try {
            boolean bl = this.swap(0L, 0, null);
            return bl;
        }
        finally {
            this.releaseMutex();
        }
    }

    public boolean swap(long lifeTime, int targetSize) throws AcornAccessVerificationException, IllegalAcornStateException {
        if (VERIFY) {
            this.verifyAccess();
        }
        return this.swap(lifeTime, targetSize, null);
    }

    public void setWriteDir(AcornKey dir) {
        this.writeDir = dir;
    }

    void insert(MapValue info, long accessTime) throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        this.map.put(((LRUObject)info).getKey(), info);
        this.priorityQueue.put(accessTime, ((LRUObject)info).getKey());
    }

    boolean tryRefresh(MapValue info) throws AcornAccessVerificationException, IllegalAcornStateException {
        if (VERIFY) {
            this.verifyAccess();
        }
        if (!((LRUObject)info).tryAcquireMutex()) {
            return false;
        }
        try {
            this.priorityQueue.remove(((LRUObject)info).getLastAccessTime());
            ((LRUObject)info).accessed();
            this.map.put(((LRUObject)info).getKey(), info);
            this.priorityQueue.put(((LRUObject)info).getLastAccessTime(), ((LRUObject)info).getKey());
            return true;
        }
        finally {
            ((LRUObject)info).releaseMutex();
        }
    }

    void refresh(MapValue info, boolean needMutex) throws AcornAccessVerificationException, IllegalAcornStateException {
        if (VERIFY) {
            if (!needMutex) {
                this.verifyAccess();
            }
            ((LRUObject)info).verifyAccess();
        }
        if (needMutex) {
            this.acquireMutex();
        }
        try {
            try {
                this.priorityQueue.remove(((LRUObject)info).getLastAccessTime());
                ((LRUObject)info).accessed();
                this.map.put(((LRUObject)info).getKey(), info);
                this.priorityQueue.put(((LRUObject)info).getLastAccessTime(), ((LRUObject)info).getKey());
            }
            catch (AcornAccessVerificationException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new IllegalAcornStateException(t);
            }
        }
        finally {
            if (needMutex) {
                this.releaseMutex();
            }
        }
    }

    int size() throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        return this.priorityQueue.size();
    }

    boolean swap(MapKey excluded) throws AcornAccessVerificationException, IllegalAcornStateException {
        if (VERIFY) {
            this.verifyAccess();
        }
        return this.swap(5000000000L, 200, excluded);
    }

    boolean swap(long lifeTime, int targetSize, MapKey excluded) throws AcornAccessVerificationException, IllegalAcornStateException {
        MapValue valueToSwap;
        if (VERIFY) {
            this.verifyAccess();
        }
        if ((valueToSwap = this.getValueToSwap(lifeTime, targetSize, excluded)) != null && ((LRUObject)valueToSwap).tryAcquireMutex()) {
            try {
                if (((LRUObject)valueToSwap).canBePersisted()) {
                    ((LRUObject)valueToSwap).persist();
                    return true;
                }
            }
            catch (Throwable t) {
                throw new IllegalAcornStateException(t);
            }
            finally {
                ((LRUObject)valueToSwap).releaseMutex();
            }
        }
        return false;
    }

    private MapValue getValueToSwap1(long lifeTime, int targetSize, MapKey excluded) throws AcornAccessVerificationException, IllegalAcornStateException {
        if (VERIFY) {
            this.verifyAccess();
        }
        int i = 0;
        while (i < 10) {
            long candidate = this.getSwapCandidate(lifeTime, targetSize);
            if (candidate == 0L) {
                return null;
            }
            MapKey key = this.priorityQueue.remove(candidate);
            if (!key.equals(excluded)) {
                return (MapValue)((LRUObject)this.map.get(key));
            }
            this.tryRefresh((LRUObject)this.map.get(key));
            ++i;
        }
        return null;
    }

    private MapValue getValueToSwap(long lifeTime, int targetSize, MapKey excluded) throws AcornAccessVerificationException, IllegalAcornStateException {
        if (VERIFY) {
            this.verifyAccess();
        }
        int i = 0;
        while (i < 10) {
            MapValue value = this.getValueToSwap1(lifeTime, targetSize, excluded);
            if (value == null) {
                return null;
            }
            if (((LRUObject)value).tryAcquireMutex()) {
                try {
                    if (((LRUObject)value).canBePersisted()) {
                        MapValue MapValue = value;
                        return MapValue;
                    }
                    this.refresh(value, false);
                }
                finally {
                    ((LRUObject)value).releaseMutex();
                }
            }
            ++i;
        }
        return null;
    }

    private long getSwapCandidate(long lifeTime, int targetSize) throws AcornAccessVerificationException {
        Long lowest;
        if (VERIFY) {
            this.verifyAccess();
        }
        if (this.priorityQueue.isEmpty()) {
            return 0L;
        }
        long currentTime = System.nanoTime();
        if (currentTime - (lowest = this.priorityQueue.firstKey()) > lifeTime || this.priorityQueue.size() > targetSize) {
            return lowest;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean persist(Object object_) throws AcornAccessVerificationException {
        LRUObject object = (LRUObject)object_;
        if (VERIFY) {
            object.verifyAccess();
        }
        if (object.isDirty()) {
            if (!object.canBePersisted()) {
                return false;
            }
            assert (object.isResident());
            AcornKey dbKey = this.writeDir.child(object.getFileName());
            WriteRunnable runnable = new WriteRunnable(this, dbKey, object);
            Map<String, WriteRunnable> map = this.pending;
            synchronized (map) {
                WriteRunnable existing = this.pending.put(object.getKey().toString(), runnable);
                assert (existing == null);
            }
            this.writers.execute(runnable);
            object.setResident(false);
            object.setDirty(false);
            return true;
        }
        if (object.isResident()) {
            object.release();
            object.setResident(false);
            return false;
        }
        return false;
    }

    int makeResident(Object object_, boolean keepResident) throws AcornAccessVerificationException, IllegalAcornStateException {
        LRUObject object;
        block7: {
            object = (LRUObject)object_;
            if (VERIFY) {
                object.verifyAccess();
            }
            try {
                object.setForceResident(keepResident);
                if (!object.isResident()) break block7;
                this.refresh(object, true);
                return 0;
            }
            catch (IOException e) {
                throw new IllegalAcornStateException("Unable to makeResident " + this.identifier, e);
            }
        }
        this.waitPending(object, true);
        byte[] data = object.readFile();
        object.fromFile(data);
        object.setResident(true);
        this.acquireMutex();
        try {
            this.refresh(object, false);
            this.swap(5000000000L, 200, object.getKey());
        }
        finally {
            this.releaseMutex();
        }
        return data.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitPending(MapValue value, boolean hasMutex) throws IOException, AcornAccessVerificationException, IllegalAcornStateException {
        WriteRunnable runnable = null;
        boolean inProgress = false;
        Map<String, WriteRunnable> map = this.pending;
        synchronized (map) {
            runnable = this.pending.get(((LRUObject)value).getKey().toString());
            if (runnable != null) {
                WriteRunnable writeRunnable = runnable;
                synchronized (writeRunnable) {
                    if (runnable.committed) {
                        inProgress = true;
                    } else {
                        runnable.committed = true;
                    }
                }
            }
        }
        if (runnable != null) {
            if (inProgress) {
                try {
                    if (hasMutex) {
                        runnable.borrowMutex = true;
                    }
                    runnable.s.acquire();
                }
                catch (InterruptedException e) {
                    throw new IllegalAcornStateException(e);
                }
            } else {
                runnable.runReally(hasMutex);
            }
        }
    }

    public AcornKey getDirectory() {
        return this.writeDir;
    }

    protected void verifyAccess() throws AcornAccessVerificationException {
        if (this.mutex.availablePermits() != 0) {
            throw new AcornAccessVerificationException("identifier=" + this.identifier + " mutex has " + this.mutex.availablePermits() + " available permits, should be 0! Current mutexOwner is " + this.mutexOwner);
        }
    }

    public static class WriteRunnable
    implements Runnable {
        private AcornKey bytes;
        private MapValue impl;
        private boolean committed = false;
        private boolean borrowMutex = false;
        private Semaphore s = new Semaphore(0);
        final /* synthetic */ LRU this$0;

        WriteRunnable(AcornKey bytes, MapValue impl) {
            this.this$0 = var1_1;
            this.bytes = bytes;
            this.impl = impl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object MapValue = this.impl;
                synchronized (MapValue) {
                    WriteRunnable writeRunnable = this;
                    synchronized (writeRunnable) {
                        if (this.committed) {
                            return;
                        }
                        this.committed = true;
                    }
                    this.runReally(false);
                }
            }
            catch (Throwable t) {
                if (t instanceof IllegalAcornStateException) {
                    this.this$0.manager.notSafeToMakeSnapshot((IllegalAcornStateException)((Object)t));
                } else {
                    this.this$0.manager.notSafeToMakeSnapshot(new IllegalAcornStateException(t));
                }
                t.printStackTrace();
                LOGGER.error("Exception happened in WriteRunnable.run", t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runWithMutex() throws IOException, IllegalAcornStateException, AcornAccessVerificationException {
            try {
                assert (!((LRUObject)this.impl).isResident());
                assert (!((LRUObject)this.impl).isDirty());
                ((LRUObject)this.impl).toFile(this.bytes);
            }
            catch (Throwable throwable) {
                Map<String, WriteRunnable> map = this.this$0.pending;
                synchronized (map) {
                    this.this$0.pending.remove(((LRUObject)this.impl).getKey().toString());
                    this.s.release(Integer.MAX_VALUE);
                }
                throw throwable;
            }
            Map<String, WriteRunnable> map = this.this$0.pending;
            synchronized (map) {
                this.this$0.pending.remove(((LRUObject)this.impl).getKey().toString());
                this.s.release(Integer.MAX_VALUE);
            }
        }

        public void runReally(boolean hasMutex) throws IOException, IllegalAcornStateException, AcornAccessVerificationException {
            if (hasMutex) {
                this.runWithMutex();
            } else {
                boolean gotMutex = ((LRUObject)this.impl).tryAcquireMutex();
                boolean done = false;
                int count = 0;
                long startTime = 0L;
                while (!done) {
                    if (gotMutex || this.borrowMutex) {
                        this.runWithMutex();
                        done = true;
                        continue;
                    }
                    if (count % 10 == 0) {
                        LOGGER.warn("Retry mutex acquire");
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    gotMutex = ((LRUObject)this.impl).tryAcquireMutex();
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - startTime <= 10L) continue;
                    startTime = currentTime;
                    ++count;
                }
                if (gotMutex) {
                    ((LRUObject)this.impl).releaseMutex();
                }
            }
        }
    }
}

