/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn.lru;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.simantics.acorn.AcornKey;
import org.simantics.acorn.ClusterManager;
import org.simantics.acorn.Persistable;
import org.simantics.acorn.cluster.ClusterImpl;
import org.simantics.acorn.cluster.ClusterSmall;
import org.simantics.acorn.exception.AcornAccessVerificationException;
import org.simantics.acorn.exception.IllegalAcornStateException;
import org.simantics.acorn.internal.ClusterSupport2;
import org.simantics.acorn.lru.ClusterUpdateState;
import org.simantics.acorn.lru.LRU;
import org.simantics.acorn.lru.LRUObject;
import org.simantics.compressions.CompressionCodec;
import org.simantics.compressions.Compressions;
import org.simantics.db.ClusterCreator;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.SDBException;
import org.simantics.db.service.Bytes;
import org.simantics.db.service.ClusterUID;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterInfo
extends LRUObject<ClusterUID, ClusterInfo>
implements Persistable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterInfo.class);
    private final ClusterManager manager;
    private ClusterImpl cluster;
    public int changeSetId;
    private ClusterUpdateState updateState;
    public static final String COMPRESSION = "LZ4";
    private static ClusterDecompressor decompressor = new ClusterDecompressor();

    public ClusterInfo(ClusterManager manager, LRU<ClusterUID, ClusterInfo> LRU2, AcornKey readDirectory, ClusterUID uid, int offset, int length) throws AcornAccessVerificationException {
        super(LRU2, manager.getFileCache(), uid, readDirectory, String.valueOf(uid.toString()) + ".cluster", offset, length, false, false);
        this.manager = manager;
        this.cluster = null;
        LRU2.map(this);
    }

    public ClusterInfo(ClusterManager manager, LRU<ClusterUID, ClusterInfo> LRU2, ClusterImpl cluster) throws AcornAccessVerificationException, IllegalAcornStateException {
        super(LRU2, manager.getFileCache(), cluster.getClusterUID(), LRU2.getDirectory(), String.valueOf(cluster.getClusterUID().toString()) + ".cluster", true, true);
        this.manager = manager;
        this.cluster = cluster;
        LRU2.insert(this, this.accessTime);
        LRU2.swap((ClusterUID)this.getKey());
    }

    public <T> T clone(ClusterUID uid, ClusterCreator creator) throws IOException, AcornAccessVerificationException, IllegalAcornStateException {
        this.acquireMutex();
        try {
            if (this.isResident()) {
                ClusterImpl.ClusterTables tables = this.cluster.store();
                Object object = creator.create(uid, tables.bytes, tables.ints, tables.longs);
                return (T)object;
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IllegalAcornStateException(t);
        }
        finally {
            this.releaseMutex();
        }
        this.LRU.waitPending(this, false);
        this.acquireMutex();
        try {
            if (this.isResident()) {
                ClusterImpl.ClusterTables tables = this.cluster.store();
                Object object = creator.create(uid, tables.bytes, tables.ints, tables.longs);
                return (T)object;
            }
            byte[] data = this.readFile();
            ClusterImpl.ClusterTables tables = new ClusterImpl.ClusterTables();
            this.loadCluster((ClusterUID)this.getKey(), this.manager.support, data, tables);
            Object object = creator.create(uid, tables.bytes, tables.ints, tables.longs);
            return (T)object;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IllegalAcornStateException(t);
        }
        finally {
            this.releaseMutex();
        }
    }

    public void loadCluster(ClusterUID uid, ClusterSupport2 support, byte[] data, ClusterImpl.ClusterTables tables) throws IOException {
        ClusterImpl.ClusterTables ts = decompressor.readCluster(uid, data);
        tables.bytes = ts.bytes;
        tables.ints = ts.ints;
        tables.longs = ts.longs;
    }

    public ClusterImpl loadCluster(ClusterUID uid, ClusterSupport2 support, byte[] data) throws IOException {
        ClusterImpl.ClusterTables tables = decompressor.readCluster(uid, data);
        try {
            return ClusterImpl.make(support, tables.longs, tables.ints, tables.bytes, support, support.getClusterKeyByClusterUIDOrMake(uid));
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void fromFile(byte[] data) {
        try {
            this.cluster = this.loadCluster((ClusterUID)this.getKey(), this.manager.support, data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected Pair<byte[], Integer> toBytes() throws IllegalAcornStateException {
        try {
            byte[] raw = null;
            if (this.cluster instanceof ClusterSmall) {
                raw = this.cluster.storeBytes();
            } else {
                ClusterImpl.ClusterTables tables = this.cluster.store();
                raw = new byte[12 + tables.bytes.length + (tables.ints.length << 2) + (tables.longs.length << 3)];
                Bytes.writeLE((byte[])raw, (int)0, (int)tables.bytes.length);
                Bytes.writeLE((byte[])raw, (int)4, (int)tables.ints.length);
                Bytes.writeLE((byte[])raw, (int)8, (int)tables.longs.length);
                System.arraycopy(tables.bytes, 0, raw, 12, tables.bytes.length);
                int offset = 12 + tables.bytes.length;
                int i = 0;
                while (i < tables.ints.length) {
                    Bytes.writeLE((byte[])raw, (int)offset, (int)tables.ints[i]);
                    ++i;
                    offset += 4;
                }
                i = 0;
                while (i < tables.longs.length) {
                    Bytes.writeLE8((byte[])raw, (int)offset, (long)tables.longs[i]);
                    ++i;
                    offset += 8;
                }
            }
            byte[] result = new byte[raw.length + raw.length / 8];
            CompressionCodec codec = Compressions.get((String)COMPRESSION);
            ByteBuffer input = ByteBuffer.wrap(raw);
            ByteBuffer output = ByteBuffer.wrap(result);
            int compressedSize = codec.compressBuffer(input, 0, raw.length, output, 0);
            Bytes.writeLE((byte[])result, (int)compressedSize, (int)raw.length);
            Pair pair = Pair.make((Object)result, (Object)(compressedSize + 4));
            return pair;
        }
        catch (Throwable t) {
            throw new IllegalAcornStateException(t);
        }
        finally {
            this.release();
        }
    }

    @Override
    void release() {
        this.cluster = null;
    }

    @Override
    String getExtension() {
        return "cluster";
    }

    public void scheduleUpdate() throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        if (this.updateState == null) {
            this.updateState = new ClusterUpdateState((ClusterUID)this.getKey());
        }
        this.updateState.incRef();
    }

    public ClusterImpl getForUpdate() throws SDBException {
        this.acquireMutex();
        try {
            assert (this.updateState != null);
            this.makeResident();
            this.setDirty(true);
            this.updateState.beginUpdate();
            ClusterImpl clusterImpl = this.cluster;
            return clusterImpl;
        }
        catch (AcornAccessVerificationException | IllegalAcornStateException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IllegalAcornStateException(t);
        }
        finally {
            this.releaseMutex();
        }
    }

    public void update(ClusterImpl clu) throws AcornAccessVerificationException, IllegalAcornStateException {
        if (VERIFY) {
            this.verifyAccess();
        }
        this.makeResident();
        this.cluster = clu;
        this.updateState.endUpdate();
        this.updateState = this.updateState.decRef();
    }

    public ClusterImpl getCluster() throws AcornAccessVerificationException, IllegalAcornStateException {
        if (VERIFY) {
            this.verifyAccess();
        }
        this.makeResident();
        return this.cluster;
    }

    @Override
    public boolean canBePersisted() throws AcornAccessVerificationException {
        ClusterUpdateState state;
        if (VERIFY) {
            this.verifyAccess();
        }
        if ((state = this.getUpdateState()) != null) {
            return false;
        }
        if (!super.canBePersisted()) {
            return false;
        }
        if (this.updateState == null) {
            return true;
        }
        return !this.updateState.inUpdate;
    }

    private ClusterUpdateState getUpdateState() throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        return this.updateState;
    }

    private ClusterUpdateState getUpdateStateWithoutMutex() throws IllegalAcornStateException {
        try {
            this.acquireMutex();
            ClusterUpdateState clusterUpdateState = this.getUpdateState();
            return clusterUpdateState;
        }
        catch (Throwable t) {
            throw new IllegalAcornStateException(t);
        }
        finally {
            this.releaseMutex();
        }
    }

    public void waitForUpdates() throws IllegalAcornStateException {
        ClusterUpdateState state = this.getUpdateStateWithoutMutex();
        if (state != null) {
            long start = System.nanoTime();
            state.waitForUpdates();
            long duration = System.nanoTime() - start;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Wait updates to cluster " + this.getKey() + " for " + 1.0E-6 * (double)duration + "ms.");
            }
        }
    }

    @Override
    protected boolean overwrite() {
        return true;
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    static class ClusterDecompressor {
        byte[] decompressBuffer = new byte[0x100000];

        ClusterDecompressor() {
        }

        public synchronized ClusterImpl.ClusterTables readCluster(ClusterUID uid, byte[] compressed) throws IOException {
            int deflatedSize = Bytes.readLE4((byte[])compressed, (int)(compressed.length - 4));
            if (this.decompressBuffer.length < deflatedSize) {
                this.decompressBuffer = new byte[Math.max(3 * this.decompressBuffer.length / 2, deflatedSize)];
            }
            CompressionCodec codec = Compressions.get((String)ClusterInfo.COMPRESSION);
            ByteBuffer input = ByteBuffer.wrap(compressed);
            ByteBuffer output = ByteBuffer.wrap(this.decompressBuffer);
            int decompressedSize = codec.decompressBuffer(input, 0, compressed.length - 4, output, 0, this.decompressBuffer.length);
            assert (decompressedSize <= this.decompressBuffer.length);
            int byteLength = Bytes.readLE4((byte[])this.decompressBuffer, (int)0);
            int intLength = Bytes.readLE4((byte[])this.decompressBuffer, (int)4);
            int longLength = Bytes.readLE4((byte[])this.decompressBuffer, (int)8);
            byte[] bytes = new byte[byteLength];
            int[] ints = new int[intLength];
            long[] longs = new long[longLength];
            System.arraycopy(this.decompressBuffer, 12, bytes, 0, byteLength);
            int offset = 12 + byteLength;
            int i = 0;
            while (i < intLength) {
                ints[i] = Bytes.readLE4((byte[])this.decompressBuffer, (int)offset);
                ++i;
                offset += 4;
            }
            i = 0;
            while (i < longLength) {
                longs[i] = Bytes.readLE8((byte[])this.decompressBuffer, (int)offset);
                ++i;
                offset += 8;
            }
            ClusterImpl.ClusterTables result = new ClusterImpl.ClusterTables();
            result.bytes = bytes;
            result.ints = ints;
            result.longs = longs;
            return result;
        }
    }
}

