/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.simantics.acorn.MainProgram;
import org.simantics.acorn.exception.AcornAccessVerificationException;
import org.simantics.acorn.exception.IllegalAcornStateException;
import org.simantics.acorn.lru.ClusterStreamChunk;
import org.simantics.acorn.lru.ClusterUpdateOperation;
import org.simantics.db.service.ClusterUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OperationQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationQueue.class);
    private final MainProgram mainProgram;
    private final LinkedList<ClusterStreamChunk> operations = new LinkedList();
    private final LinkedList<MainProgram.MainProgramRunnable> tasks = new LinkedList();
    private long currentChangeSetId = -1L;
    private int nextChunkId = 0;

    OperationQueue(MainProgram mainProgram) {
        this.mainProgram = mainProgram;
    }

    synchronized void scheduleTask(MainProgram.MainProgramRunnable task) {
        this.mainProgram.assertNoMainProgramThread();
        this.tasks.add(task);
        this.notify();
    }

    synchronized void startTransaction(long id) {
        this.currentChangeSetId = id;
        this.nextChunkId = 0;
    }

    synchronized ClusterStreamChunk commitLast() {
        ClusterStreamChunk last;
        ClusterStreamChunk clusterStreamChunk = last = this.operations.isEmpty() ? null : this.operations.getLast();
        if (last != null) {
            last.commit();
            this.notifyAll();
        }
        return last;
    }

    synchronized void scheduleUpdate(ClusterUpdateOperation operation) throws AcornAccessVerificationException, IllegalAcornStateException {
        ClusterStreamChunk last;
        ClusterStreamChunk clusterStreamChunk = last = this.operations.isEmpty() ? null : this.operations.getLast();
        if (last == null || last.isCommitted()) {
            String id = this.currentChangeSetId + "-" + this.nextChunkId++;
            last = new ClusterStreamChunk(this.mainProgram.clusters, this.mainProgram.clusters.streamLRU, id);
            this.operations.add(last);
        }
        String chunkId = (String)last.getKey();
        int chunkOffset = last.operations.size();
        operation.scheduled(String.valueOf(chunkId) + "." + chunkOffset);
        last.addOperation(operation);
        this.notify();
    }

    synchronized void pumpTasks(List<MainProgram.MainProgramRunnable> todo) {
        this.mainProgram.assertMainProgramThread();
        todo.addAll(this.tasks);
        this.tasks.clear();
    }

    synchronized void pumpUpdates(TreeMap<ClusterUID, List<ClusterUpdateOperation>> updates) {
        this.mainProgram.assertMainProgramThread();
        while (!this.operations.isEmpty() && updates.size() < 100) {
            ClusterStreamChunk chunk = this.operations.pollFirst();
            int i = chunk.nextToProcess;
            while (i < chunk.operations.size()) {
                ClusterUpdateOperation o = chunk.operations.get(i);
                ClusterUID uid = o.uid;
                List<ClusterUpdateOperation> ops = updates.get(uid);
                if (ops == null) {
                    ops = new ArrayList<ClusterUpdateOperation>();
                    updates.put(uid, ops);
                }
                ops.add(o);
                ++i;
            }
            chunk.nextToProcess = chunk.operations.size();
            if (chunk.isCommitted()) continue;
            assert (this.operations.isEmpty());
            this.operations.add(chunk);
            break;
        }
    }

    synchronized boolean isEmpty() {
        this.mainProgram.assertMainProgramThread();
        return this.operations.isEmpty();
    }

    synchronized long waitFor() {
        this.mainProgram.assertMainProgramThread();
        if (!this.operations.isEmpty() || !this.tasks.isEmpty()) {
            return 0L;
        }
        long start = System.nanoTime();
        try {
            this.wait(5000L);
        }
        catch (InterruptedException e) {
            LOGGER.error("Unexpected interruption", (Throwable)e);
        }
        return System.nanoTime() - start;
    }
}

