/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.requests;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.utils.page.PageDesc;
import org.simantics.utils.strings.AlphanumComparator;

public class Node
implements Comparable<Node> {
    public static final String PROP_DOC_RESOURCES = "doc";
    public static final Comparator<Node> CASE_INSENSITIVE_COMPARATOR = (o1, o2) -> AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)o1.getName(), (Object)o2.getName());
    private final Node parent;
    private final List<Node> children = new ArrayList<Node>();
    private final List<Node> unmodifiableChildren = Collections.unmodifiableList(this.children);
    private final Resource diagram;
    private final ResourceArray definingResource;
    private final String name;
    private PageDesc pageDesc;
    private String rvi;
    private Map<String, Object> properties;

    public Node(Node parent, String name, Resource diagram, Resource ... definingResources) {
        if (definingResources.length == 0) {
            throw new IllegalArgumentException("must provide at least one defining resource");
        }
        this.parent = parent;
        this.name = name;
        this.diagram = diagram;
        this.definingResource = new ResourceArray(definingResources);
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public Node cloneWithoutChildren(Node parent) {
        Node clone = new Node(parent, this.name, this.diagram, this.definingResource.resources);
        if (this.properties != null) {
            clone.properties = new HashMap<String, Object>(this.properties);
        }
        clone.setRVI(this.rvi);
        clone.setPageDesc(this.pageDesc);
        return clone;
    }

    public Node getParent() {
        return this.parent;
    }

    public Resource getDiagramResource() {
        return this.diagram;
    }

    public ResourceArray getDefiningResources() {
        return this.definingResource;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return (this.parent != null ? this.parent : "") + "/" + this.name + this.definingResource;
    }

    public String toFullString() {
        return (this.parent != null ? this.parent : "") + "/" + this.name + this.definingResource + (this.properties != null ? " " + this.properties : "");
    }

    public void addChild(Node child) {
        this.children.add(child);
    }

    public void removeChild(Node child) {
        this.children.remove(child);
    }

    public Collection<Node> getChildren() {
        return this.unmodifiableChildren;
    }

    public void setPageDesc(PageDesc pageDesc) {
        this.pageDesc = pageDesc;
    }

    public void setRVI(String rvi) {
        this.rvi = rvi;
    }

    public String getRVI() {
        return this.rvi;
    }

    public PageDesc getPageDesc() {
        return this.pageDesc;
    }

    public Node setProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(key, value);
        return this;
    }

    public boolean hasProperty(String key) {
        return this.properties != null ? this.properties.containsKey(key) : false;
    }

    public <T> T getProperty(String key) {
        return (T)(this.properties == null ? null : this.properties.get(key));
    }

    @Override
    public int compareTo(Node o) {
        int ret = this.name.compareTo(o.name);
        return ret;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.diagram == null ? 0 : this.diagram.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.definingResource == null ? 0 : this.definingResource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if (this.diagram == null ? other.diagram != null : !this.diagram.equals(other.diagram)) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return !(this.definingResource == null ? other.definingResource != null : !this.definingResource.equals((Object)other.definingResource));
    }

    public void print(PrintStream out) {
        this.print0(out, 0);
    }

    private void print0(PrintStream out, int indent) {
        int i = 0;
        while (i < indent) {
            out.print('\t');
            ++i;
        }
        out.println(this.toFullString());
        for (Node child : this.getChildren()) {
            child.print0(out, indent + 1);
        }
    }
}

