/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.preferences;

import java.nio.charset.Charset;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.simantics.modeling.preferences.CSVPreferences;

public class CSVPreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        IScopeContext context = DefaultScope.INSTANCE;
        IEclipsePreferences node = context.getNode("org.simantics.modeling");
        Locale locale = Locale.getDefault();
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        String decimalSeparator = String.valueOf(symbols.getDecimalSeparator());
        node.put("csv.decimal.separator", decimalSeparator);
        String valueSeparator = decimalSeparator.equals(",") ? "\\t" : ",";
        node.put("csv.value.separator", valueSeparator);
        node.put("csv.file.extension", ".txt");
        node.putDouble("csv.start", CSVPreferences.DEFAULT_CSV_START_TIME.doubleValue());
        node.putDouble("csv.step", CSVPreferences.DEFAULT_CSV_TIME_STEP.doubleValue());
        node.putBoolean("csv.resample", CSVPreferences.DEFAULT_CSV_RESAMPLE.booleanValue());
        node.put("csv.sampling.mode", CSVPreferences.DEFAULT_CSV_SAMPLING_MODE);
        node.putInt("csv.format.time.digits", 9);
        node.putInt("csv.format.float.digits", 7);
        node.putInt("csv.format.double.digits", 15);
        node.put("csv.output.encoding", Charset.defaultCharset().name());
    }
}

